/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.itemfilters.item;

import dev.latvian.mods.itemfilters.api.CustomFilter;
import dev.latvian.mods.itemfilters.api.ItemFiltersAPI;
import dev.latvian.mods.itemfilters.api.StringValueFilterVariant;
import dev.latvian.mods.itemfilters.item.StringValueData;
import dev.latvian.mods.itemfilters.item.StringValueFilterItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class CustomFilterItem
extends StringValueFilterItem {
    @Override
    public StringValueData<?> createData(ItemStack stack) {
        return new CustomFilterData(stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Collection<StringValueFilterVariant> getValueVariants(ItemStack stack) {
        ArrayList<StringValueFilterVariant> variants = new ArrayList<StringValueFilterVariant>();
        for (CustomFilter filter : ItemFiltersAPI.CUSTOM_FILTERS.values()) {
            variants.add(new StringValueFilterVariant(filter.id));
        }
        return variants;
    }

    @Override
    public boolean filter(ItemStack filter, ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        CustomFilterData v = (CustomFilterData)this.getStringValueData(filter);
        return v.getValue() != null && ((CustomFilter)v.getValue()).predicate.test(stack);
    }

    @Override
    public boolean filterItem(ItemStack filter, Item item) {
        if (item == Items.f_41852_) {
            return false;
        }
        CustomFilterData v = (CustomFilterData)this.getStringValueData(filter);
        return v.getValue() != null && ((CustomFilter)v.getValue()).getItems().contains(item);
    }

    @Override
    public void getItems(ItemStack filter, Set<Item> set) {
        CustomFilterData v = (CustomFilterData)this.getStringValueData(filter);
        if (v.getValue() != null) {
            set.addAll(((CustomFilter)v.getValue()).getItems());
        }
    }

    public static class CustomFilterData
    extends StringValueData<CustomFilter> {
        public CustomFilterData(ItemStack is) {
            super(is);
        }

        @Override
        @Nullable
        protected CustomFilter fromString(String s) {
            return s.isEmpty() ? null : ItemFiltersAPI.CUSTOM_FILTERS.get(s);
        }

        @Override
        protected String toString(CustomFilter value) {
            return value == null ? "" : value.id;
        }

        @Override
        public Component getValueAsComponent() {
            CustomFilter v = (CustomFilter)this.getValue();
            return v == null ? TextComponent.f_131282_ : v.displayName;
        }
    }
}

