/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.hardermonsterboats.util;

import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Utility {
    public static final int FOUR_SECONDS = 80;
    public static final int TWO_SECONDS = 40;
    public static final float Pct00 = 0.0f;
    public static final float Pct02 = 0.02f;
    public static final float Pct05 = 0.05f;
    public static final float Pct09 = 0.09f;
    public static final float Pct16 = 0.16f;
    public static final float Pct25 = 0.25f;
    public static final float Pct50 = 0.5f;
    public static final float Pct75 = 0.75f;
    public static final float Pct84 = 0.84f;
    public static final float Pct89 = 0.89f;
    public static final float Pct91 = 0.91f;
    public static final float Pct95 = 0.95f;
    public static final float Pct99 = 0.99f;
    public static final float Pct100 = 1.0f;
    private static final Logger LOGGER = LogManager.getLogger();

    public static void debugMsg(int level, String dMsg) {
        LOGGER.info("L" + level + ":" + dMsg);
    }

    public static void debugMsg(int level, BlockPos pos, String dMsg) {
        LOGGER.info("L" + level + " (" + pos.m_123341_() + "," + pos.m_123342_() + "," + pos.m_123343_() + "): " + dMsg);
    }

    public static void debugMsg(int level, LivingEntity le, String dMsg) {
        LOGGER.info("L" + level + " (" + le.m_142538_().m_123341_() + "," + le.m_142538_().m_123342_() + "," + le.m_142538_().m_123343_() + "): " + dMsg);
    }

    public static void sendBoldChat(Player p, String chatMessage, ChatFormatting textColor) {
        TextComponent component = new TextComponent(chatMessage);
        component.m_6270_(component.m_7383_().m_131136_(Boolean.valueOf(true)));
        component.m_6270_(component.m_7383_().m_131140_(textColor));
        p.m_6352_((Component)component, p.m_142081_());
    }

    public static void sendChat(Player p, String chatMessage, ChatFormatting textColor) {
        TextComponent component = new TextComponent(chatMessage);
        component.m_6270_(component.m_7383_().m_131140_(textColor));
        p.m_6352_((Component)component, p.m_142081_());
    }

    public static void updateEffect(LivingEntity e, int amplifier, MobEffect mobEffect, int duration) {
        MobEffectInstance ei = e.m_21124_(mobEffect);
        if (amplifier == 10) {
            amplifier = 20;
        }
        if (ei != null) {
            if (amplifier > ei.m_19564_()) {
                e.m_21195_(mobEffect);
            }
            if (amplifier == ei.m_19564_() && ei.m_19557_() > 10) {
                return;
            }
            if (ei.m_19557_() > 10) {
                return;
            }
            e.m_21195_(mobEffect);
        }
        e.m_7292_(new MobEffectInstance(mobEffect, duration, amplifier, true, true));
    }

    public static boolean populateEntityType(EntityType<?> et, ServerLevel level, BlockPos savePos, int range, int modifier) {
        boolean isBaby = false;
        return Utility.populateEntityType(et, level, savePos, range, modifier, isBaby);
    }

    public static boolean populateEntityType(EntityType<?> et, ServerLevel level, BlockPos savePos, int range, int modifier, boolean isBaby) {
        boolean persistant = false;
        return Utility.populateEntityType(et, level, savePos, range, modifier, persistant, isBaby);
    }

    public static boolean populateEntityType(EntityType<?> et, ServerLevel level, BlockPos savePos, int range, int modifier, boolean persistant, boolean isBaby) {
        int numZP = level.f_46441_.nextInt(range) - modifier;
        if (numZP < 0) {
            return false;
        }
        for (int i = 0; i <= numZP; ++i) {
            Mob e = (Mob)et.m_20600_(level, null, null, null, savePos.m_142127_().m_142125_(), MobSpawnType.NATURAL, true, true);
            if (persistant) {
                e.m_21530_();
            }
            e.m_6863_(isBaby);
        }
        return true;
    }

    public static boolean populateXEntityType(EntityType<?> et, ServerLevel level, BlockPos savePos, int X, boolean isBaby) {
        for (int i = 0; i < X; ++i) {
            Mob e = (Mob)et.m_20600_(level, null, null, null, savePos.m_142127_().m_142125_(), MobSpawnType.NATURAL, true, true);
            e.m_6863_(isBaby);
        }
        return true;
    }

    public static void setName(ItemStack stack, String inString) {
        CompoundTag tag = stack.m_41698_("display");
        ListTag list = new ListTag();
        list.add((Object)StringTag.m_129297_((String)inString));
        tag.m_128365_("Name", (Tag)list);
    }

    public static void setLore(ItemStack stack, String inString) {
        CompoundTag tag = stack.m_41698_("display");
        ListTag list = new ListTag();
        list.add((Object)StringTag.m_129297_((String)inString));
        tag.m_128365_("Lore", (Tag)list);
    }

    public static boolean isNotNearWebs(BlockPos pos, ServerLevel serverLevel) {
        if (serverLevel.m_8055_(pos).m_60734_() == Blocks.f_50033_) {
            return true;
        }
        if (serverLevel.m_8055_(pos.m_7494_()).m_60734_() == Blocks.f_50033_) {
            return true;
        }
        if (serverLevel.m_8055_(pos.m_7495_()).m_60734_() == Blocks.f_50033_) {
            return true;
        }
        if (serverLevel.m_8055_(pos.m_142127_()).m_60734_() == Blocks.f_50033_) {
            return true;
        }
        if (serverLevel.m_8055_(pos.m_142128_()).m_60734_() == Blocks.f_50033_) {
            return true;
        }
        if (serverLevel.m_8055_(pos.m_142126_()).m_60734_() == Blocks.f_50033_) {
            return true;
        }
        return serverLevel.m_8055_(pos.m_142125_()).m_60734_() == Blocks.f_50033_;
    }

    public static boolean isOutside(BlockPos pos, ServerLevel serverLevel) {
        return serverLevel.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos) == pos;
    }

    public static void slowFlyingMotion(LivingEntity le) {
        if (le instanceof Player && le.m_21255_()) {
            Player cp = (Player)le;
            Vec3 vec = cp.m_20184_();
            Vec3 slowedVec = vec.f_82480_ > 0.0 ? vec.m_82542_(0.17, -0.75, 0.17) : vec.m_82542_(0.17, 1.001, 0.17);
            cp.m_20256_(slowedVec);
        }
    }
}

