/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.module;

import com.yungnickyoung.minecraft.yungsapi.api.autoregister.AutoRegisterPotion;
import com.yungnickyoung.minecraft.yungsapi.autoregister.AutoRegisterField;
import com.yungnickyoung.minecraft.yungsapi.autoregister.AutoRegistrationManager;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class PotionModuleForge {
    public static final List<IBrewingRecipe> BREWING_RECIPES = new ArrayList<IBrewingRecipe>();

    public static void processEntries() {
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Potion.class, PotionModuleForge::registerPotions);
    }

    private static void registerPotions(RegistryEvent.Register<Potion> event) {
        AutoRegistrationManager.POTIONS.stream().filter(data -> !data.processed()).forEach(data -> PotionModuleForge.registerPotion(data, (IForgeRegistry<Potion>)event.getRegistry()));
    }

    private static void registerPotion(AutoRegisterField data, IForgeRegistry<Potion> registry) {
        AutoRegisterPotion autoRegisterPotion = (AutoRegisterPotion)data.object();
        MobEffectInstance mobEffectInstance = autoRegisterPotion.getMobEffectInstance();
        String name = data.name().m_135827_() + "." + data.name().m_135815_();
        Potion potion = new Potion(name, new MobEffectInstance[]{mobEffectInstance});
        autoRegisterPotion.setSupplier(() -> potion);
        potion.setRegistryName(data.name());
        registry.register((IForgeRegistryEntry)potion);
        data.markProcessed();
    }

    public static void registerBrewingRecipes() {
        BREWING_RECIPES.forEach(BrewingRecipeRegistry::addRecipe);
    }

    public record BrewingRecipe(Supplier<Potion> input, Supplier<Item> ingredient, Supplier<Potion> output) implements IBrewingRecipe
    {
        public boolean isInput(ItemStack input) {
            return PotionUtils.m_43579_((ItemStack)input) == this.input.get();
        }

        public boolean isIngredient(ItemStack ingredient) {
            return ingredient.m_41720_() == this.ingredient.get();
        }

        public ItemStack getOutput(ItemStack input, ItemStack ingredient) {
            if (!this.isInput(input) || !this.isIngredient(ingredient)) {
                return ItemStack.f_41583_;
            }
            ItemStack itemStack = new ItemStack((ItemLike)input.m_41720_());
            itemStack.m_41751_(new CompoundTag());
            PotionUtils.m_43549_((ItemStack)itemStack, (Potion)this.output.get());
            return itemStack;
        }
    }
}

