/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.module;

import com.yungnickyoung.minecraft.yungsapi.YungsApiCommon;
import com.yungnickyoung.minecraft.yungsapi.module.CompostModuleForge;
import com.yungnickyoung.minecraft.yungsapi.module.PotionModuleForge;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class PostLoadModuleForge {
    public static List<Method> METHODS = new ArrayList<Method>();

    public static void init() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(PostLoadModuleForge::commonSetup);
    }

    private static void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            METHODS.forEach(m -> {
                try {
                    m.invoke(null, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    YungsApiCommon.LOGGER.error("Unable to invoke AutoRegister method {}", (Object)m.getName());
                    YungsApiCommon.LOGGER.error("Make sure the method is static and has no parameters!");
                    throw new RuntimeException(e);
                }
                catch (NullPointerException e) {
                    String message = String.format("Attempted to invoke AutoRegister method with null object. Did you forget to include a 'static' modifier for method '%s'?", m.getName());
                    YungsApiCommon.LOGGER.error(message);
                    throw new RuntimeException(message);
                }
            });
            PotionModuleForge.registerBrewingRecipes();
            CompostModuleForge.registerCompostables();
        });
    }
}

