/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.module;

import com.yungnickyoung.minecraft.yungsapi.api.autoregister.AutoRegisterCreativeTab;
import com.yungnickyoung.minecraft.yungsapi.autoregister.AutoRegistrationManager;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class CreativeModeTabModuleForge {
    private static final Map<String, AutoRegisterCreativeTab> initializedTabs = new HashMap<String, AutoRegisterCreativeTab>();

    public static void processEntries() {
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Block.class, EventPriority.HIGHEST, CreativeModeTabModuleForge::initializeTabs);
    }

    private static void initializeTabs(RegistryEvent.Register<Block> event) {
        AutoRegistrationManager.CREATIVE_MODE_TABS.stream().filter(data -> !data.processed()).forEach(data -> {
            ResourceLocation resourceLocation = data.name();
            String name = String.format("%s.%s", resourceLocation.m_135827_(), resourceLocation.m_135815_());
            if (initializedTabs.containsKey(name)) {
                return;
            }
            AutoRegisterCreativeTab autoRegisterCreativeTab = (AutoRegisterCreativeTab)data.object();
            final Supplier<ItemStack> itemStackSupplier = autoRegisterCreativeTab.getIconItemStackSupplier();
            CreativeModeTab creativeModeTab = new CreativeModeTab(name){

                public ItemStack m_6976_() {
                    return (ItemStack)itemStackSupplier.get();
                }
            };
            autoRegisterCreativeTab.setSupplier(() -> creativeModeTab);
            initializedTabs.put(name, autoRegisterCreativeTab);
            data.markProcessed();
        });
    }
}

