/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public final class MathUtil {
    public static Vec3 getCenterAdjusted(AABB bb, double xMultiplier, double yMultiplier, double zMultiplier) {
        return new Vec3(bb.f_82288_ + (bb.f_82291_ - bb.f_82288_) * xMultiplier, bb.f_82289_ + (bb.f_82292_ - bb.f_82289_) * yMultiplier, bb.f_82290_ + (bb.f_82293_ - bb.f_82290_) * zMultiplier);
    }

    public static double distanceBetweenPoints2d(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
    }

    public static double makeNegativeRandomly(double value, Random rand) {
        return rand.nextBoolean() ? -value : value;
    }

    public static double makeNegativeRandomlyWithFavoritism(double value, Random rand, float chance) {
        return rand.nextFloat() < chance ? -value : value;
    }

    public static int getLowestValueInIntArray(int[] array) {
        int currentLowest = Integer.MAX_VALUE;
        for (int value : array) {
            if (value > currentLowest) continue;
            currentLowest = value;
        }
        return currentLowest;
    }

    public static int getBrightLightForLight(int light) {
        return light >= 175 ? light : Math.abs(light - 240);
    }

    public static float invSqrt(float x) {
        float halfX = 0.5f * x;
        int i = Float.floatToIntBits(x);
        i = 1597463007 - (i >> 1);
        x = Float.intBitsToFloat(i);
        x *= 1.5f - halfX * x * x;
        return x;
    }

    public static Vec3 lerp(Vec3 prev, Vec3 current, float ptc) {
        return prev.m_82549_(current.m_82546_(prev).m_82490_((double)ptc));
    }

    public static class CatmullRomSpline {
        private final Vec3[] points;
        private final float alpha;

        public CatmullRomSpline(Vec3[] points, SplineType splineType) {
            this.points = points;
            this.alpha = splineType.getAlpha();
        }

        private static double multiplyPoints(double point1, double point2, double multiplier1, double multiplier2) {
            return point1 * multiplier1 + point2 * multiplier2;
        }

        private static float computeT(Vec3 point1, Vec3 point2, float alpha, float offset) {
            return (float)Math.pow(point2.m_82546_(point1).m_82553_(), alpha) + offset;
        }

        public BlockPos interpolate(float progress) {
            Vec3[] points = this.points;
            float sections = points.length - 3;
            int currentPoint = (int)Math.min(Math.floor(progress * sections), (double)(sections - 1.0f));
            float alpha = this.alpha;
            Vec3 point0 = points[currentPoint];
            Vec3 point1 = points[currentPoint + 1];
            float t0 = CatmullRomSpline.computeT(point0, point1, alpha, 0.0f);
            Vec3 point2 = points[currentPoint + 2];
            Vec3 point3 = points[currentPoint + 3];
            float t1 = CatmullRomSpline.computeT(point1, point2, alpha, t0);
            float t = t0 + (progress * sections - (float)currentPoint) * (t1 - t0);
            double A1multiplier1 = (t0 - t) / t0;
            double A1multiplier2 = t / t0;
            double A1x = CatmullRomSpline.multiplyPoints(point0.f_82479_, point1.f_82479_, A1multiplier1, A1multiplier2);
            double A1y = CatmullRomSpline.multiplyPoints(point0.f_82480_, point1.f_82480_, A1multiplier1, A1multiplier2);
            double A1z = CatmullRomSpline.multiplyPoints(point0.f_82481_, point1.f_82481_, A1multiplier1, A1multiplier2);
            double A2Denominator = t1 - t0;
            double A2Multiplier1 = (double)(t1 - t) / A2Denominator;
            double A2Multiplier2 = (double)(t - t0) / A2Denominator;
            double A2x = CatmullRomSpline.multiplyPoints(point1.f_82479_, point2.f_82479_, A2Multiplier1, A2Multiplier2);
            double A2y = CatmullRomSpline.multiplyPoints(point1.f_82480_, point2.f_82480_, A2Multiplier1, A2Multiplier2);
            double A2z = CatmullRomSpline.multiplyPoints(point1.f_82481_, point2.f_82481_, A2Multiplier1, A2Multiplier2);
            float t3 = CatmullRomSpline.computeT(point2, point3, alpha, t1);
            double A3Denominator = t3 - t1;
            double A3Multiplier1 = (double)(t3 - t) / A3Denominator;
            double A3Multiplier2 = (double)(t - t1) / A3Denominator;
            double A3x = CatmullRomSpline.multiplyPoints(point2.f_82479_, point3.f_82479_, A3Multiplier1, A3Multiplier2);
            double A3y = CatmullRomSpline.multiplyPoints(point2.f_82480_, point3.f_82480_, A3Multiplier1, A3Multiplier2);
            double A3z = CatmullRomSpline.multiplyPoints(point2.f_82481_, point3.f_82481_, A3Multiplier1, A3Multiplier2);
            double B1Multiplier1 = (t1 - t) / t1;
            double B1Multiplier2 = t / t1;
            double B1x = CatmullRomSpline.multiplyPoints(A1x, A2x, B1Multiplier1, B1Multiplier2);
            double B1y = CatmullRomSpline.multiplyPoints(A1y, A2y, B1Multiplier1, B1Multiplier2);
            double B1z = CatmullRomSpline.multiplyPoints(A1z, A2z, B1Multiplier1, B1Multiplier2);
            double B2Denominator = t3 - t0;
            double B2Multiplier1 = (double)(t3 - t) / B2Denominator;
            double B2Multiplier2 = (double)(t - t0) / B2Denominator;
            double B2x = CatmullRomSpline.multiplyPoints(A2x, A3x, B2Multiplier1, B2Multiplier2);
            double B2y = CatmullRomSpline.multiplyPoints(A2y, A3y, B2Multiplier1, B2Multiplier2);
            double B2z = CatmullRomSpline.multiplyPoints(A2z, A3z, B2Multiplier1, B2Multiplier2);
            double CDenominator = t1 - t0;
            double CMultiplier1 = (double)(t1 - t) / CDenominator;
            double CMultiplier2 = (double)(t - t0) / CDenominator;
            return new BlockPos(CatmullRomSpline.multiplyPoints(B1x, B2x, CMultiplier1, CMultiplier2), CatmullRomSpline.multiplyPoints(B1y, B2y, CMultiplier1, CMultiplier2), CatmullRomSpline.multiplyPoints(B1z, B2z, CMultiplier1, CMultiplier2));
        }

        public static enum SplineType {
            STANDARD(0.0f),
            CENTRIPETAL(0.5f),
            CHORDAL(1.0f);

            private final float alpha;

            private SplineType(float alpha) {
                this.alpha = alpha;
            }

            public float getAlpha() {
                return this.alpha;
            }
        }
    }

    @FunctionalInterface
    public static interface Equation {
        public double compute(double var1);
    }
}

