/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util;

import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;

public final class GenerationUtil {
    public static final Predicate<BlockState> IS_AIR = BlockBehaviour.BlockStateBase::m_60795_;

    public static Predicate<BlockState> isFluid(int minLevel, TagKey<Fluid> allowedFluids) {
        return state -> {
            FluidState fluid = state.m_60819_();
            return !fluid.m_76178_() && fluid.m_76182_() >= (float)minLevel && fluid.m_205070_(allowedFluids);
        };
    }

    public static void fillAreaWithBlockCube(LevelAccessor level, int x1, int y1, int z1, int x2, int y2, int z2, BlockState block, @Nullable Predicate<BlockState> canPlace) {
        BlockPos.MutableBlockPos positions = new BlockPos.MutableBlockPos();
        for (int xx = x1; xx <= x2; ++xx) {
            for (int yy = y1; yy <= y2; ++yy) {
                for (int zz = z1; zz <= z2; ++zz) {
                    positions.m_122178_(xx, yy, zz);
                    if (canPlace != null && !canPlace.test(level.m_8055_((BlockPos)positions))) continue;
                    level.m_7731_((BlockPos)positions, block, 2);
                }
            }
        }
    }

    public static void fillAreaWithBlockCube(LevelAccessor level, Random rand, int x1, int y1, int z1, int x2, int y2, int z2, @Nullable Predicate<BlockState> canPlace, WeightedRandomList<WeightedStateEntry> states) {
        BlockPos.MutableBlockPos positions = new BlockPos.MutableBlockPos();
        for (int xx = x1; xx <= x2; ++xx) {
            for (int yy = y1; yy <= y2; ++yy) {
                for (int zz = z1; zz <= z2; ++zz) {
                    positions.m_122178_(xx, yy, zz);
                    if (canPlace != null && !canPlace.test(level.m_8055_((BlockPos)positions))) continue;
                    level.m_7731_((BlockPos)positions, ((WeightedStateEntry)states.m_146335_(rand).get()).getState(), 2);
                }
            }
        }
    }

    public static void fillAreaWithBlockCubeEdged(LevelAccessor level, int x1, int y1, int z1, int x2, int y2, int z2, BlockState block, @Nullable Predicate<BlockState> canPlace) {
        BlockPos.MutableBlockPos positions = new BlockPos.MutableBlockPos();
        for (int xx = x1; xx <= x2; ++xx) {
            for (int yy = y1; yy <= y2; ++yy) {
                for (int zz = z1; zz <= z2; ++zz) {
                    positions.m_122178_(xx, yy, zz);
                    if (canPlace != null && !canPlace.test(level.m_8055_((BlockPos)positions)) || xx != x2 && zz != z2) continue;
                    level.m_7731_((BlockPos)positions, block, 2);
                }
            }
        }
    }

    public static void fillAreaWithBlockCubeEdged(LevelAccessor level, Random rand, int x1, int y1, int z1, int x2, int y2, int z2, @Nullable Predicate<BlockState> canPlace, WeightedRandomList<WeightedStateEntry> states) {
        BlockPos.MutableBlockPos positions = new BlockPos.MutableBlockPos();
        for (int xx = x1; xx <= x2; ++xx) {
            for (int yy = y1; yy <= y2; ++yy) {
                for (int zz = z1; zz <= z2; ++zz) {
                    positions.m_122178_(xx, yy, zz);
                    if (canPlace != null && !canPlace.test(level.m_8055_((BlockPos)positions)) || xx != x2 && zz != z2) continue;
                    level.m_7731_((BlockPos)positions, ((WeightedStateEntry)states.m_146335_(rand).get()).getState(), 2);
                }
            }
        }
    }

    public static class WeightedStateEntry
    implements WeightedEntry {
        private final BlockState state;
        private final Weight weight;

        public WeightedStateEntry(BlockState state, int weight) {
            this.state = state;
            this.weight = Weight.m_146282_((int)weight);
        }

        public BlockState getState() {
            return this.state;
        }

        public Weight m_142631_() {
            return this.weight;
        }
    }
}

