/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.world.modification.structure;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamabnormals.blueprint.common.world.modification.structure.StructureRepaletter;
import com.teamabnormals.blueprint.common.world.modification.structure.StructureRepaletterEntry;
import com.teamabnormals.blueprint.core.util.modification.selection.ConditionedResourceSelector;
import com.teamabnormals.blueprint.core.util.modification.selection.ResourceSelector;
import com.teamabnormals.blueprint.core.util.modification.selection.selectors.NamesResourceSelector;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.EventPriority;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class StructureRepaletterProvider
implements DataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final List<Pair<ResourceLocation, StructureRepaletterEntry>> entries = new LinkedList<Pair<ResourceLocation, StructureRepaletterEntry>>();
    private final DataGenerator dataGenerator;
    private final String modid;
    private final Supplier<DynamicOps<JsonElement>> ops;

    protected StructureRepaletterProvider(DataGenerator dataGenerator, String modid, Supplier<DynamicOps<JsonElement>> ops) {
        this.dataGenerator = dataGenerator;
        this.modid = modid;
        this.ops = ops;
    }

    protected StructureRepaletterProvider(DataGenerator dataGenerator, String modid) {
        this(dataGenerator, modid, () -> RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)((RegistryAccess)RegistryAccess.f_123049_.get())));
    }

    public void m_6865_(HashCache cache) {
        HashSet names = new HashSet();
        Path outputFolder = this.dataGenerator.m_123916_();
        String basePath = "data/" + this.modid + "/structure_repalleters/";
        DynamicOps<JsonElement> ops = this.ops.get();
        List<Pair<ResourceLocation, StructureRepaletterEntry>> entries = this.entries;
        entries.clear();
        this.registerRepaletters();
        entries.forEach(pair -> {
            ResourceLocation name = (ResourceLocation)pair.getFirst();
            if (!names.add(name)) {
                throw new IllegalStateException("Duplicate structure repaletter: " + name);
            }
            Path path = outputFolder.resolve(basePath + name.m_135815_() + ".json");
            try {
                DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)((StructureRepaletterEntry)pair.getSecond()).serialize(ops), (Path)path);
            }
            catch (JsonParseException | IOException exception) {
                LOGGER.error("Couldn't save structure repaletter {}", (Object)path, (Object)exception);
            }
        });
    }

    protected abstract void registerRepaletters();

    protected void registerRepaletter(String name, ConditionedResourceSelector selector, EventPriority priority, StructureRepaletter repaletter) {
        this.entries.add((Pair<ResourceLocation, StructureRepaletterEntry>)Pair.of((Object)new ResourceLocation(this.modid, name), (Object)new StructureRepaletterEntry(selector, priority, repaletter)));
    }

    protected void registerRepaletter(String name, ResourceSelector<?> selector, EventPriority priority, StructureRepaletter repaletter) {
        this.registerRepaletter(name, new ConditionedResourceSelector(selector), priority, repaletter);
    }

    protected void registerRepaletter(String name, EventPriority priority, StructureRepaletter repaletter, ResourceLocation ... selects) {
        this.registerRepaletter(name, new NamesResourceSelector(selects), priority, repaletter);
    }

    protected void registerRepaletter(String name, StructureRepaletter repaletter, ResourceLocation ... selects) {
        this.registerRepaletter(name, EventPriority.NORMAL, repaletter, selects);
    }

    public String m_6055_() {
        return "Structure Repaletter: " + this.modid;
    }
}

