/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.world.modification.chunk.modifiers;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.blueprint.common.world.modification.chunk.ChunkGeneratorModifierSerializers;
import com.teamabnormals.blueprint.common.world.modification.chunk.modifiers.ChunkGeneratorModifier;
import com.teamabnormals.blueprint.common.world.modification.chunk.modifiers.UnsafeChunkGeneratorModifier;
import com.teamabnormals.blueprint.core.Blueprint;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public final class SurfaceRuleModifier
extends UnsafeChunkGeneratorModifier<SurfaceRuleModifier> {
    public static final Codec<SurfaceRuleModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SurfaceRules.RuleSource.f_189682_.fieldOf("surface_rule").forGetter(modifier -> modifier.surfaceRule), (App)Codec.BOOL.optionalFieldOf("replace", (Object)false).forGetter(modifier -> modifier.replace)).apply((Applicative)instance, SurfaceRuleModifier::new));
    private static final Field NOISE_GENERATOR_SETTINGS = ObfuscationReflectionHelper.findField(NoiseBasedChunkGenerator.class, (String)"f_64318_");
    private final SurfaceRules.RuleSource surfaceRule;
    private final boolean replace;

    public SurfaceRuleModifier(SurfaceRules.RuleSource surfaceRule, boolean replace) {
        this.surfaceRule = surfaceRule;
        this.replace = replace;
    }

    @Override
    public void modify(ChunkGenerator chunkGenerator) {
        if (chunkGenerator instanceof NoiseBasedChunkGenerator) {
            SurfaceRules.RuleSource newRuleSource;
            long fieldOffset = UNSAFE.objectFieldOffset(NOISE_GENERATOR_SETTINGS);
            NoiseGeneratorSettings settings = (NoiseGeneratorSettings)((Holder)UNSAFE.getObject(chunkGenerator, fieldOffset)).m_203334_();
            if (this.replace) {
                newRuleSource = this.surfaceRule;
            } else {
                SurfaceRules.RuleSource ruleSource = settings.f_188871_();
                if (ruleSource instanceof SurfaceRules.SequenceRuleSource) {
                    SurfaceRules.SequenceRuleSource sequenceRuleSource = (SurfaceRules.SequenceRuleSource)ruleSource;
                    List sequence = sequenceRuleSource.f_189697_();
                    ArrayList<SurfaceRules.RuleSource> newSequence = new ArrayList<SurfaceRules.RuleSource>(sequence.size() + 1);
                    newSequence.add(this.surfaceRule);
                    newSequence.addAll(sequence);
                    newRuleSource = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])newSequence.toArray(new SurfaceRules.RuleSource[0]));
                } else {
                    newRuleSource = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{this.surfaceRule, ruleSource});
                }
            }
            UNSAFE.putObject(chunkGenerator, fieldOffset, Holder.m_205709_((Object)new NoiseGeneratorSettings(settings.f_64439_(), settings.f_64440_(), settings.f_64441_(), settings.f_209353_(), newRuleSource, settings.f_64444_(), settings.f_64445_(), settings.m_158567_(), settings.m_209369_(), settings.f_209354_())));
        } else {
            Blueprint.LOGGER.warn("Could not apply surface rule modifier because " + chunkGenerator + " was not an instance of NoiseBasedChunkGenerator");
        }
    }

    public Serializer getSerializer() {
        return ChunkGeneratorModifierSerializers.SURFACE_RULE;
    }

    public static final class Serializer
    implements ChunkGeneratorModifier.Serializer<SurfaceRuleModifier> {
        @Override
        public JsonElement serialize(SurfaceRuleModifier modifier, RegistryOps<JsonElement> additional) throws JsonParseException {
            DataResult dataResult = CODEC.encodeStart(additional, (Object)modifier);
            Optional result = dataResult.result();
            if (result.isPresent()) {
                return (JsonElement)result.get();
            }
            throw new JsonParseException(((DataResult.PartialResult)dataResult.error().get()).message());
        }

        @Override
        public SurfaceRuleModifier deserialize(JsonElement element, RegistryOps<JsonElement> additional) throws JsonParseException {
            DataResult dataResult = CODEC.decode(additional, (Object)element);
            Optional result = dataResult.result();
            if (result.isPresent()) {
                return (SurfaceRuleModifier)((Pair)result.get()).getFirst();
            }
            throw new JsonParseException(((DataResult.PartialResult)dataResult.error().get()).message());
        }
    }
}

