/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.advancement.modification.modifiers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.teamabnormals.blueprint.common.advancement.modification.AdvancementModifierSerializers;
import com.teamabnormals.blueprint.common.advancement.modification.modifiers.AdvancementModifier;
import java.lang.reflect.Field;
import java.util.Optional;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public record DisplayInfoModifier(AdvancementModifier.Mode mode, Optional<Component> title, Optional<Component> description, Optional<ItemStack> icon, Optional<ResourceLocation> background, Optional<FrameType> frame, Optional<Boolean> showToast, Optional<Boolean> announceToChat, Optional<Boolean> hidden) implements AdvancementModifier<DisplayInfoModifier>
{
    private static final Field DISPLAY_INFO_FIELD = ObfuscationReflectionHelper.findField(Advancement.Builder.class, (String)"f_138334_");
    private static final Field ICON_FIELD = ObfuscationReflectionHelper.findField(DisplayInfo.class, (String)"f_14960_");
    private static final Field BACKGROUND_FIELD = ObfuscationReflectionHelper.findField(DisplayInfo.class, (String)"f_14961_");
    private static final Field SHOW_TOAST_FIELD = ObfuscationReflectionHelper.findField(DisplayInfo.class, (String)"f_14963_");

    public static Builder builder() {
        return new Builder();
    }

    private static ItemStack deserializeIcon(JsonObject object) {
        if (!object.has("item")) {
            throw new JsonSyntaxException("Unsupported icon type, currently only items are supported (add 'item' key)");
        }
        Item item = GsonHelper.m_13909_((JsonObject)object, (String)"item");
        if (object.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        ItemStack stack = new ItemStack((ItemLike)item);
        if (object.has("nbt")) {
            try {
                CompoundTag nbt = TagParser.m_129359_((String)GsonHelper.m_13805_((JsonElement)object.get("nbt"), (String)"nbt"));
                stack.m_41751_(nbt);
            }
            catch (CommandSyntaxException syntax) {
                throw new JsonSyntaxException("Invalid nbt tag: " + syntax.getMessage());
            }
        }
        return stack;
    }

    @Override
    public void modify(Advancement.Builder builder) {
        if (this.mode == AdvancementModifier.Mode.MODIFY) {
            try {
                DisplayInfo displayInfo = (DisplayInfo)DISPLAY_INFO_FIELD.get(builder);
                Component title = this.title.orElse(displayInfo.m_14977_());
                Component description = this.description.orElse(displayInfo.m_14985_());
                ItemStack icon = this.icon.orElse((ItemStack)ICON_FIELD.get(displayInfo));
                ResourceLocation background = this.background.orElse((ResourceLocation)BACKGROUND_FIELD.get(displayInfo));
                FrameType frameType = this.frame.orElse(displayInfo.m_14992_());
                boolean showToast = this.showToast.orElse(SHOW_TOAST_FIELD.getBoolean(displayInfo));
                boolean announceToChat = this.announceToChat.orElse(displayInfo.m_14996_());
                boolean hidden = this.hidden.orElse(displayInfo.m_14997_());
                builder.m_138358_(new DisplayInfo(icon, title, description, background, frameType, showToast, announceToChat, hidden));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        } else {
            builder.m_138358_(new DisplayInfo(this.icon.orElse(ItemStack.f_41583_), this.title.orElse(TextComponent.f_131282_), this.description.orElse(TextComponent.f_131282_), (ResourceLocation)this.background.orElse(null), this.frame.orElse(FrameType.TASK), this.showToast.orElse(true).booleanValue(), this.announceToChat.orElse(true).booleanValue(), this.hidden.orElse(false).booleanValue()));
        }
    }

    public Serializer getSerializer() {
        return AdvancementModifierSerializers.DISPLAY_INFO;
    }

    public static final class Builder {
        private AdvancementModifier.Mode mode = AdvancementModifier.Mode.MODIFY;
        private Optional<Component> title = Optional.empty();
        private Optional<Component> description = Optional.empty();
        private Optional<ItemStack> icon = Optional.empty();
        private Optional<ResourceLocation> background = Optional.empty();
        private Optional<FrameType> frame = Optional.empty();
        private Optional<Boolean> showToast = Optional.empty();
        private Optional<Boolean> announceToChat = Optional.empty();
        private Optional<Boolean> hidden = Optional.empty();

        private Builder() {
        }

        public Builder mode(AdvancementModifier.Mode mode) {
            this.mode = mode;
            return this;
        }

        public Builder title(Component title) {
            this.title = Optional.of(title);
            return this;
        }

        public Builder description(Component description) {
            this.description = Optional.of(description);
            return this;
        }

        public Builder icon(ItemStack icon) {
            this.icon = Optional.of(icon);
            return this;
        }

        public Builder background(ResourceLocation background) {
            this.background = Optional.of(background);
            return this;
        }

        public Builder frame(FrameType frame) {
            this.frame = Optional.of(frame);
            return this;
        }

        public Builder showToast(boolean showToast) {
            this.showToast = Optional.of(showToast);
            return this;
        }

        public Builder announceToChat(boolean announceToChat) {
            this.announceToChat = Optional.of(announceToChat);
            return this;
        }

        public Builder hidden(boolean hidden) {
            this.hidden = Optional.of(hidden);
            return this;
        }

        public DisplayInfoModifier build() {
            return new DisplayInfoModifier(this.mode, this.title, this.description, this.icon, this.background, this.frame, this.showToast, this.announceToChat, this.hidden);
        }
    }

    public static final class Serializer
    implements AdvancementModifier.Serializer<DisplayInfoModifier> {
        @Override
        public JsonElement serialize(DisplayInfoModifier modifier, Void additional) throws JsonParseException {
            JsonObject jsonObject = new JsonObject();
            modifier.mode.serialize(jsonObject);
            modifier.title.ifPresent(title -> jsonObject.add("title", Component.Serializer.m_130716_((Component)title)));
            modifier.description.ifPresent(description -> jsonObject.add("description", Component.Serializer.m_130716_((Component)description)));
            modifier.icon.ifPresent(icon -> {
                JsonObject iconObject = new JsonObject();
                iconObject.addProperty("item", Registry.f_122827_.m_7981_((Object)icon.m_41720_()).toString());
                if (icon.m_41782_()) {
                    iconObject.addProperty("nbt", icon.m_41783_().toString());
                }
                jsonObject.add("icon", (JsonElement)iconObject);
            });
            modifier.background.ifPresent(background -> jsonObject.addProperty("background", background.toString()));
            modifier.frame.ifPresent(frame -> jsonObject.addProperty("frame", frame.m_15548_()));
            modifier.showToast.ifPresent(showToast -> jsonObject.addProperty("show_toast", showToast));
            modifier.announceToChat.ifPresent(announceToChat -> jsonObject.addProperty("announce_to_chat", announceToChat));
            modifier.hidden.ifPresent(hidden -> jsonObject.addProperty("hidden", hidden));
            return jsonObject;
        }

        @Override
        public DisplayInfoModifier deserialize(JsonElement element, DeserializationContext additional) throws JsonParseException {
            JsonObject object = element.getAsJsonObject();
            AdvancementModifier.Mode mode = AdvancementModifier.Mode.deserialize(object);
            Optional<Component> title = GsonHelper.m_13900_((JsonObject)object, (String)"title") ? Optional.ofNullable(Component.Serializer.m_130691_((JsonElement)object.get("title"))) : Optional.empty();
            Optional<Component> description = GsonHelper.m_13900_((JsonObject)object, (String)"description") ? Optional.ofNullable(Component.Serializer.m_130691_((JsonElement)object.get("description"))) : Optional.empty();
            Optional<ItemStack> icon = GsonHelper.m_13900_((JsonObject)object, (String)"icon") ? Optional.of(DisplayInfoModifier.deserializeIcon(GsonHelper.m_13930_((JsonObject)object, (String)"icon"))) : Optional.empty();
            Optional<ResourceLocation> background = GsonHelper.m_13900_((JsonObject)object, (String)"background") ? Optional.of(new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"background"))) : Optional.empty();
            Optional<FrameType> frameType = GsonHelper.m_13900_((JsonObject)object, (String)"frame") ? Optional.of(FrameType.m_15549_((String)GsonHelper.m_13906_((JsonObject)object, (String)"frame"))) : Optional.empty();
            Optional<Boolean> showToast = GsonHelper.m_13900_((JsonObject)object, (String)"show_toast") ? Optional.of(GsonHelper.m_13912_((JsonObject)object, (String)"show_toast")) : Optional.empty();
            Optional<Boolean> announceToChat = GsonHelper.m_13900_((JsonObject)object, (String)"announce_to_chat") ? Optional.of(GsonHelper.m_13912_((JsonObject)object, (String)"announce_to_chat")) : Optional.empty();
            Optional<Boolean> hidden = GsonHelper.m_13900_((JsonObject)object, (String)"hidden") ? Optional.of(GsonHelper.m_13912_((JsonObject)object, (String)"hidden")) : Optional.empty();
            return new DisplayInfoModifier(mode, title, description, icon, background, frameType, showToast, announceToChat, hidden);
        }
    }
}

