/*
 * Decompiled with CFR 0.152.
 */
package com.teamremastered.tlc.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class LostCastle
extends StructureFeature<JigsawConfiguration> {
    public static final Codec<JigsawConfiguration> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(JigsawConfiguration::m_204802_), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(JigsawConfiguration::m_67765_)).apply((Applicative)codec, JigsawConfiguration::new));

    public LostCastle() {
        super(CODEC, LostCastle::createPiecesGenerator, PostPlacementProcessor.f_192427_);
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    private static int distanceFromSpawn(ChunkPos structurePos) {
        ChunkPos spawnPointPos = new ChunkPos(0, 0);
        int structurePosX = structurePos.f_45578_ << 4;
        int structurePosZ = structurePos.f_45579_ << 4;
        int distanceFromSpawn = (int)Math.sqrt(Math.pow(structurePosX - spawnPointPos.f_45578_, 2.0) + Math.pow(structurePosZ - spawnPointPos.f_45579_, 2.0));
        System.out.println("Distance from spawn is: " + distanceFromSpawn);
        return distanceFromSpawn;
    }

    private static boolean isFeatureChunk(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        ChunkPos chunkPos = context.f_197355_();
        int x = chunkPos.m_45604_();
        int z = chunkPos.m_45605_();
        int startHeight = context.f_197352_().m_156179_(x, z, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, context.f_197357_());
        int height1 = context.f_197352_().m_156179_(x + 78, z, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, context.f_197357_());
        int height2 = context.f_197352_().m_156179_(x - 78, z, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, context.f_197357_());
        int height3 = context.f_197352_().m_156179_(x, z + 78, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, context.f_197357_());
        int height4 = context.f_197352_().m_156179_(x, z - 78, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, context.f_197357_());
        return Math.abs(startHeight - height1) < 10 && Math.abs(startHeight - height2) < 10 && Math.abs(startHeight - height3) < 10 && Math.abs(startHeight - height4) < 10 && LostCastle.distanceFromSpawn(chunkPos) > 5000;
    }

    public static Optional<PieceGenerator<JigsawConfiguration>> createPiecesGenerator(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        if (!LostCastle.isFeatureChunk(context)) {
            return Optional.empty();
        }
        ChunkPos chunkPos = context.f_197355_();
        int x = chunkPos.m_45604_();
        int z = chunkPos.m_45605_();
        BlockPos blockPos = new BlockPos(x, 0, z);
        Optional structurePiecesGenerator = JigsawPlacement.m_210284_(context, PoolElementStructurePiece::new, (BlockPos)blockPos, (boolean)false, (boolean)true);
        return structurePiecesGenerator;
    }
}

