/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.recipestages.recipes;

import com.blamejared.recipestages.RecipeStagesUtil;
import com.blamejared.recipestages.recipes.ShapedRecipeStage;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ShapedRecipeStageSerializer
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<ShapedRecipeStage> {
    public ShapedRecipeStageSerializer() {
        this.setRegistryName("recipestages", "shaped_stage");
    }

    public ShapedRecipeStage fromJson(ResourceLocation recipeId, JsonObject json) {
        String stage = GsonHelper.m_13906_((JsonObject)json, (String)"stage");
        Recipe recipe = RecipeManager.m_44045_((ResourceLocation)recipeId, (JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"recipe"));
        if (!(recipe instanceof CraftingRecipe)) {
            throw new JsonSyntaxException("Staged Recipes only work with Crafting Table Recipes");
        }
        CraftingRecipe craftingRecipe = (CraftingRecipe)recipe;
        return new ShapedRecipeStage(recipeId, stage, craftingRecipe);
    }

    @Nullable
    public ShapedRecipeStage fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        ResourceLocation innerRecipeId = buffer.m_130281_();
        ResourceLocation recipeSerializerId = buffer.m_130281_();
        RecipeSerializer value = (RecipeSerializer)ForgeRegistries.RECIPE_SERIALIZERS.getValue(recipeSerializerId);
        Recipe read = value.m_8005_(innerRecipeId, buffer);
        String stage = buffer.m_130277_();
        return new ShapedRecipeStage(recipeId, stage, (CraftingRecipe)read);
    }

    public void toNetwork(FriendlyByteBuf buffer, ShapedRecipeStage recipe) {
        CraftingRecipe recipe1 = recipe.getRecipe();
        if (recipe1.m_6423_() == null) {
            throw new IllegalArgumentException("Unable to serialize a recipe without an id: " + (Recipe)recipe1);
        }
        if (recipe1.m_7707_().getRegistryName() == null) {
            throw new IllegalArgumentException("Unable to serialize a recipe serializer without an id: " + recipe1.m_7707_());
        }
        buffer.m_130085_(recipe1.m_6423_());
        buffer.m_130085_(recipe1.m_7707_().getRegistryName());
        recipe1.m_7707_().m_6178_(buffer, (Recipe)RecipeStagesUtil.cast(recipe1));
        buffer.m_130070_(recipe.getStage());
    }
}

