/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.recipestages.recipes;

import com.blamejared.recipestages.RecipeStagesUtil;
import com.blamejared.recipestages.recipes.RecipeStage;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class RecipeStageSerializer
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<RecipeStage> {
    public RecipeStageSerializer() {
        this.setRegistryName("recipestages", "stage");
    }

    public RecipeStage fromJson(ResourceLocation recipeId, JsonObject json) {
        String stage = GsonHelper.m_13906_((JsonObject)json, (String)"stage");
        Recipe recipe = RecipeManager.m_44045_((ResourceLocation)recipeId, (JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"recipe"));
        if (!(recipe instanceof CraftingRecipe)) {
            throw new JsonSyntaxException("Staged Recipes only work with Crafting Table Recipes");
        }
        CraftingRecipe craftingRecipe = (CraftingRecipe)recipe;
        boolean shapeless = json.has("shapeless") ? GsonHelper.m_13912_((JsonObject)json, (String)"shapeless") : recipe instanceof ShapelessRecipe;
        return new RecipeStage(recipeId, stage, craftingRecipe, shapeless);
    }

    @Nullable
    public RecipeStage fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        ResourceLocation innerRecipeId = buffer.m_130281_();
        ResourceLocation recipeSerializerId = buffer.m_130281_();
        RecipeSerializer value = (RecipeSerializer)ForgeRegistries.RECIPE_SERIALIZERS.getValue(recipeSerializerId);
        Recipe read = value.m_8005_(innerRecipeId, buffer);
        String stage = buffer.m_130277_();
        boolean shapeless = buffer.readBoolean();
        return new RecipeStage(recipeId, stage, (CraftingRecipe)read, shapeless);
    }

    public void toNetwork(FriendlyByteBuf buffer, RecipeStage recipe) {
        CraftingRecipe recipe1 = recipe.getRecipe();
        if (recipe1.m_6423_() == null) {
            throw new IllegalArgumentException("Unable to serialize a recipe without an id: " + (Recipe)recipe1);
        }
        if (recipe1.m_7707_().getRegistryName() == null) {
            throw new IllegalArgumentException("Unable to serialize a recipe serializer without an id: " + recipe1.m_7707_());
        }
        buffer.m_130085_(recipe1.m_6423_());
        buffer.m_130085_(recipe1.m_7707_().getRegistryName());
        recipe1.m_7707_().m_6178_(buffer, (Recipe)RecipeStagesUtil.cast(recipe1));
        buffer.m_130070_(recipe.getStage());
        buffer.writeBoolean(recipe.isShapeless());
    }
}

