/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.recipestages.recipes;

import com.blamejared.recipestages.ClientStuff;
import com.blamejared.recipestages.RecipeStages;
import com.blamejared.recipestages.ServerStuff;
import com.blamejared.recipestages.recipes.IStagedRecipe;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.fml.util.thread.EffectiveSide;

public class RecipeStage
implements CraftingRecipe,
IStagedRecipe {
    private final ResourceLocation id;
    private final String stage;
    private final CraftingRecipe recipe;
    private final boolean shapeless;
    private int width = 0;
    private int height = 0;

    public RecipeStage(ResourceLocation id, String stage, CraftingRecipe recipe, boolean shapeless) {
        this.id = id;
        this.stage = stage;
        this.recipe = recipe;
        this.shapeless = shapeless;
        if (recipe instanceof IShapedRecipe) {
            this.width = ((IShapedRecipe)recipe).getRecipeWidth();
            this.height = ((IShapedRecipe)recipe).getRecipeHeight();
        }
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        return this.recipe.m_7457_((Container)inv);
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        return this.recipe.m_5818_((Container)inv, worldIn);
    }

    public ItemStack assemble(CraftingContainer inv) {
        if (this.isGoodForCrafting(inv)) {
            return this.recipe.m_5874_((Container)inv);
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int p_194133_1_, int p_194133_2_) {
        return this.recipe.m_8004_(p_194133_1_, p_194133_2_);
    }

    public ItemStack m_8043_() {
        return this.recipe.m_8043_();
    }

    public boolean isGoodForCrafting(CraftingContainer inv) {
        if (inv.f_39323_ == null && ForgeHooks.getCraftingPlayer() == null) {
            return false;
        }
        if (RecipeStages.printContainer) {
            RecipeStages.CONTAINER_LOGGER.info("Tried to craft a recipe in container: '{}'", (Object)inv.f_39323_.getClass().getName());
        }
        return (Boolean)this.callForSide(() -> () -> ClientStuff.handleClient(inv, this.stage), () -> () -> ServerStuff.handleServer(inv, this.stage));
    }

    @Nullable
    private <T> T callForSide(@Nullable Supplier<Callable<T>> client, @Nullable Supplier<Callable<T>> server) {
        try {
            if (EffectiveSide.get().isClient() && client != null) {
                return client.get().call();
            }
            if (EffectiveSide.get().isServer() && server != null) {
                return server.get().call();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.recipe.m_7527_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return RecipeStages.STAGE_SERIALIZER;
    }

    public RecipeType<?> m_6671_() {
        return this.recipe.m_6671_();
    }

    @Override
    public CraftingRecipe getRecipe() {
        return this.recipe;
    }

    @Override
    public String getStage() {
        return this.stage;
    }

    public String toString() {
        return "RecipeStage{stage='" + this.stage + "', recipe=" + this.recipe.m_8043_() + ":" + this.recipe.m_7527_() + "}";
    }

    public boolean isShapeless() {
        return this.shapeless;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

