/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaksitems.entity;

import de.markusbordihn.adaptiveperformancetweakscore.CoreConstants;
import de.markusbordihn.adaptiveperformancetweakscore.entity.CoreItemEntityManager;
import de.markusbordihn.adaptiveperformancetweakscore.message.WarnMessages;
import de.markusbordihn.adaptiveperformancetweakscore.server.OptimizationEvent;
import de.markusbordihn.adaptiveperformancetweakscore.server.ServerLoadEvent;
import de.markusbordihn.adaptiveperformancetweaksitems.config.CommonConfig;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityLeaveWorldEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class ItemEntityManager {
    protected static final Logger log = LogManager.getLogger((String)"APTweaks(Items)");
    private static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    private static Integer maxNumberOfItems = (Integer)ItemEntityManager.COMMON.maxNumberOfItems.get();
    private static Integer maxNumberOfItemsPerType = (Integer)ItemEntityManager.COMMON.maxNumberOfItemsPerType.get();
    private static List<String> itemsAllowList = (List)ItemEntityManager.COMMON.itemsAllowList.get();
    private static List<String> itemsDenyList = (List)ItemEntityManager.COMMON.itemsDenyList.get();
    private static boolean optimizeItems = (Boolean)ItemEntityManager.COMMON.optimizeItems.get();
    private static int itemClusterRange = (Integer)ItemEntityManager.COMMON.itemsClusterRange.get();
    private static Map<String, Set<ItemEntity>> itemTypeEntityMap = new ConcurrentHashMap<String, Set<ItemEntity>>();
    private static Map<String, Set<ItemEntity>> itemWorldEntityMap = new ConcurrentHashMap<String, Set<ItemEntity>>();
    private static boolean hasHighServerLoad = false;
    private static boolean needsOptimization = false;
    private static boolean hasItemsAllowList = false;
    private static boolean hasItemsDenyList = false;
    private static short ticks = 0;
    private static final short VERIFICATION_TICK = 600;

    protected ItemEntityManager() {
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(ServerAboutToStartEvent event) {
        itemTypeEntityMap = new ConcurrentHashMap<String, Set<ItemEntity>>();
        itemWorldEntityMap = new ConcurrentHashMap<String, Set<ItemEntity>>();
        itemClusterRange = (Integer)ItemEntityManager.COMMON.itemsClusterRange.get();
        itemsAllowList = (List)ItemEntityManager.COMMON.itemsAllowList.get();
        itemsDenyList = (List)ItemEntityManager.COMMON.itemsDenyList.get();
        maxNumberOfItems = (Integer)ItemEntityManager.COMMON.maxNumberOfItems.get();
        maxNumberOfItemsPerType = (Integer)ItemEntityManager.COMMON.maxNumberOfItemsPerType.get();
        optimizeItems = (Boolean)ItemEntityManager.COMMON.optimizeItems.get();
        hasItemsAllowList = !itemsAllowList.isEmpty();
        boolean bl = hasItemsDenyList = !itemsDenyList.isEmpty();
        if (maxNumberOfItems < maxNumberOfItemsPerType) {
            maxNumberOfItems = maxNumberOfItemsPerType * 2;
            log.error("Max number of items could not be lower than max. number of items per type, using {} for maxNumberOfItems instead!", (Object)maxNumberOfItems);
        }
        if (optimizeItems) {
            log.info("Max number of Items allowed per world: {} / per type: {}", (Object)maxNumberOfItems, (Object)maxNumberOfItemsPerType);
            log.info("Enable clustering of items with a radius of {} blocks.", (Object)itemClusterRange);
            if (hasItemsAllowList) {
                log.info("Optimize only items from allow list: {}", itemsAllowList);
            } else if (hasItemsDenyList) {
                log.info("Optimize all items except from deny list: {}", itemsDenyList);
            }
            if (CoreConstants.GET_IT_TOGETHER_LOADED) {
                log.warn(() -> WarnMessages.conflictingFeaturesModWarning((String)"Get It Together, Drops!", (String)"clusters items in a specific radius"));
            }
        } else {
            log.info("Item Optimization is disabled!");
        }
    }

    @SubscribeEvent
    public static void handleClientServerTickEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            short s = ticks;
            ticks = (short)(s + 1);
            if (s >= 600) {
                ItemEntityManager.verifyEntities();
                ticks = 0;
            }
        }
    }

    @SubscribeEvent
    public static void handleServerLoadEvent(ServerLoadEvent event) {
        hasHighServerLoad = event.hasHighServerLoad();
        if (hasHighServerLoad) {
            needsOptimization = true;
        }
    }

    @SubscribeEvent
    public static void handleOptimizationEvent(OptimizationEvent event) {
        if (needsOptimization) {
            if (optimizeItems) {
                ItemEntityManager.optimizeItems();
            }
            needsOptimization = false;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void handleItemEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        int numberOfItemEntities;
        int numberOfItemWorldEntities;
        ItemStack itemStack;
        String itemName;
        Level level = event.getWorld();
        if (level.f_46443_ || event.isCanceled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof ItemEntity) || entity.m_146910_()) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entity;
        if (!CoreItemEntityManager.isRelevantItemEntity((ItemEntity)itemEntity)) {
            return;
        }
        ResourceLocation itemRegistryName = itemEntity.m_32055_().m_41720_().getRegistryName();
        String string = itemName = itemRegistryName != null ? itemRegistryName.toString() : itemEntity.m_20078_();
        if (hasItemsAllowList && !itemsAllowList.contains(itemName)) {
            log.debug("[Item Allow List] {} is not on the allow list!", (Object)itemName);
            return;
        }
        if (hasItemsDenyList && itemsDenyList.contains(itemName)) {
            log.debug("[Item Deny List] {} will not be optimized!", (Object)itemName);
            return;
        }
        String levelName = level.m_46472_().m_135782_().toString();
        if (log.isDebugEnabled()) {
            log.debug("[Item joined {}] {} {}", (Object)levelName, (Object)itemName, (Object)itemEntity.m_5446_().getString());
        }
        String itemTypeEntityMapKey = "[" + levelName + "]" + itemName;
        itemTypeEntityMap.computeIfAbsent(itemTypeEntityMapKey, k -> new LinkedHashSet());
        Set<ItemEntity> itemTypeEntities = itemTypeEntityMap.get(itemTypeEntityMapKey);
        if (optimizeItems && (itemStack = itemEntity.m_32055_()) != null && itemStack.m_41753_() && itemStack.m_41613_() < itemStack.m_41741_() && itemStack.m_41741_() > 1) {
            int x = (int)itemEntity.m_20185_();
            int y = (int)itemEntity.m_20186_();
            int z = (int)itemEntity.m_20189_();
            int xStart = x - itemClusterRange;
            int yStart = y - itemClusterRange;
            int zStart = z - itemClusterRange;
            int xEnd = x + itemClusterRange;
            int yEnd = y + itemClusterRange;
            int zEnd = z + itemClusterRange;
            boolean itemCanSeeSky = level.m_45527_(itemEntity.m_142538_());
            HashSet<ItemEntity> itemEntities = new HashSet<ItemEntity>(itemTypeEntities);
            for (ItemEntity existingItemEntity : itemEntities) {
                int xSub = (int)existingItemEntity.m_20185_();
                int ySub = (int)existingItemEntity.m_20186_();
                int zSub = (int)existingItemEntity.m_20189_();
                boolean existingItemCanSeeSky = level.m_45527_(existingItemEntity.m_142538_());
                ItemStack existingItemStack = existingItemEntity.m_32055_();
                if (itemEntity.m_142049_() == existingItemEntity.m_142049_() || !existingItemEntity.m_6084_() || !ItemEntity.m_32026_((ItemStack)itemStack, (ItemStack)existingItemStack) || xStart >= xSub || xSub >= xEnd || (!itemCanSeeSky || !existingItemCanSeeSky) && (yStart >= ySub || ySub >= yEnd) || zStart >= zSub || zSub >= zEnd) continue;
                if (log.isDebugEnabled()) {
                    int newItemCount = existingItemStack.m_41613_() + itemStack.m_41613_();
                    log.debug("[Merge Item] {} + {} = {} items", (Object)itemEntity, (Object)existingItemEntity, (Object)newItemCount);
                }
                ItemStack combinedItemStack = ItemEntity.m_32029_((ItemStack)existingItemStack, (ItemStack)itemStack, (int)64);
                existingItemEntity.m_32045_(combinedItemStack);
                return;
            }
        }
        itemWorldEntityMap.computeIfAbsent(levelName, k -> new LinkedHashSet());
        Set<ItemEntity> itemWorldEntities = itemWorldEntityMap.get(levelName);
        itemWorldEntities.add(itemEntity);
        if (optimizeItems && (numberOfItemWorldEntities = itemWorldEntities.size()) > maxNumberOfItems) {
            ItemEntity firsItemWorldEntity = itemWorldEntities.iterator().next();
            log.debug("[Item World Limit {}] Removing item {}", (Object)numberOfItemWorldEntities, (Object)firsItemWorldEntity);
            firsItemWorldEntity.m_142687_(Entity.RemovalReason.DISCARDED);
            itemWorldEntities.remove(firsItemWorldEntity);
            Set<ItemEntity> itemEntities = itemTypeEntityMap.get("[" + levelName + "]" + itemName);
            if (itemEntities != null) {
                itemEntities.remove(firsItemWorldEntity);
            }
        }
        itemTypeEntities.add(itemEntity);
        if (optimizeItems && (numberOfItemEntities = itemTypeEntities.size()) > maxNumberOfItemsPerType) {
            ItemEntity firstItemEntity = itemTypeEntities.iterator().next();
            log.debug("[Item Type Limit {}] Removing item {}", (Object)numberOfItemEntities, (Object)firstItemEntity);
            firstItemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
            itemTypeEntities.remove(firstItemEntity);
            itemWorldEntities.remove(firstItemEntity);
        }
        if (optimizeItems && hasHighServerLoad && itemEntity.lifespan > 1) {
            itemEntity.lifespan = (int)Math.round((double)itemEntity.lifespan * 0.6);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void handleItemEntityLeaveWorldEvent(EntityLeaveWorldEvent event) {
        Set<ItemEntity> itemTypeEntities;
        String itemName;
        Level level = event.getWorld();
        if (level.f_46443_) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof ItemEntity)) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entity;
        if (!CoreItemEntityManager.isRelevantItemEntity((ItemEntity)itemEntity)) {
            return;
        }
        ResourceLocation itemRegistryName = itemEntity.m_32055_().m_41720_().getRegistryName();
        String string = itemName = itemRegistryName != null ? itemRegistryName.toString() : itemEntity.m_20078_();
        if (hasItemsAllowList && !itemsAllowList.contains(itemName)) {
            return;
        }
        if (hasItemsDenyList && itemsDenyList.contains(itemName)) {
            return;
        }
        String levelName = level.m_46472_().m_135782_().toString();
        Set<ItemEntity> itemWorldEntities = itemWorldEntityMap.get(levelName);
        if (itemWorldEntities != null) {
            itemWorldEntities.remove(itemEntity);
        }
        if ((itemTypeEntities = itemTypeEntityMap.get("[" + levelName + "]" + itemName)) != null) {
            itemTypeEntities.remove(itemEntity);
            if (log.isDebugEnabled()) {
                log.debug("[Item leaved {}] {} {}.", (Object)levelName, (Object)itemName, (Object)itemEntity.m_5446_().getString());
            }
        } else {
            log.warn("Item {} {} in {} was not tracked by item entity manager!", (Object)itemName, (Object)itemEntity.m_5446_().getString(), (Object)levelName);
        }
    }

    public static int optimizeItems() {
        log.debug("[Optimize Items] Received request to optimize items ...");
        int numberOfRemovedItems = 0;
        int maxNumberOfOptimizedWorldItems = (int)Math.round((double)maxNumberOfItems.intValue() * 0.9);
        for (Map.Entry<String, Set<ItemEntity>> itemWorldEntities : itemWorldEntityMap.entrySet()) {
            Set<ItemEntity> itemWorldEntitiesValues = itemWorldEntities.getValue();
            if (itemWorldEntitiesValues.size() <= maxNumberOfOptimizedWorldItems) continue;
            List<ItemEntity> sortedItemWorldEntitiesValues = itemWorldEntitiesValues.stream().sorted(Comparator.comparing(Entity::m_142049_)).toList();
            for (int i = 0; i < sortedItemWorldEntitiesValues.size() - maxNumberOfOptimizedWorldItems; ++i) {
                ItemEntity itemEntity = sortedItemWorldEntitiesValues.get(i);
                if (!itemEntity.isAddedToWorld()) continue;
                itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
                ++numberOfRemovedItems;
            }
        }
        int maxNumberOfOptimizedTypeItems = (int)Math.round((double)maxNumberOfItemsPerType.intValue() * 0.9);
        for (Map.Entry<String, Set<ItemEntity>> itemTypeEntities : itemTypeEntityMap.entrySet()) {
            Set<ItemEntity> itemTypeEntitiesValues = itemTypeEntities.getValue();
            if (itemTypeEntitiesValues.size() <= maxNumberOfOptimizedTypeItems) continue;
            List<ItemEntity> sortedItemTypeEntitiesValues = itemTypeEntitiesValues.stream().sorted(Comparator.comparing(Entity::m_142049_)).toList();
            for (int i = 0; i < sortedItemTypeEntitiesValues.size() - maxNumberOfOptimizedTypeItems; ++i) {
                ItemEntity itemEntity = sortedItemTypeEntitiesValues.get(i);
                if (!itemEntity.isAddedToWorld()) continue;
                itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
                ++numberOfRemovedItems;
            }
        }
        if (numberOfRemovedItems > 0) {
            log.debug("[Optimized Items] Removed {} items from all worlds!", (Object)numberOfRemovedItems);
        } else {
            log.debug("[Optimized Items] Found no relevant items which should be removed!");
        }
        return numberOfRemovedItems;
    }

    public static Integer getNumberOfItems(String levelName, String itemName) {
        Set<ItemEntity> itemEntities = itemTypeEntityMap.get("[" + levelName + "]" + itemName);
        if (itemEntities == null) {
            return 0;
        }
        return itemEntities.size();
    }

    public static Map<String, Set<ItemEntity>> getItemTypeEntityMap() {
        return itemTypeEntityMap;
    }

    public static void verifyEntities() {
        Entity entity;
        Iterator<ItemEntity> entityIterator;
        int removedEntries = 0;
        for (Set<ItemEntity> entities : itemTypeEntityMap.values()) {
            entityIterator = entities.iterator();
            while (entityIterator.hasNext()) {
                entity = (Entity)entityIterator.next();
                if (entity == null || !entity.m_146910_()) continue;
                entityIterator.remove();
                ++removedEntries;
            }
        }
        for (Set<ItemEntity> entities : itemWorldEntityMap.values()) {
            entityIterator = entities.iterator();
            while (entityIterator.hasNext()) {
                entity = (Entity)entityIterator.next();
                if (entity == null || !entity.m_146910_()) continue;
                entityIterator.remove();
                ++removedEntries;
            }
        }
        if (removedEntries > 0) {
            log.debug("[Verification] Removed {} entries", (Object)removedEntries);
        }
    }
}

