/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaksitems.config;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.FileUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public final class CommonConfig {
    protected static final Logger log = LogManager.getLogger((String)"APTweaks(Items)");
    public static final ForgeConfigSpec commonSpec;
    public static final Config COMMON;

    private CommonConfig() {
    }

    static {
        com.electronwill.nightconfig.core.Config.setInsertionOrderPreserved((boolean)true);
        Pair specPair = new ForgeConfigSpec.Builder().configure(Config::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Config)specPair.getLeft();
        log.info("Registering {} common config ...", (Object)"Adaptive Performance Tweaks: Items");
        try {
            FileUtils.getOrCreateDirectory((Path)FMLPaths.CONFIGDIR.get().resolve("adaptive_performance_tweaks"), (String)"adaptive_performance_tweaks");
        }
        catch (Exception exception) {
            log.error("There was an error, creating the directory:", (Throwable)exception);
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)commonSpec, "adaptive_performance_tweaks/items.toml");
    }

    public static class Config {
        public final ForgeConfigSpec.BooleanValue optimizeItems;
        public final ForgeConfigSpec.IntValue maxNumberOfItems;
        public final ForgeConfigSpec.IntValue maxNumberOfItemsPerType;
        public final ForgeConfigSpec.IntValue itemsClusterRange;
        public final ForgeConfigSpec.ConfigValue<List<String>> itemsAllowList;
        public final ForgeConfigSpec.ConfigValue<List<String>> itemsDenyList;
        public final ForgeConfigSpec.BooleanValue optimizeExperienceOrbs;
        public final ForgeConfigSpec.IntValue experienceOrbsClusterRange;

        Config(ForgeConfigSpec.Builder builder) {
            builder.comment("Adaptive Performance Tweaks: Items");
            builder.push("Items");
            this.optimizeItems = builder.comment("Enable/Disable items optimization.").define("optimizeItems", true);
            this.maxNumberOfItemsPerType = builder.comment("Defines the max. number of items / item stacks per type which are allowed to lay around in the world.").defineInRange("maxNumberOfItemsPerType", 32, 16, 128);
            this.maxNumberOfItems = builder.comment("Defines the max. number of items / item stacks which are allowed to lay around in a single world.").defineInRange("maxNumberOfItems", 128, 16, 1000);
            this.itemsClusterRange = builder.comment("Defines the radius in blocks which items / item stacks will be clustered together.").defineInRange("itemsClusterRange", 3, 1, 16);
            this.itemsAllowList = builder.comment("Defines a list of items which will be optimized and all other items will be ignored by the optimization.").define("itemsAllowList", new ArrayList<String>(Arrays.asList(new String[0])));
            this.itemsDenyList = builder.comment("Defines a list of items which will be ignored by the optimization and all other relevant items will be optimized.").define("itemsDenyList", new ArrayList<String>(Arrays.asList("minecraft:diamond", "minecraft:diamond_block")));
            builder.pop();
            builder.push("Experience Orbs");
            this.optimizeExperienceOrbs = builder.comment("Enable/Disable experience orbs optimization.").define("optimizeExperienceOrbs", true);
            this.experienceOrbsClusterRange = builder.comment("Defines the radius in which experience orbs will be clustered together.").defineInRange("experienceOrbsClusterRange", 4, 1, 16);
            builder.pop();
        }
    }
}

