/*
 * Decompiled with CFR 0.152.
 */
package com.teampotato.redirector;

import cpw.mods.modlauncher.serviceapi.ILaunchPluginService;
import java.util.EnumSet;
import java.util.ListIterator;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class RedirectorLaunchPluginService
implements ILaunchPluginService {
    public String name() {
        return "redirector";
    }

    public EnumSet<ILaunchPluginService.Phase> handlesClass(Type classType, boolean isEmpty) {
        return EnumSet.of(ILaunchPluginService.Phase.AFTER);
    }

    public boolean processClass(ILaunchPluginService.Phase phase, ClassNode classNode, Type classType, String reason) {
        if (phase == ILaunchPluginService.Phase.BEFORE) {
            return false;
        }
        if ("classloading".equals(reason) && "java/lang/Enum".equals(classNode.superName)) {
            for (MethodNode methodNode : classNode.methods) {
                if (!"values".equals(methodNode.name) || !("[L" + classNode.name + ";").equals(methodNode.desc)) continue;
                ListIterator iterator = methodNode.instructions.iterator();
                while (iterator.hasNext()) {
                    AbstractInsnNode node = (AbstractInsnNode)iterator.next();
                    int code = node.getOpcode();
                    if (code == 178 || code == 176) continue;
                    iterator.remove();
                }
                return true;
            }
        }
        return false;
    }
}

