/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds.sound;

import com.google.gson.annotations.JsonAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import net.minecraft.class_1111;
import net.minecraft.class_1113;
import net.minecraft.class_1117;
import net.minecraft.class_1144;
import net.minecraft.class_1146;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4228;
import net.minecraft.class_4234;
import net.minecraft.class_4237;
import net.minecraft.class_4856;
import net.minecraft.class_5819;
import team.creative.ambientsounds.AmbientSounds;
import team.creative.ambientsounds.condition.AmbientCondition;
import team.creative.ambientsounds.condition.AmbientSelection;
import team.creative.ambientsounds.condition.AmbientSelectionMulti;
import team.creative.ambientsounds.condition.AmbientVolume;
import team.creative.ambientsounds.engine.AmbientEngine;
import team.creative.ambientsounds.engine.AmbientEngineLoadException;
import team.creative.ambientsounds.entity.AmbientEntityCondition;
import team.creative.ambientsounds.environment.AmbientEnvironment;
import team.creative.ambientsounds.mixin.SoundBufferLibraryAccessor;
import team.creative.ambientsounds.sound.AmbientSoundCategory;
import team.creative.ambientsounds.sound.AmbientSoundProperties;
import team.creative.ambientsounds.sound.OggAudioStreamExtended;
import team.creative.creativecore.client.render.text.DebugTextRenderer;
import team.creative.creativecore.client.sound.SpecialSoundInstance;
import team.creative.creativecore.common.config.api.CreativeConfig;
import team.creative.creativecore.common.util.mc.ResourceUtils;

public class AmbientSound
extends AmbientCondition {
    private static final Random RANDOM = new Random();
    private static final List<Field> COPYFIELDS = new ArrayList<Field>();
    @CreativeConfig.DecimalRange(min=0.0, max=1.0)
    public transient double volumeSetting;
    public String name;
    public transient String fullName;
    public class_2960[] files;
    public double[] chances;
    @JsonAdapter(value=AmbientEntityCondition.StringJson.class)
    public String[] category;
    public transient SoundStream stream1;
    public transient SoundStream stream2;
    protected transient boolean active;
    protected transient float cachedAimedConditionVolume;
    protected transient float cachedAimedOutputVolume;
    protected transient AmbientVolume aimedVolume;
    protected transient float currentConditionVolume;
    protected transient float currentOutputVolume;
    protected transient float aimedPitch;
    protected transient int transition;
    protected transient int transitionTime;
    protected transient int pauseTimer;
    protected transient AmbientSoundProperties currentPropertries;
    protected transient AmbientEngine engine;
    protected transient List<AmbientSoundCategory> categories;

    public AmbientSound() {
        for (Class clazz = AmbientSound.class; clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                if (Modifier.isPrivate(field.getModifiers()) || Modifier.isFinal(field.getModifiers())) continue;
                COPYFIELDS.add(field);
            }
        }
        this.volumeSetting = 1.0;
        this.pauseTimer = -1;
    }

    public static class_3419 getSoundSource(String name) {
        if (AmbientSounds.CONFIG.useSoundMasterSource) {
            return class_3419.field_15250;
        }
        if (name == null) {
            return class_3419.field_15256;
        }
        for (int i = 0; i < class_3419.values().length; ++i) {
            if (!class_3419.values()[i].method_14840().equals(name)) continue;
            return class_3419.values()[i];
        }
        return class_3419.field_15256;
    }

    @Override
    public void init(AmbientEngine engine) throws AmbientEngineLoadException {
        if (this.files == null || this.files.length == 0) {
            throw new RuntimeException("Invalid sound " + this.name + " which does not contain any sound file");
        }
        super.init(engine);
        this.engine = engine;
        if (this.chances == null) {
            this.chances = new double[this.files.length];
            Arrays.fill(this.chances, 1.0 / (double)this.files.length);
        } else if (this.chances.length != this.files.length) {
            double[] newChances = new double[this.files.length];
            for (int i = 0; i < newChances.length; ++i) {
                newChances[i] = this.chances.length > i ? this.chances[i] : 1.0 / (double)this.files.length;
            }
            this.chances = newChances;
        }
        if (this.category != null && this.category.length > 0) {
            this.categories = new ArrayList<AmbientSoundCategory>();
            for (int i = 0; i < this.category.length; ++i) {
                AmbientSoundCategory cat = engine.getSoundCategory(this.category[i]);
                if (cat != null) {
                    this.categories.add(cat);
                    continue;
                }
                AmbientSounds.LOGGER.error("Could not find sound category {} for {}.", (Object)this.category[i], (Object)this.fullName);
            }
        }
    }

    protected int getRandomFile() {
        if (this.files.length == 1) {
            return 0;
        }
        return RANDOM.nextInt(this.files.length);
    }

    protected int getRandomFileExcept(int i) {
        if (this.files.length == 2) {
            return i == 0 ? 1 : 0;
        }
        int index = RANDOM.nextInt(this.files.length - 1);
        if (index >= i) {
            ++index;
        }
        return index;
    }

    public boolean fastTick(AmbientEnvironment env) {
        if (this.currentConditionVolume < this.cachedAimedConditionVolume) {
            this.currentConditionVolume = (float)((double)this.currentConditionVolume + Math.min(this.currentPropertries.getFadeInVolume(this.engine), (double)(this.cachedAimedConditionVolume - this.currentConditionVolume)));
        } else if (this.currentConditionVolume > this.cachedAimedConditionVolume) {
            this.currentConditionVolume = (float)((double)this.currentConditionVolume - Math.min(this.currentPropertries.getFadeOutVolume(this.engine), (double)(this.currentConditionVolume - this.cachedAimedConditionVolume)));
        }
        if (this.currentOutputVolume < this.cachedAimedOutputVolume) {
            this.currentOutputVolume = (float)((double)this.currentOutputVolume + Math.min(this.currentPropertries.getFadeInVolume(this.engine), (double)(this.cachedAimedOutputVolume - this.currentOutputVolume)));
        } else if (this.currentOutputVolume > this.cachedAimedOutputVolume) {
            this.currentOutputVolume = (float)((double)this.currentOutputVolume - Math.min(this.currentPropertries.getFadeOutVolume(this.engine), (double)(this.currentOutputVolume - this.cachedAimedOutputVolume)));
        }
        if (this.isPlaying()) {
            if (this.inTransition()) {
                this.stream1.transitionVolume = 1.0 - (double)this.transition / (double)this.transitionTime;
                this.stream2.transitionVolume = (double)this.transition / (double)this.transitionTime;
                if (this.transition >= this.transitionTime) {
                    this.engine.soundEngine.stop(this.stream1);
                    this.stream1 = this.stream2;
                    this.stream2 = null;
                }
                ++this.transition;
            } else {
                if (this.stream1.duration == -1 && this.currentPropertries.length != null) {
                    this.stream1.duration = (int)this.currentPropertries.length.randomValue();
                } else if (this.stream1.duration > 0 && this.currentPropertries.length == null) {
                    this.stream1.duration = -1;
                }
                this.stream1.transitionVolume = 1.0;
                if (this.currentPropertries.length != null) {
                    if (this.currentPropertries.pause == null && this.files.length > 1) {
                        if (this.stream1.remaining() <= 0) {
                            this.transition = 0;
                            this.stream2 = this.playTransition(this.getRandomFileExcept(this.stream1.index), env);
                            this.transitionTime = this.currentPropertries.transition != null ? this.currentPropertries.transition : 60;
                        }
                    } else {
                        int fadeOutTime = (int)Math.ceil((double)this.cachedAimedConditionVolume / this.currentPropertries.getFadeOutVolume(this.engine));
                        if (this.stream1.remaining() <= 0) {
                            this.engine.soundEngine.stop(this.stream1);
                            this.stream1 = null;
                            this.pauseTimer = -1;
                        } else if (fadeOutTime > this.stream1.remaining()) {
                            this.stream1.transitionVolume = this.stream1.remaining() / fadeOutTime;
                        }
                    }
                }
            }
            if (this.stream1 != null) {
                if (this.stream1.pitch < (double)this.aimedPitch) {
                    this.stream1.pitch += Math.min(this.currentPropertries.getFadeInPitch(this.engine), (double)this.aimedPitch - this.stream1.pitch);
                } else if (this.stream1.pitch > (double)this.aimedPitch) {
                    this.stream1.pitch -= Math.min(this.currentPropertries.getFadeOutPitch(this.engine), this.stream1.pitch - (double)this.aimedPitch);
                }
                ++this.stream1.ticksPlayed;
            }
            if (this.stream2 != null) {
                if (this.stream2.pitch < (double)this.aimedPitch) {
                    this.stream2.pitch += Math.min(this.currentPropertries.getFadeInPitch(this.engine), (double)this.aimedPitch - this.stream2.pitch);
                } else if (this.stream2.pitch > (double)this.aimedPitch) {
                    this.stream2.pitch -= Math.min(this.currentPropertries.getFadeOutPitch(this.engine), this.stream2.pitch - (double)this.aimedPitch);
                }
                ++this.stream2.ticksPlayed;
            }
        } else {
            if (this.stream2 != null) {
                this.engine.soundEngine.stop(this.stream2);
                this.stream2 = null;
            }
            if (this.pauseTimer == -1 && this.currentPropertries.pause != null) {
                this.pauseTimer = (int)this.currentPropertries.pause.randomValue();
            }
            if (this.pauseTimer <= 0) {
                this.stream1 = this.play(this.getRandomFile(), env);
            } else {
                --this.pauseTimer;
            }
        }
        return this.isAudible();
    }

    @Override
    public AmbientSelection value(AmbientEnvironment env) {
        if (this.volumeSetting == 0.0) {
            return null;
        }
        AmbientSelection value = super.value(env);
        if (value != null && this.categories != null) {
            ArrayList<AmbientSelection> collected = new ArrayList<AmbientSelection>();
            for (AmbientSoundCategory cat : this.categories) {
                if (cat.selection == null) {
                    return null;
                }
                collected.add(cat.selection);
            }
            value = new AmbientSelectionMulti(value, collected);
        }
        return value;
    }

    public boolean isAudible() {
        return this.cachedAimedConditionVolume > 0.0f || this.currentConditionVolume > 0.0f || this.currentOutputVolume > 0.0f;
    }

    public boolean tick(AmbientEnvironment env, AmbientSelection selection) {
        if (selection != null) {
            AmbientSelection soundSelection = this.value(env);
            if (soundSelection != null) {
                AmbientSelection last = selection.last();
                last.subSelection = soundSelection;
                this.aimedVolume = selection;
                this.cachedAimedConditionVolume = (float)selection.conditionVolume();
                this.cachedAimedOutputVolume = (float)(this.aimedVolume.volume() * this.volumeSetting * env.dimension.volumeSetting * AmbientSounds.CONFIG.volume);
                this.currentPropertries = selection.getProperties();
                last.subSelection = null;
                this.aimedPitch = class_3532.method_15363((float)this.currentPropertries.getPitch(env), (float)0.5f, (float)2.0f);
            } else {
                this.aimedVolume = AmbientVolume.SILENT;
                this.cachedAimedOutputVolume = 0.0f;
                this.cachedAimedConditionVolume = 0.0f;
            }
        } else {
            this.aimedVolume = AmbientVolume.SILENT;
            this.cachedAimedOutputVolume = 0.0f;
            this.cachedAimedConditionVolume = 0.0f;
        }
        return this.isAudible();
    }

    protected SoundStream play(int index, AmbientEnvironment env) {
        SoundStream stream = new SoundStream(index);
        stream.pitch = this.aimedPitch;
        if (this.currentPropertries.length != null) {
            stream.duration = (int)this.currentPropertries.length.randomValue();
        }
        this.engine.soundEngine.play(stream);
        return stream;
    }

    protected SoundStream playTransition(int index, AmbientEnvironment env) {
        SoundStream stream = new SoundStream(index);
        stream.pitch = this.aimedPitch;
        if (this.currentPropertries.length != null) {
            stream.duration = (int)this.currentPropertries.length.randomValue();
        }
        stream.transitionVolume = 0.0;
        stream.effectiveVolume = (float)stream.combinedVolume();
        this.engine.soundEngine.play(stream);
        return stream;
    }

    public boolean isPlaying() {
        return this.stream1 != null;
    }

    public boolean inTransition() {
        return this.stream1 != null && this.stream2 != null;
    }

    public boolean isActive() {
        return this.active;
    }

    public void activate() {
        this.active = true;
    }

    public void deactivate() {
        this.active = false;
        if (this.stream1 != null) {
            this.engine.soundEngine.stop(this.stream1);
            this.stream1 = null;
        }
        if (this.stream2 != null) {
            this.engine.soundEngine.stop(this.stream2);
            this.stream2 = null;
        }
    }

    public void onSoundFinished() {
        if (this.stream1 != null && this.stream1.finished) {
            this.stream1 = null;
            this.pauseTimer = -1;
        } else {
            this.stream2 = null;
        }
    }

    public boolean loop() {
        return this.currentPropertries.length != null || this.currentPropertries.pause == null && this.files.length == 1;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.name);
        if (this.stream1 != null) {
            builder.append("[" + String.valueOf(this.stream1) + "]");
        }
        if (this.stream2 != null) {
            builder.append("[" + String.valueOf(this.stream2) + "]");
        }
        if (this.inTransition()) {
            builder.append("t: " + this.transition + "/" + this.transitionTime);
        }
        return builder.toString();
    }

    public AmbientSound copy() {
        AmbientSound copy = new AmbientSound();
        for (Field field : COPYFIELDS) {
            try {
                field.set(copy, field.get(this));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return copy;
    }

    public class SoundStream
    implements class_1117,
    SpecialSoundInstance {
        private static final class_5819 rand = class_5819.method_43053();
        public final int index;
        public final class_2960 location;
        public float effectiveVolume;
        public double transitionVolume = 1.0;
        public class_1111 sound;
        public double pitch;
        public int duration = -1;
        public int ticksPlayed = 0;
        private boolean finished = false;
        private boolean playedOnce;
        public final class_3419 category;

        public SoundStream(int index) {
            this.index = index;
            this.location = AmbientSound.this.files[index];
            this.category = AmbientSound.getSoundSource(AmbientSound.this.currentPropertries.channel);
            this.effectiveVolume = (float)this.combinedVolume();
        }

        public boolean loop() {
            return AmbientSound.this.loop();
        }

        public int remaining() {
            return this.duration - this.ticksPlayed;
        }

        public double conditionVolume() {
            return AmbientSound.this.currentConditionVolume;
        }

        public double combinedVolume() {
            return (double)AmbientSound.this.currentOutputVolume * this.transitionVolume;
        }

        public double mute() {
            return AmbientSound.this.currentPropertries.mute == null ? 0.0 : AmbientSound.this.currentPropertries.mute * this.conditionVolume();
        }

        public double mutePriority() {
            return AmbientSound.this.currentPropertries.mutePriority != null ? AmbientSound.this.currentPropertries.mutePriority : 0.0;
        }

        public void onStart() {
            this.finished = false;
            this.playedOnce = false;
        }

        public void onFinished() {
            this.finished = true;
            AmbientSound.this.onSoundFinished();
        }

        public boolean hasPlayedOnce() {
            return this.playedOnce;
        }

        public void setPlayedOnce() {
            this.playedOnce = true;
        }

        public boolean hasFinished() {
            return this.finished;
        }

        public String toString() {
            return "l:" + String.valueOf(this.location) + ",v:" + DebugTextRenderer.DECIMAL_FORMAT.format(AmbientSound.this.volume) + "(" + DebugTextRenderer.DECIMAL_FORMAT.format(this.conditionVolume()) + "),i:" + this.index + ",p:" + this.pitch + ",t:" + this.ticksPlayed + ",d:" + this.duration;
        }

        public boolean method_4786() {
            return this.loop();
        }

        public class_1146 method_4783(class_1144 soundManager) {
            if (this.location.equals((Object)class_1144.field_42934)) {
                this.sound = class_1144.field_42936;
                return class_1144.field_42935;
            }
            class_1146 weighedSoundEvents = soundManager.method_4869(this.location);
            this.sound = weighedSoundEvents == null ? class_1144.field_5592 : weighedSoundEvents.method_4887(rand);
            return weighedSoundEvents;
        }

        public class_1113.class_1114 method_4777() {
            return class_1113.class_1114.field_5478;
        }

        public class_3419 method_4774() {
            return this.category;
        }

        public float method_4782() {
            return (float)this.pitch;
        }

        public int method_4780() {
            return 0;
        }

        public class_1111 method_4776() {
            return this.sound;
        }

        public class_2960 method_4775() {
            return this.location;
        }

        public float method_4781() {
            return this.effectiveVolume;
        }

        public double method_4784() {
            return 0.0;
        }

        public double method_4779() {
            return 0.0;
        }

        public double method_4778() {
            return 0.0;
        }

        public boolean method_4793() {
            return false;
        }

        public void method_16896() {
        }

        public boolean method_4787() {
            return true;
        }

        public boolean method_4785() {
            return true;
        }

        public CompletableFuture<class_4234> getAudioStream(class_4237 loader, final class_2960 id, boolean looping) {
            return CompletableFuture.supplyAsync(() -> {
                try {
                    final class_3298 resource = ((SoundBufferLibraryAccessor)loader).getResourceManager().getResourceOrThrow(id);
                    InputStream inputstream = resource.method_14482();
                    return looping ? new class_4856(new class_4856.class_4857(){
                        boolean first = true;

                        public class_4234 create(InputStream inputstream) throws IOException {
                            try {
                                class_4228 stream = new class_4228(inputstream);
                                if (this.first && AmbientSound.this.currentPropertries.randomOffset && AmbientSounds.CONFIG.playSoundWithOffset && !((OggAudioStreamExtended)stream).setPositionRandomly(ResourceUtils.length((class_3264)class_3264.field_14188, (class_3298)resource, (class_2960)id), id)) {
                                    inputstream.reset();
                                    stream = new class_4228(inputstream);
                                }
                                this.first = false;
                                return stream;
                            }
                            catch (Exception e2) {
                                inputstream.reset();
                                return new class_4228(inputstream);
                            }
                        }
                    }, inputstream) : new class_4228(inputstream);
                }
                catch (IOException ioexception) {
                    AmbientSounds.LOGGER.error((Object)ioexception);
                    throw new CompletionException(ioexception);
                }
            }, (Executor)class_156.method_55473());
        }

        public void collectDetails(DebugTextRenderer text) {
            text.text("[");
            text.detail("n", (Object)this.location);
            text.detail("v", (Object)Float.valueOf(this.effectiveVolume));
            text.detail("cv", (Object)this.conditionVolume());
            text.detail("i", (Object)this.index);
            text.detail("p", (Object)this.pitch);
            text.detail("t", (Object)this.ticksPlayed);
            text.detail("d", (Object)this.duration);
            text.text("]");
        }
    }
}

