/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds.entity;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;
import org.apache.commons.lang3.ArrayUtils;
import team.creative.ambientsounds.condition.AmbientCondition;
import team.creative.ambientsounds.engine.AmbientEngine;
import team.creative.ambientsounds.environment.AmbientEnvironment;

public class AmbientEntityCondition {
    public AmbientCondition.AmbientMinMaxFadeCondition distance;
    @SerializedName(value="distance-x")
    public AmbientCondition.AmbientMinMaxFadeCondition distanceX;
    @SerializedName(value="distance-y")
    public AmbientCondition.AmbientMinMaxFadeCondition distanceY;
    @SerializedName(value="distance-z")
    public AmbientCondition.AmbientMinMaxFadeCondition distanceZ;
    public AmbientCondition.AmbientMinMaxFadeCondition count;
    @JsonAdapter(value=StringJson.class)
    public String[] name;
    @SerializedName(value="bad-name")
    @JsonAdapter(value=StringJson.class)
    public String[] badName;
    @JsonAdapter(value=StringJson.class)
    public String[] type;
    @SerializedName(value="bad-type")
    @JsonAdapter(value=StringJson.class)
    public String[] badType;
    private transient List<EntityType> parsedType;
    private transient List<EntityType> parsedBadType;
    public Map<String, String> scores;
    @JsonAdapter(value=StringJson.class)
    public String[] tag;
    @SerializedName(value="bad-tag")
    @JsonAdapter(value=StringJson.class)
    public String[] badTag;
    @JsonAdapter(value=StringJson.class)
    public String[] team;
    @SerializedName(value="bad-team")
    @JsonAdapter(value=StringJson.class)
    public String[] badTeam;
    @JsonAdapter(value=StringJson.class)
    public String[] nbt;
    @SerializedName(value="bad-nbt")
    @JsonAdapter(value=StringJson.class)
    public String[] badNbt;
    private transient List<CompoundTag> parsedNbt;
    private transient List<CompoundTag> parsedBadNbt;
    public AmbientCondition.AmbientMinMaxFadeCondition level;
    public AmbientCondition.AmbientMinMaxFadeCondition x_rotation;
    public AmbientCondition.AmbientMinMaxFadeCondition y_rotation;

    public void init(AmbientEngine engine) {
        Optional result;
        ResourceLocation location;
        if (this.type != null) {
            this.parsedType = new ArrayList<EntityType>();
            for (String entityType : this.type) {
                location = ResourceLocation.parse((String)entityType);
                result = BuiltInRegistries.ENTITY_TYPE.getOptional(location);
                if (!result.isPresent()) continue;
                this.parsedType.add((EntityType)result.get());
            }
        }
        if (this.badType != null) {
            this.parsedBadType = new ArrayList<EntityType>();
            for (String entityType : this.badType) {
                location = ResourceLocation.parse((String)entityType);
                result = BuiltInRegistries.ENTITY_TYPE.getOptional(location);
                if (!result.isPresent()) continue;
                this.parsedBadType.add((EntityType)result.get());
            }
        }
        if (this.nbt != null) {
            this.parsedNbt = new ArrayList<CompoundTag>();
            for (String tag : this.nbt) {
                try {
                    this.parsedNbt.add(TagParser.parseCompoundFully((String)tag));
                }
                catch (CommandSyntaxException e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.badNbt != null) {
            this.parsedBadNbt = new ArrayList<CompoundTag>();
            for (String tag : this.badNbt) {
                try {
                    this.parsedBadNbt.add(TagParser.parseCompoundFully((String)tag));
                }
                catch (CommandSyntaxException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public double value(AmbientEnvironment env) {
        double highest = 0.0;
        int counted = 0;
        for (Entity entity : env.entity.all()) {
            if (this.name != null && !this.checkEntityName(this.name, entity) || this.badName != null && this.checkEntityName(this.badName, entity) || this.parsedType != null && !this.parsedType.contains(entity.getType()) || this.parsedBadType != null && this.parsedBadType.contains(entity.getType()) || this.tag != null && !this.containsTag(this.tag, entity) || this.badTag != null && this.containsTag(this.badTag, entity) || this.team != null && !this.isTeam(this.team, entity) || this.badTeam != null && this.isTeam(this.badTeam, entity) || this.parsedNbt != null && !this.hasNbt(this.parsedNbt, entity) || this.parsedBadNbt != null && this.hasNbt(this.parsedBadNbt, entity)) continue;
            double current = 1.0;
            if (this.distance != null) {
                current *= this.distance.volume(Math.sqrt(env.entity.squaredDistance(entity)));
            }
            if (this.distanceX != null) {
                current *= this.distanceX.volume(entity.position().x - env.entity.x());
            }
            if (this.distanceY != null) {
                current *= this.distanceY.volume(entity.position().y - env.entity.y());
            }
            if (this.distanceZ != null) {
                current *= this.distanceZ.volume(entity.position().z - env.entity.z());
            }
            if (this.x_rotation != null) {
                current *= this.x_rotation.volume(entity.getXRot());
            }
            if (this.y_rotation != null) {
                current *= this.y_rotation.volume(entity.getYRot());
            }
            ++counted;
            if (current == 1.0 && this.count == null) {
                return 1.0;
            }
            highest = Math.max(current, highest);
        }
        if (this.count != null) {
            highest *= this.count.volume(counted);
        }
        return highest;
    }

    private boolean hasNbt(List<CompoundTag> nbt, Entity entity) {
        TagValueOutput tagvalueoutput = TagValueOutput.createWithContext((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)entity.registryAccess());
        entity.saveWithoutId((ValueOutput)tagvalueoutput);
        CompoundTag tag = tagvalueoutput.buildResult();
        for (CompoundTag check : nbt) {
            if (!NbtUtils.compareNbt((Tag)check, (Tag)tag, (boolean)true)) continue;
            return true;
        }
        return false;
    }

    private boolean isTeam(String[] team, Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        return ArrayUtils.contains((Object[])team, (Object)(entity.getTeam() == null ? "" : entity.getTeam().getName()));
    }

    private boolean containsTag(String[] tag, Entity entity) {
        Set tags = entity.getTags();
        for (int i = 0; i < tag.length; ++i) {
            if (!tags.contains(tag[i])) continue;
            return true;
        }
        return false;
    }

    private boolean checkEntityName(String[] name, Entity entity) {
        Player p;
        if (entity instanceof Player && ArrayUtils.contains((Object[])name, (Object)(p = (Player)entity).getGameProfile().name())) {
            return true;
        }
        if (ArrayUtils.contains((Object[])name, (Object)entity.getStringUUID())) {
            return true;
        }
        return entity.hasCustomName() && ArrayUtils.contains((Object[])name, (Object)entity.getCustomName().getString());
    }

    public static class StringJson
    extends TypeAdapter<String[]> {
        public void write(JsonWriter out, String[] value) throws IOException {
            if (value.length > 1) {
                out.beginArray();
                for (String string : value) {
                    out.value(string);
                }
                out.endArray();
            } else {
                out.value(value.length == 0 ? "" : value[0]);
            }
        }

        public String[] read(JsonReader in) throws IOException {
            JsonToken token = in.peek();
            if (token == JsonToken.STRING) {
                String value = in.nextString();
                if (value.isEmpty()) {
                    return new String[0];
                }
                return new String[]{value};
            }
            ArrayList<String> list = new ArrayList<String>();
            in.beginArray();
            while (in.hasNext()) {
                list.add(in.nextString());
            }
            in.endArray();
            return list.toArray(new String[list.size()]);
        }
    }
}

