// priority: 100

/**
 * @file Constants used by other loot table scripts.
 */

const AQUAMIRAE_SHELTER_MAP =
  Item.of('supplementaries:cartographers_quill', '{decoration:"filled_map.aquamirae_shelter",\
           display:{Name:\'{"translate":"filled_map.aquamirae_shelter"}\'},maxSearchRadius:100,skinKnown:1b,\
           targetStructure:"aquamirae:shelter",zoomLevel:2}');

const AETHER_CITADEL_MAP =
  Item.of('supplementaries:cartographers_quill', '{decoration:"filled_map.aether_citadel",\
           display:{Name:\'{"translate":"filled_map.aether_citadel"}\'},maxSearchRadius:100,skinKnown:1b,\
           targetStructure:"aether_villages:olympic_citadel",zoomLevel:2}');

const AETHER_BRONZE_DUNGEON_MAP =
  Item.of('supplementaries:cartographers_quill', '{decoration:"filled_map.aether_bronze_dungeon",\
           display:{Name:\'{"translate":"filled_map.aether_bronze_dungeon"}\'},maxSearchRadius:100,skinKnown:1b,\
           targetStructure:"aether:bronze_dungeon",zoomLevel:2}');

const AETHER_GOLD_DUNGEON_MAP =
  Item.of('supplementaries:cartographers_quill', '{decoration:"filled_map.aether_gold_dungeon",\
           display:{Name:\'{"translate":"filled_map.aether_gold_dungeon"}\'},maxSearchRadius:100,skinKnown:1b,\
           targetStructure:"aether:gold_dungeon",zoomLevel:2}');

const AETHER_SILVER_DUNGEON_MAP =
  Item.of('supplementaries:cartographers_quill', '{decoration:"filled_map.aether_silver_dungeon",\
           display:{Name:\'{"translate":"filled_map.aether_silver_dungeon"}\'},maxSearchRadius:100,skinKnown:1b,\
           targetStructure:"aether:silver_dungeon",zoomLevel:2}');

const AETHER_PLATINUM_DUNGEON_MAP =
  Item.of('supplementaries:cartographers_quill', '{decoration:"filled_map.aether_platinum_dungeon",\
           display:{Name:\'{"translate":"filled_map.aether_platinum_dungeon"}\'},maxSearchRadius:100,skinKnown:1b,\
           targetStructure:"lost_aether_content:platinum_dungeon",zoomLevel:2}');

const EIDOLON_LAB_MAP =
  Item.of('supplementaries:cartographers_quill', '{decoration:"filled_map.eidolon_lab",\
           display:{Name:\'{"translate":"filled_map.eidolon_lab"}\'},maxSearchRadius:100,skinKnown:1b,\
           targetStructure:"eidolon:lab",zoomLevel:2}');

const EIDOLON_CATACOMB_MAP =
  Item.of('supplementaries:cartographers_quill', '{decoration:"filled_map.eidolon_catacomb",\
           display:{Name:\'{"translate":"filled_map.eidolon_catacomb"}\'},maxSearchRadius:100,skinKnown:1b,\
           targetStructure:"eidolon:catacomb",zoomLevel:2}');

const NETHER_FORTRESS_MAP =
  Item.of('supplementaries:cartographers_quill', '{decoration:"filled_map.nether_fortress",\
           display:{Name:\'{"translate":"filled_map.nether_fortress"}\'},maxSearchRadius:100,skinKnown:1b,\
           targetStructure:"betterfortresses:fortress",zoomLevel:2}');

const PIGLIN_VILLAGE_MAP =
  Item.of('supplementaries:cartographers_quill', '{decoration:"filled_map.piglin_village",\
           display:{Name:\'{"translate":"filled_map.piglin_village"}\'},maxSearchRadius:100,skinKnown:1b,\
           targetStructure:"incendium:piglin_village",zoomLevel:2}');

const FORBIDDEN_CASTLE_MAP =
  Item.of('supplementaries:cartographers_quill', '{decoration:"filled_map.forbidden_castle",\
           display:{Name:\'{"translate":"filled_map.forbidden_castle"}\'},maxSearchRadius:100,skinKnown:1b,\
           targetStructure:"incendium:forbidden_castle",zoomLevel:2}');

const DESERT_TEMPLE_MAP =
  Item.of('supplementaries:cartographers_quill', '{decoration:"filled_map.better_desert_temple",\
           display:{Name:\'{"translate":"filled_map.better_desert_temple"}\'},maxSearchRadius:100,skinKnown:1b,\
           targetStructure:"betterdeserttemples:desert_temple",zoomLevel:2}');

const JUNGLE_TEMPLE_MAP =
  Item.of('supplementaries:cartographers_quill', '{decoration:"filled_map.better_jungle_temple",\
           display:{Name:\'{"translate":"filled_map.better_jungle_temple"}\'},maxSearchRadius:100,skinKnown:1b,\
           targetStructure:"betterjungletemples:jungle_temple",zoomLevel:2}');

const ANCIENT_CITY_MAP =
  Item.of('supplementaries:cartographers_quill', '{decoration:"filled_map.ancient_city",\
           display:{Name:\'{"translate":"filled_map.ancient_city"}\'},maxSearchRadius:100,skinKnown:1b,\
           targetStructure:"minecraft:ancient_city",zoomLevel:2}');

const MANSION_MAP =
  Item.of('supplementaries:cartographers_quill', '{decoration:"filled_map.mansion",\
           display:{Name:\'{"translate":"filled_map.mansion"}\'},maxSearchRadius:100,skinKnown:1b,\
           targetStructure:"minecraft:mansion",zoomLevel:2}');

const EVOKER_FORT_MAP =
  Item.of('supplementaries:cartographers_quill', '{decoration:"filled_map.evoker_fort",\
           display:{Name:\'{"translate":"filled_map.evoker_fort"}\'},maxSearchRadius:100,skinKnown:1b,\
           targetStructure:"irons_spellbooks:evoker_fort",zoomLevel:2}');

const IMPALED_ICEBREAKER_MAP =
  Item.of('supplementaries:cartographers_quill', '{decoration:"filled_map.impaled_icebreaker",\
           display:{Name:\'{"translate":"filled_map.impaled_icebreaker"}\'},maxSearchRadius:100,skinKnown:1b,\
           targetStructure:"irons_spellbooks:impaled_icebreaker",zoomLevel:2}');

const TINKERS_CITADEL_MAP =
  Item.of('supplementaries:cartographers_quill', '{decoration:"filled_map.tinkers_citadel",\
           display:{Name:\'{"translate":"filled_map.tinkers_citadel"}\'},maxSearchRadius:100,skinKnown:1b,\
           targetStructure:"idas:tinkers_citadel",zoomLevel:2}');

const TINKERS_WORKSHOP_MAP =
  Item.of('supplementaries:cartographers_quill', '{decoration:"filled_map.tinkers_workshop",\
           display:{Name:\'{"translate":"filled_map.tinkers_workshop"}\'},maxSearchRadius:100,skinKnown:1b,\
           targetStructure:"idas:tinkers_workshop",zoomLevel:2}');

const ANCIENT_MINES_MAP =
  Item.of('supplementaries:cartographers_quill', '{decoration:"filled_map.ancient_mines",\
           display:{Name:\'{"translate":"filled_map.ancient_mines"}\'},maxSearchRadius:100,skinKnown:1b,\
           targetStructure:"idas:ancient_mines",zoomLevel:2}');

const TREE_OF_WISDOM_MAP =
  Item.of('supplementaries:cartographers_quill', '{decoration:"filled_map.tree_of_wisdom",\
           display:{Name:\'{"translate":"filled_map.tree_of_wisdom"}\'},maxSearchRadius:100,skinKnown:1b,\
           targetStructure:"idas:tree_of_wisdom",zoomLevel:2}');

const ARCHMAGES_TOWER_MAP =
  Item.of('supplementaries:cartographers_quill', '{decoration:"filled_map.archmages_tower",\
           display:{Name:\'{"translate":"filled_map.archmages_tower"}\'},maxSearchRadius:100,skinKnown:1b,\
           targetStructure:"idas:archmages_tower",zoomLevel:2}');

const HAUNTED_MANOR_MAP =
  Item.of('supplementaries:cartographers_quill', '{decoration:"filled_map.haunted_manor",\
           display:{Name:\'{"translate":"filled_map.haunted_manor"}\'},maxSearchRadius:100,skinKnown:1b,\
           targetStructure:"idas:haunted_manor",zoomLevel:2}');

const TRAIN_RUINS_MAP =
  Item.of('supplementaries:cartographers_quill', '{decoration:"filled_map.train_ruins",\
           display:{Name:\'{"translate":"filled_map.train_ruins"}\'},maxSearchRadius:100,skinKnown:1b,\
           targetStructure:"idas:train_ruins",zoomLevel:2}');

const UNDERSEA_VILLAGE_MAP =
  Item.of('supplementaries:cartographers_quill', '{decoration:"filled_map.undersea_village",\
           display:{Name:\'{"translate":"filled_map.undersea_village"}\'},maxSearchRadius:100,skinKnown:1b,\
           targetStructure:"seavil:undersea_village",zoomLevel:2}');

const GRAVEYARD_CRYPT_MAP =
  Item.of('supplementaries:cartographers_quill', '{decoration:"filled_map.graveyard_crypt",\
           display:{Name:\'{"translate":"filled_map.graveyard_crypt"}\'},maxSearchRadius:100,skinKnown:1b,\
           targetStructure:"graveyard:crypt",zoomLevel:2}');

const GRAVEYARD_RUINS_MAP =
  Item.of('supplementaries:cartographers_quill', '{decoration:"filled_map.graveyard_ruins",\
           display:{Name:\'{"translate":"filled_map.graveyard_ruins"}\'},maxSearchRadius:100,skinKnown:1b,\
           targetStructure:"graveyard:ruins",zoomLevel:2}');

const BTH_RUINED_HANGAR_MAP =
  Item.of('supplementaries:cartographers_quill', '{decoration:"filled_map.bth_structures_ruined_hangar",\
           display:{Name:\'{"translate":"filled_map.bth_structures_ruined_hangar"}\'},maxSearchRadius:100,skinKnown:1b,\
           targetStructure:"bth_structures:ruined_hangar",zoomLevel:2}');

const BTH_MAGICIAN_HOUSE_MAP =
  Item.of('supplementaries:cartographers_quill', '{decoration:"filled_map.bth_structures_magician_house",\
           display:{Name:\'{"translate":"filled_map.bth_structures_magician_house"}\'},maxSearchRadius:100,skinKnown:1b,\
           targetStructure:"bth_structures:magician_house",zoomLevel:2}');

const BTH_TINKERER_HOUSE_MAP =
  Item.of('supplementaries:cartographers_quill', '{decoration:"filled_map.bth_structures_tinkerer_house",\
           display:{Name:\'{"translate":"filled_map.bth_structures_tinkerer_house"}\'},maxSearchRadius:100,skinKnown:1b,\
           targetStructure:"bth_structures:tinkerer_house",zoomLevel:2}');

const BTH_BATTLE_GROUNDS_MAP =
  Item.of('supplementaries:cartographers_quill', '{decoration:"filled_map.bth_structures_battle_grounds",\
           display:{Name:\'{"translate":"filled_map.bth_structures_battle_grounds"}\'},maxSearchRadius:100,skinKnown:1b,\
           targetStructure:"bth_structures:battle_grounds",zoomLevel:2}');

const BTH_DW20_MAP =
  Item.of('supplementaries:cartographers_quill', '{decoration:"filled_map.bth_structures_dw20",\
           display:{Name:\'{"translate":"filled_map.bth_structures_dw20"}\'},maxSearchRadius:100,skinKnown:1b,\
           targetStructure:"bth_structures:dw20",zoomLevel:2}');

const BTH_WAGON_MAP =
  Item.of('supplementaries:cartographers_quill', '{decoration:"filled_map.bth_structures_wagon",\
           display:{Name:\'{"translate":"filled_map.bth_structures_wagon"}\'},maxSearchRadius:100,skinKnown:1b,\
           targetStructure:"bth_structures:wagon",zoomLevel:2}');

const BTH_ELVEN_GATEWAY_MAP =
  Item.of('supplementaries:cartographers_quill', '{decoration:"filled_map.bth_structures_elven_gateway",\
           display:{Name:\'{"translate":"filled_map.bth_structures_elven_gateway"}\'},maxSearchRadius:100,skinKnown:1b,\
           targetStructure:"bth_structures:elven_gateway",zoomLevel:2}');

const DESERT_MAP = Item.of('quark:pathfinders_quill', '{targetBiome:"minecraft:desert",targetBiomeColor:8381695,targetBiomeUnderground:0b}');
const FLOWER_FOREST_MAP = Item.of('quark:pathfinders_quill', '{targetBiome:"minecraft:flower_forest",targetBiomeColor:ffff00,targetBiomeUnderground:0b}');
const SNOWY_PLAINS_MAP = Item.of('quark:pathfinders_quill', '{targetBiome:"minecraft:snowy_plains",targetBiomeColor:ffffff,targetBiomeUnderground:0b}');
const SWAMP_MAP = Item.of('quark:pathfinders_quill', '{targetBiome:"minecraft:swamp",targetBiomeColor:006600,targetBiomeUnderground:0b}');
const JUNGLE_MAP = Item.of('quark:pathfinders_quill', '{targetBiome:"minecraft:jungle",targetBiomeColor:009933,targetBiomeUnderground:0b}');
const LUSH_CAVES_MAP = Item.of('quark:pathfinders_quill', '{targetBiome:"minecraft:lush_caves",targetBiomeColor:ccff66,targetBiomeUnderground:0b}');
const CHERRY_GROVE_MAP = Item.of('quark:pathfinders_quill', '{targetBiome:"minecraft:cherry_grove",targetBiomeColor:ff66cc,targetBiomeUnderground:0b}');
const ARCHWOOD_FOREST_MAP = Item.of('quark:pathfinders_quill', '{targetBiome:"ars_nouveau:archwood_forest",targetBiomeColor:6b0080,targetBiomeUnderground:0b}');
const HAZE_MOUNTAIN_MAP = Item.of('quark:pathfinders_quill', '{targetBiome:"terralith:haze_mountain",targetBiomeColor:00cc00,targetBiomeUnderground:0b}');

const DRAGON_EGG_AETHER = Item.of('dragonmounts:dragon_egg', '{BlockEntityTag:{Breed:"dragonmounts:aether"}}');
const DRAGON_EGG_END = Item.of('dragonmounts:dragon_egg', '{BlockEntityTag:{Breed:"dragonmounts:end"}}');
const DRAGON_EGG_FIRE = Item.of('dragonmounts:dragon_egg', '{BlockEntityTag:{Breed:"dragonmounts:fire"}}');
const DRAGON_EGG_FOREST = Item.of('dragonmounts:dragon_egg', '{BlockEntityTag:{Breed:"dragonmounts:forest"}}');
const DRAGON_EGG_GHOST = Item.of('dragonmounts:dragon_egg', '{BlockEntityTag:{Breed:"dragonmounts:ghost"}}');
const DRAGON_EGG_ICE = Item.of('dragonmounts:dragon_egg', '{BlockEntityTag:{Breed:"dragonmounts:ice"}}');
const DRAGON_EGG_NETHER = Item.of('dragonmounts:dragon_egg', '{BlockEntityTag:{Breed:"dragonmounts:nether"}}');
const DRAGON_EGG_WATER = Item.of('dragonmounts:dragon_egg', '{BlockEntityTag:{Breed:"dragonmounts:water"}}');


const COIN_LOOT_LOW = [
  'aether_villages:chests/olympic_citadel/olympic_citadel_normal',
  'aether:chests/dungeon/bronze/bronze_dungeon_reward',
  'aether:chests/dungeon/gold/gold_dungeon_reward',
  'aether:chests/dungeon/silver/silver_dungeon_reward',
  'aether:chests/ruined_portal',
  'alexscaves:chests/underground_cabin_abyssal_chasm',
  'alexscaves:chests/underground_cabin_forlorn_hollows',
  'alexscaves:chests/underground_cabin_magnetic_caves',
  'alexscaves:chests/underground_cabin_primordial_caves',
  'alexscaves:chests/underground_cabin_toxic_caves',
  'aquamirae:chests/maze_common_chest',
  'artifacts:chests/campsite_barrel/gems',
  'artifacts:chests/campsite_barrel/ingots',
  'artifacts:chests/campsite_barrel/minecarts',
  'artifacts:chests/campsite_barrel/ores',
  'artifacts:chests/campsite_barrel/rails',
  'artifacts:chests/campsite_barrel/tnt',
  'betterdungeons:skeleton_dungeon/chests/common',
  'betterdungeons:small_nether_dungeon/chests/common',
  'betterdungeons:zombie_dungeon/chests/common',
  'betterfortresses:chests/hall',
  'bth_structures:chests/aether_portal_framed',
  'bth_structures:chests/battle_grounds/aether',
  'bth_structures:chests/battle_grounds/nether',
  'bth_structures:chests/magician_house_loft',
  'bth_structures:chests/ruined_hangar_bunker',
  'bth_structures:chests/tower_top',
  'bth_structures:chests/watch_tower_top',
  'bth_structures:chests/dw20/large_room',
  'chefsdelight:chests/cooker',
  'ctov:chests/village/village_bakery',
  'ctov:chests/village/village_farm',
  'ctov:chests/village/village_library',
  'ctov:chests/village/village_smith',
  'domesticationinnovation:chests/petshop_chest',
  'graveyard:chests/crypt_urn_loot',
  'graveyard:chests/medium_loot',
  'graveyard:chests/small_graveyard_loot',
  'graveyard:chests/small_loot',
  'hauntedharvest:chests/abandoned_farm',
  'idas:chests/abandonedhouse/abandonedhouse_library',
  'idas:chests/apothecary_abode/apothecary_abode',
  'idas:chests/bearclaw_inn/bearclaw_inn_bedroom',
  'idas:chests/beekeepers_house/beekeepers_bedroom',
  'idas:chests/castle/castle',
  'idas:chests/farmhouse/farmhouse_bedroom',
  'idas:chests/hermits_hollow/hollow_bedroom',
  'idas:chests/pillager_fortress/pillager_bedroom',
  'idas:chests/redhorn_guild/redhorn_guild_bedroom',
  'idas:chests/ruins_of_the_deep/ruins_bedroom',
  'idas:chests/tinkers_workshop/tinkers_workshop_bedroom',
  'idas:chests/train_ruins/train_ruins',
  'idas:chests/treetop_tavern/treetop_tavern_bedroom',
  'idas:chests/winter_wagon/winter_wagon',
  'integrated_stronghold:chests/bedroom',
  'integrated_stronghold:chests/dining_hall',
  'irons_spellbooks:chests/bookshelf_loot',
  'irons_spellbooks:chests/catacombs/wall_loot',
  'irons_spellbooks:chests/citadel/wall_loot',
  'irons_spellbooks:chests/component_storage',
  'irons_spellbooks:chests/evoker_fort',
  'irons_spellbooks:chests/evoker_fort/guard_tower',
  'irons_spellbooks:chests/mangrove_hut/potion_ingredient_storage',
  'irons_spellbooks:chests/priest_house',
  'minecraft:chests/bastion_bridge',
  'minecraft:chests/bastion_other',
  'minecraft:chests/stronghold_crossing',
  'minecraft:chests/village/village_desert_house',
  'minecraft:chests/village/village_plains_house',
  'minecraft:chests/village/village_savanna_house',
  'minecraft:chests/village/village_snowy_house',
  'minecraft:chests/village/village_taiga_house',
  'rats:chest/pet_shop_upstairs',
  'rats:chest/pet_shop',
  'ribbits:chests/nitwit',
  'valhelsia_structures:chests/player_house',
];

const COIN_LOOT_MEDIUM = [
  'alexsmobs:gameplay/trader_elephant_chest',
  'artifacts:chests/campsite_chest',
  'betterdeserttemples:chests/library',
  'betterdeserttemples:chests/tomb_pharaoh',
  'betterdungeons:skeleton_dungeon/chests/middle',
  'betterdungeons:spider_dungeon/chests/egg_room',
  'betterdungeons:zombie_dungeon/chests/special',
  'betterdungeons:zombie_dungeon/chests/tombstone',
  'betterfortresses:chests/extra',
  'betterfortresses:chests/obsidian',
  'betterfortresses:chests/quarters',
  'bth_structures:chests/elven_gateway/tree',
  'bth_structures:chests/tower_top',
  'bth_structures:chests/watch_tower_top',
  'galosphere:chests/pink_salt_shrine',
  'graveyard:chests/great_crypt_loot',
  'idas:chests/ancient_mines/mineshall',
  'idas:chests/ancient_portal/ancient_portal_nether',
  'idas:chests/ancient_portal/ancient_portal_overworld',
  'idas:chests/enchantingtower/enchantingtower_top_ars',
  'idas:chests/train_ruins/train_ruins_bedroom',
  'idas:chests/tree_of_wisdom/tree_of_wisdom',
  'idas:chests/witches_treestump/witches_treestump',
  'idas:chests/wizardtower/wizardtower_top',
  'immersiveengineering:chests/engineers_house',
  'incendium:castle/barrel/monument',
  'incendium:pipeline/base/rare',
  'incendium:pipeline/rare',
  'incendium:sanctum/sanctum/coffin',
  'irons_spellbooks:chests/battleground/burial_loot',
  'irons_spellbooks:chests/battleground/piglin_camp',
  'irons_spellbooks:chests/catacombs/coffin_loot',
  'irons_spellbooks:chests/magic_bookshelf_loot',
  'irons_spellbooks:chests/mangrove_hut',
  'irons_spellbooks:chests/mountain_tower/mountain_tower',
  'irons_spellbooks:chests/pyromancer_tower/pyromancer_supplies',
  'minecraft:chests/abandoned_mineshaft',
  'minecraft:chests/ancient_city_ice_box',
  'minecraft:chests/ancient_city',
  'minecraft:chests/buried_treasure',
  'minecraft:chests/chests/woodland_mansion',
  'minecraft:chests/desert_pyramid',
  'minecraft:chests/end_city_treasure',
  'minecraft:chests/igloo_chest',
  'minecraft:chests/jungle_temple',
  'minecraft:chests/nether_bridge',
  'minecraft:chests/shipwreck_supply',
  'minecraft:chests/simple_dungeon',
  'minecraft:chests/stronghold_corridor',
  'minecraft:chests/stronghold_library',
  'minecraft:chests/underwater_ruin_big',
  'minecraft:chests/underwater_ruin_small',
  'minecraft:chests/village/village_armorer',
  'minecraft:chests/village/village_butcher',
  'minecraft:chests/village/village_cartographer',
  'minecraft:chests/village/village_fisher',
  'minecraft:chests/village/village_fletcher',
  'minecraft:chests/village/village_mason',
  'minecraft:chests/village/village_shepherd',
  'minecraft:chests/village/village_tannery',
  'minecraft:chests/village/village_temple',
  'minecraft:chests/village/village_toolsmith',
  'minecraft:chests/village/village_weaponsmith',
  'minecraft:chests/woodland_mansion',
  'pneumaticcraft:chests/mechanic_house',
  'ribbits:chests/gardener',
  'ribbits:chests/merchant',
  'ribbits:chests/sorcerer',
  'seavil:chests/butcher',
  'seavil:chests/temple',
  'valhelsia_structures:chests/spawner_dungeon',
  'valhelsia_structures:chests/witch_hut',
];

const COIN_LOOT_TREASURE = [
  'aether_villages:chests/olympic_citadel/olympic_citadel_treasure',
  'aether:chests/dungeon/bronze/bronze_dungeon_treasure',
  'aether:chests/dungeon/gold/gold_dungeon_treasure',
  'aether:chests/dungeon/silver/silver_dungeon_trash',
  'aquamirae:chests/frozen_chest',
  'betterdeserttemples:chests/pharaoh_hidden',
  'betterjungletemples:chests/treasure',
  'bth_structures:chests/dw20/hidden',
  'bth_structures:chests/tinkerer_house_safe',
  'idas:chests/archmages_tower/archmages_tower_treasure',
  'idas:chests/desert_pyramid/desert_pyramid_treasure',
  'idas:chests/dig_site/dig_site_treasure',
  'idas:chests/labyrinth/labyrinth_treasure',
  'idas:chests/ruins_of_the_deep/ruins_treasure',
  'idas:chests/tinkers_citadel/tinkers_citadel_vault',
  'idas:chests/tinkers_workshop/tinkers_workshop_vault',
  'incendium:castle/treasure/quartz',
  'incendium:pipeline/base/treasure',
  'incendium:pipeline/treasure',
  'incendium:sanctum/tax_collector',
  'integrated_stronghold:chests/secret_lab',
  'integrated_stronghold:chests/treasure',
  'irons_spellbooks:chests/generic_magic_treasure',
  'irons_spellbooks:chests/impaled_icebreaker/captain_quarters',
  'irons_spellbooks:chests/mangrove_hut/hidden_potion_storage',
  'irons_spellbooks:chests/mountain_tower/ice_barrel',
  'irons_spellbooks:chests/pyromancer_tower/burnt_chest',
  'minecraft:chests/bastion_treasure',
  'minecraft:chests/pillager_outpost',
  'minecraft:chests/ruined_portal',
  'minecraft:chests/shipwreck_treasure',
  'revampedvilages:chests/mansion_treasure',
  'tlc:chests/treasure',
];
