<h1 align="center">
  <img alt="Icon" src="pack.png" width="128" height="128" style="image-rendering: pixelated"><br/>
  Tschipcraft's Spawn Animations
</h1>
<p align="center">
  <a href="https://github.com/Tschipcraft/spawnanimations/stargazers"><img alt="GitHub Stars" src="https://img.shields.io/github/stars/Tschipcraft/spawnanimations?colorA=151513&colorB=e3e1ce&style=for-the-badge"></a>
  <a href="https://www.curseforge.com/minecraft/mc-mods/spawn-animations-mod"><img alt="CurseForge Downloads" src="https://img.shields.io/curseforge/dt/1223719?label=CurseForge&colorA=151513&colorB=e3e1ce&style=for-the-badge&logo=curseforge"></a>
  <a href="https://modrinth.com/datapack/spawn-animations"><img alt="Modrinth Downloads" src="https://img.shields.io/modrinth/dt/spawn-animations?label=Modrinth&colorA=151513&colorB=e3e1ce&style=for-the-badge&logo=modrinth"></a>
  <a href="https://github.com/Tschipcraft/spawnanimations/releases/latest"><img alt="GitHub Downloads" src="https://img.shields.io/github/downloads/Tschipcraft/spawnanimations/total?logo=github&colorA=151513&colorB=e3e1ce&style=for-the-badge"></a>
</p>

> A data pack/mod for Minecraft 1.14x-1.21x

## Features

Hostile mobs dig out of the ground or poof into existence when they spawn.

**Works with:**
Zombies, Husks, Drowned, Skeletons, Strays, Bogged, Spiders, Cave Spiders, Creepers, Slimes, Magma Cubes, Wither Skeletons, Hoglins, Zombified Piglins, Striders, Enderman and Giants.

This data pack/mod is designed to be as unintrusive as possible. Hidden entities including their worn armor and tools will only be invisible and silent.

This project is completely server-side, but can also be installed on the client for single-player worlds!

[➜ For available settings and customization, take a look at the wiki](https://github.com/Tschipcraft/spawnanimations/wiki)

More sophisticated animations with Animated Java are planned for v2.0.

## Demo GIFs

<details>
<summary>Click to expand</summary>
<img alt="Stray digging up" src="https://i.imgur.com/X8A0UY9.gif" width=55%>
<img alt="Enderman digging up" src="https://i.imgur.com/0rLJakI.gif" width=55%>
</details>

## Installation

[Download the latest release](https://github.com/Tschipcraft/spawnanimations/releases/latest) and install either as:

* **Data Pack** ➜ Place `.zip` in your world's `datapacks` folder
* **Mod** ➜ Drop into your `mods` folder and optionally install [MidnightLib](https://modrinth.com/project/codAaoxh) for a global config file and UI

For Minecraft 1.14, 1.15 and 1.16 use [a legacy edition](https://github.com/Tschipcraft/spawnanimations/tree/master/other_editions).

To manage settings, reset, or uninstall the pack, use `/trigger tschipcraft.menu` or `/function #tschipcraft:menu`.

Also available on Modrinth and CurseForge!

<a href="https://modrinth.com/datapack/spawn-animations">
<picture>
  <source height="72px" media="(prefers-color-scheme: dark)" srcset="https://raw.githubusercontent.com/Tschipcraft/badges/main/assets/modrinth-badge-dark.svg">
  <source height="72px" media="(prefers-color-scheme: light)" srcset="https://raw.githubusercontent.com/Tschipcraft/badges/main/assets/modrinth-badge-light.svg">
  <img height="72px" alt="Download on Modrinth" src="https://raw.githubusercontent.com/Tschipcraft/badges/main/assets/modrinth-badge-dark.svg">
</picture>
</a>
<a href="https://www.curseforge.com/minecraft/data-packs/spawn-animations">
<picture>
  <source height="72px" media="(prefers-color-scheme: dark)" srcset="https://raw.githubusercontent.com/Tschipcraft/badges/main/assets/curseforge-badge-dark.svg">
  <source height="72px" media="(prefers-color-scheme: light)" srcset="https://raw.githubusercontent.com/Tschipcraft/badges/main/assets/curseforge-badge-light.svg">
  <img height="72px" alt="Download on CurseForge" src="https://raw.githubusercontent.com/Tschipcraft/badges/main/assets/curseforge-badge-dark.svg">
</picture>
</a>

## Development Builds

Development builds are available on [GitHub Actions](https://github.com/Tschipcraft/spawnanimations/actions/workflows/ci.yml). These builds are not guaranteed to be stable and may contain bugs. Please always back up your world before using them.

## Compatibility

This data pack implements the [Smithed](https://wiki.smithed.dev/conventions/) and essential [MC Datapacks Discord Server](https://mc-datapacks.github.io/en/conventions/index.html) Conventions to ensure data pack compatibility.
