/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.net;

import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import me.paulf.fairylights.server.connection.Connection;
import me.paulf.fairylights.server.fastener.Fastener;
import me.paulf.fairylights.server.fastener.FastenerType;
import me.paulf.fairylights.server.fastener.accessor.FastenerAccessor;
import me.paulf.fairylights.server.net.Message;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;

public abstract class ConnectionMessage
implements Message {
    public BlockPos pos;
    public FastenerAccessor accessor;
    public UUID uuid;

    public ConnectionMessage() {
    }

    public ConnectionMessage(Connection connection) {
        Fastener<?> fastener = connection.getFastener();
        this.pos = fastener.getPos();
        this.accessor = fastener.createAccessor();
        this.uuid = connection.getUUID();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130079_(FastenerType.serialize(this.accessor));
        buf.m_130077_(this.uuid);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.accessor = FastenerType.deserialize(Objects.requireNonNull(buf.m_130260_(), "tag"));
        this.uuid = buf.m_130259_();
    }

    public static <C extends Connection> Optional<C> getConnection(ConnectionMessage message, Predicate<? super Connection> typePredicate, Level world) {
        return message.accessor.get(world, false).map(Optional::of).orElse(Optional.empty()).flatMap(f -> f.get(message.uuid).filter(typePredicate));
    }
}

