/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.item;

import java.util.Arrays;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;

public final class DyeableItem {
    private DyeableItem() {
    }

    public static Component getColorName(int color) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        DyeColor closest = DyeColor.WHITE;
        int closestDist = Integer.MAX_VALUE;
        for (DyeColor dye : DyeColor.values()) {
            int dyeColor = DyeableItem.getColor(dye);
            if (dyeColor == color) {
                closest = dye;
                closestDist = 0;
                break;
            }
            int dr = dyeColor >> 16 & 0xFF;
            int dg = dyeColor >> 8 & 0xFF;
            int db = dyeColor & 0xFF;
            int dist = (dr - r) * (dr - r) + (dg - g) * (dg - g) + (db - b) * (db - b);
            if (dist >= closestDist) continue;
            closest = dye;
            closestDist = dist;
        }
        MutableComponent colorName = Component.m_237115_((String)("color.fairylights." + closest.m_41065_()));
        return closestDist == 0 ? colorName : Component.m_237110_((String)"format.fairylights.dyed_colored", (Object[])new Object[]{colorName});
    }

    public static Component getDisplayName(ItemStack stack, Component name) {
        return Component.m_237110_((String)"format.fairylights.colored", (Object[])new Object[]{DyeableItem.getColorName(DyeableItem.getColor(stack)), name});
    }

    public static int getColor(DyeColor color) {
        if (color == DyeColor.BLACK) {
            return 0x323232;
        }
        if (color == DyeColor.GRAY) {
            return 0x606060;
        }
        float[] colors = color.m_41068_();
        return Mth.m_14143_((float)(colors[0] * 255.0f)) << 16 | Mth.m_14143_((float)(colors[1] * 255.0f)) << 8 | Mth.m_14143_((float)(colors[2] * 255.0f));
    }

    public static Optional<DyeColor> getDyeColor(ItemStack stack) {
        int color = DyeableItem.getColor(stack);
        return Arrays.stream(DyeColor.values()).filter(dye -> DyeableItem.getColor(dye) == color).findFirst();
    }

    public static ItemStack setColor(ItemStack stack, DyeColor dye) {
        return DyeableItem.setColor(stack, DyeableItem.getColor(dye));
    }

    public static ItemStack setColor(ItemStack stack, int color) {
        DyeableItem.setColor(stack.m_41784_(), color);
        return stack;
    }

    public static CompoundTag setColor(CompoundTag tag, DyeColor dye) {
        return DyeableItem.setColor(tag, DyeableItem.getColor(dye));
    }

    public static CompoundTag setColor(CompoundTag tag, int color) {
        tag.m_128405_("color", color);
        return tag;
    }

    public static int getColor(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null ? DyeableItem.getColor(tag) : 0xFFFFFF;
    }

    public static int getColor(CompoundTag tag) {
        return tag.m_128425_("color", 3) ? tag.m_128451_("color") : 0xFFFFFF;
    }
}

