/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.connection;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.paulf.fairylights.client.gui.EditLetteredConnectionScreen;
import me.paulf.fairylights.server.collision.Intersection;
import me.paulf.fairylights.server.connection.ConnectionType;
import me.paulf.fairylights.server.connection.HangingFeatureConnection;
import me.paulf.fairylights.server.connection.Lettered;
import me.paulf.fairylights.server.connection.PlayerAction;
import me.paulf.fairylights.server.fastener.Fastener;
import me.paulf.fairylights.server.feature.FeatureType;
import me.paulf.fairylights.server.feature.Pennant;
import me.paulf.fairylights.server.item.DyeableItem;
import me.paulf.fairylights.server.sound.FLSounds;
import me.paulf.fairylights.util.OreDictUtils;
import me.paulf.fairylights.util.styledstring.StyledString;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;

public final class PennantBuntingConnection
extends HangingFeatureConnection<Pennant>
implements Lettered {
    private List<ItemStack> pattern = new ArrayList<ItemStack>();
    private StyledString text = new StyledString();

    public PennantBuntingConnection(ConnectionType<? extends PennantBuntingConnection> type, Level world, Fastener<?> fastener, UUID uuid) {
        super(type, world, fastener, uuid);
    }

    @Override
    public float getRadius() {
        return 0.045f;
    }

    @Override
    public void processClientAction(Player player, PlayerAction action, Intersection intersection) {
        if (this.openTextGui(player, action, intersection)) {
            super.processClientAction(player, action, intersection);
        }
    }

    @Override
    public boolean interact(Player player, Vec3 hit, FeatureType featureType, int feature, ItemStack heldStack, InteractionHand hand) {
        int index;
        ItemStack pennant;
        if (featureType == FEATURE && OreDictUtils.isDye(heldStack) && !ItemStack.m_41728_((ItemStack)(pennant = this.pattern.get(index = feature % this.pattern.size())), (ItemStack)heldStack)) {
            ItemStack placed = heldStack.m_41620_(1);
            this.pattern.set(index, placed);
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)pennant);
            this.computeCatenary();
            heldStack.m_41774_(1);
            this.world.m_6263_(null, hit.f_82479_, hit.f_82480_, hit.f_82481_, (SoundEvent)FLSounds.FEATURE_COLOR_CHANGE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return super.interact(player, hit, featureType, feature, heldStack, hand);
    }

    @Override
    protected void onUpdate() {
        super.onUpdate();
        for (Pennant light : (Pennant[])this.features) {
            light.tick(this.world);
        }
    }

    protected Pennant[] createFeatures(int length) {
        return new Pennant[length];
    }

    @Override
    protected Pennant createFeature(int index, Vec3 point, float yaw, float pitch) {
        ItemStack data = this.pattern.isEmpty() ? ItemStack.f_41583_ : this.pattern.get(index % this.pattern.size());
        return new Pennant(index, point, yaw, pitch, DyeableItem.getColor(data), data.m_41720_());
    }

    @Override
    protected float getFeatureSpacing() {
        return 0.6875f;
    }

    @Override
    public boolean isSupportedText(StyledString text) {
        return text.length() <= ((Pennant[])this.features).length && Lettered.super.isSupportedText(text);
    }

    @Override
    public void setText(StyledString text) {
        this.text = text;
        this.computeCatenary();
    }

    @Override
    public StyledString getText() {
        return this.text;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Screen createTextGUI() {
        return new EditLetteredConnectionScreen<PennantBuntingConnection>(this);
    }

    @Override
    public CompoundTag serializeLogic() {
        CompoundTag compound = super.serializeLogic();
        ListTag patternList = new ListTag();
        for (ItemStack entry : this.pattern) {
            patternList.add((Object)entry.m_41739_(new CompoundTag()));
        }
        compound.m_128365_("pattern", (Tag)patternList);
        compound.m_128365_("text", (Tag)StyledString.serialize(this.text));
        return compound;
    }

    @Override
    public void deserializeLogic(CompoundTag compound) {
        super.deserializeLogic(compound);
        this.pattern = new ArrayList<ItemStack>();
        ListTag patternList = compound.m_128437_("pattern", 10);
        for (int i = 0; i < patternList.size(); ++i) {
            this.pattern.add(ItemStack.m_41712_((CompoundTag)patternList.m_128728_(i)));
        }
        this.text = StyledString.deserialize(compound.m_128469_("text"));
    }
}

