/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.renderer.block.entity;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.function.Function;
import me.paulf.fairylights.client.FLModelLayers;
import me.paulf.fairylights.client.renderer.block.entity.ConnectionRenderer;
import me.paulf.fairylights.client.renderer.block.entity.FastenerRenderer;
import me.paulf.fairylights.server.connection.PennantBuntingConnection;
import me.paulf.fairylights.server.feature.Pennant;
import me.paulf.fairylights.server.item.FLItems;
import me.paulf.fairylights.util.Curve;
import me.paulf.fairylights.util.styledstring.Style;
import me.paulf.fairylights.util.styledstring.StyledString;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class PennantBuntingRenderer
extends ConnectionRenderer<PennantBuntingConnection> {
    private static final ResourceLocation TRIANGLE_MODEL = new ResourceLocation("fairylights", "entity/triangle_pennant");
    private static final ResourceLocation SPEARHEAD_MODEL = new ResourceLocation("fairylights", "entity/spearhead_pennant");
    private static final ResourceLocation SWALLOWTAIL_MODEl = new ResourceLocation("fairylights", "entity/swallowtail_pennant");
    private static final ResourceLocation SQUARE_MODEL = new ResourceLocation("fairylights", "entity/square_pennant");
    public static final ImmutableSet<ResourceLocation> MODELS = ImmutableSet.of((Object)TRIANGLE_MODEL, (Object)SPEARHEAD_MODEL, (Object)SWALLOWTAIL_MODEl, (Object)SQUARE_MODEL);
    private final ImmutableMap<Item, ResourceLocation> models = ImmutableMap.of((Object)((Item)FLItems.TRIANGLE_PENNANT.get()), (Object)TRIANGLE_MODEL, (Object)((Item)FLItems.SPEARHEAD_PENNANT.get()), (Object)SPEARHEAD_MODEL, (Object)((Item)FLItems.SWALLOWTAIL_PENNANT.get()), (Object)SWALLOWTAIL_MODEl, (Object)((Item)FLItems.SQUARE_PENNANT.get()), (Object)SQUARE_MODEL);

    public PennantBuntingRenderer(Function<ModelLayerLocation, ModelPart> baker) {
        super(baker, FLModelLayers.PENNANT_WIRE, 0.25f);
    }

    @Override
    protected void render(PennantBuntingConnection conn, Curve catenary, float delta, PoseStack matrix, MultiBufferSource source, int packedLight, int packedOverlay) {
        super.render(conn, catenary, delta, matrix, source, packedLight, packedOverlay);
        Pennant[] currLights = (Pennant[])conn.getFeatures();
        if (currLights != null) {
            Font font = Minecraft.m_91087_().f_91062_;
            VertexConsumer buf = source.m_6299_(Sheets.m_110790_());
            int count = currLights.length;
            if (count == 0) {
                return;
            }
            StyledString text = conn.getText();
            if (text.length() > count) {
                text = text.substring(0, count);
            }
            int offset = (count - text.length()) / 2;
            for (int i = 0; i < count; ++i) {
                Pennant currPennant = currLights[i];
                int color = currPennant.getColor();
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                BakedModel model = Minecraft.m_91087_().m_91304_().getModel((ResourceLocation)this.models.getOrDefault((Object)currPennant.getItem(), (Object)TRIANGLE_MODEL));
                Vec3 pos = currPennant.getPoint(delta);
                matrix.m_85836_();
                matrix.m_85837_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
                matrix.m_252781_(Axis.f_252436_.m_252961_(-currPennant.getYaw(delta)));
                matrix.m_252781_(Axis.f_252403_.m_252961_(currPennant.getPitch(delta)));
                matrix.m_252781_(Axis.f_252529_.m_252961_(currPennant.getRoll(delta)));
                matrix.m_85836_();
                FastenerRenderer.renderBakedModel(model, matrix, buf, r, g, b, packedLight, packedOverlay);
                matrix.m_85849_();
                if (i >= offset && i < offset + text.length()) {
                    this.drawLetter(matrix, source, currPennant, packedLight, font, text, i - offset, 1, delta);
                    this.drawLetter(matrix, source, currPennant, packedLight, font, text, text.length() - 1 - (i - offset), -1, delta);
                }
                matrix.m_85849_();
            }
        }
    }

    private void drawLetter(PoseStack matrix, MultiBufferSource source, Pennant pennant, int packedLight, Font font, StyledString text, int index, int side, float delta) {
        Style style = text.styleAt(index);
        StringBuilder bob = new StringBuilder();
        if (style.isObfuscated()) {
            bob.append(ChatFormatting.OBFUSCATED);
        }
        if (style.isBold()) {
            bob.append(ChatFormatting.BOLD);
        }
        if (style.isStrikethrough()) {
            bob.append(ChatFormatting.STRIKETHROUGH);
        }
        if (style.isUnderline()) {
            bob.append(ChatFormatting.UNDERLINE);
        }
        if (style.isItalic()) {
            bob.append(ChatFormatting.ITALIC);
        }
        bob.append(text.charAt(index));
        String chr = bob.toString();
        Matrix3f m = new Matrix3f();
        m.rotate((Quaternionfc)Axis.f_252436_.m_252961_(pennant.getYaw(delta)));
        m.rotate((Quaternionfc)Axis.f_252403_.m_252961_(pennant.getPitch(delta)));
        m.rotate((Quaternionfc)Axis.f_252529_.m_252961_(pennant.getRoll(delta)));
        Vector3f v = new Vector3f(0.0f, 0.0f, (float)side);
        m.transform(v);
        float brightness = PennantBuntingRenderer.diffuseLight(v.x(), v.y(), v.z());
        int styleColor = (Integer)MoreObjects.firstNonNull((Object)style.getColor().m_126665_(), (Object)0xFFFFFF);
        int r = (int)((float)(styleColor >> 16 & 0xFF) * brightness);
        int g = (int)((float)(styleColor >> 8 & 0xFF) * brightness);
        int b = (int)((float)(styleColor & 0xFF) * brightness);
        int argb = 0xFF000000 | r << 16 | g << 8 | b;
        matrix.m_85836_();
        matrix.m_252880_(0.0f, -0.25f, 0.04f * (float)side);
        float s = 0.03075f;
        matrix.m_85841_(0.03075f * (float)side, -0.03075f, 0.03075f);
        float w = font.m_92895_(chr);
        font.m_271703_(chr, -(w - 1.0f) / 2.0f, -4.0f, argb, false, matrix.m_85850_().m_252922_(), source, Font.DisplayMode.NORMAL, 0, packedLight);
        matrix.m_85849_();
    }

    public static float diffuseLight(float p_144949_, float p_144950_, float p_144951_) {
        return Math.min(p_144949_ * p_144949_ * 0.6f + p_144950_ * p_144950_ * ((3.0f + p_144950_) / 4.0f) + p_144951_ * p_144951_ * 0.8f, 1.0f);
    }

    public static LayerDefinition wireLayer() {
        return ConnectionRenderer.WireModel.createLayer(0, 17, 1);
    }
}

