/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.quack.net;

import java.io.File;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.file.Path;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.covers1624.quack.annotation.Requires;
import net.covers1624.quack.net.DownloadAction;
import net.covers1624.quack.net.HttpResponseException;
import net.covers1624.quack.net.download.DownloadListener;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(value="org.slf4j:slf4j-api")
public abstract class AbstractDownloadAction
implements DownloadAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDownloadAction.class);
    @Nullable
    protected String url;
    @Nullable
    protected DownloadAction.Dest dest;
    protected boolean onlyIfModified;
    protected boolean useETag;
    protected boolean quiet = true;
    @Nullable
    protected String userAgent;
    @Nullable
    protected DownloadListener downloadListener;
    protected final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    protected boolean upToDate;

    protected boolean expectNotModified() {
        return this.useETag || this.onlyIfModified;
    }

    protected void validateCode(int code, String reasonPhrase) throws HttpResponseException {
        if (!(code >= 200 && code <= 299 || this.expectNotModified() && code == 304)) {
            throw new HttpResponseException(code, reasonPhrase);
        }
    }

    protected boolean calcUpToDate(int code, long lastModifiedDisk, @Nullable Date lastModifiedHeader) {
        boolean notModified;
        boolean timestampNotModified = this.onlyIfModified && lastModifiedHeader != null && lastModifiedDisk >= lastModifiedHeader.getTime();
        boolean bl = notModified = this.expectNotModified() && code == 304;
        if (notModified || timestampNotModified) {
            if (!this.quiet) {
                String reason = "";
                if (code == 304) {
                    reason = reason + "304 not modified ";
                }
                if (timestampNotModified) {
                    reason = reason + "Last-Modified header";
                }
                LOGGER.info("Not Modified ({}). Skipping '{}'.", (Object)reason.trim(), (Object)this.url);
            }
            return true;
        }
        return false;
    }

    @Override
    public AbstractDownloadAction setUrl(String url) {
        this.url = url;
        return this;
    }

    @Override
    public AbstractDownloadAction setDest(DownloadAction.Dest dest) {
        this.dest = dest;
        return this;
    }

    @Override
    public AbstractDownloadAction setDest(StringWriter sw) {
        return this.setDest(DownloadAction.Dest.string(sw));
    }

    @Override
    public AbstractDownloadAction setDest(OutputStream os) {
        return this.setDest(DownloadAction.Dest.stream(os));
    }

    @Override
    public AbstractDownloadAction setDest(File file) {
        return this.setDest(DownloadAction.Dest.file(file));
    }

    @Override
    public AbstractDownloadAction setDest(Path path) {
        return this.setDest(DownloadAction.Dest.path(path));
    }

    @Override
    public AbstractDownloadAction setOnlyIfModified(boolean onlyIfModified) {
        this.onlyIfModified = onlyIfModified;
        return this;
    }

    @Override
    public AbstractDownloadAction setUseETag(boolean useETag) {
        this.useETag = useETag;
        return this;
    }

    @Override
    public AbstractDownloadAction setQuiet(boolean quiet) {
        this.quiet = quiet;
        return this;
    }

    @Override
    public AbstractDownloadAction setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    @Override
    public DownloadAction addRequestHeader(String key, String value) {
        this.headers.computeIfAbsent(key, k -> new LinkedList()).add(value);
        return this;
    }

    @Override
    public AbstractDownloadAction setDownloadListener(DownloadListener downloadListener) {
        this.downloadListener = downloadListener;
        return this;
    }

    @Override
    public boolean isUpToDate() {
        return this.upToDate;
    }

    @Override
    @Nullable
    public String getUrl() {
        return this.url;
    }

    @Override
    @Nullable
    public DownloadAction.Dest getDest() {
        return this.dest;
    }

    @Override
    public boolean getOnlyIfModified() {
        return this.onlyIfModified;
    }

    @Override
    public boolean getUseETag() {
        return this.useETag;
    }

    @Override
    public boolean getQuiet() {
        return this.quiet;
    }

    @Override
    @Nullable
    public String getUserAgent() {
        return this.userAgent;
    }

    @Override
    @Nullable
    public DownloadListener getDownloadListener() {
        return this.downloadListener;
    }
}

