/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.model;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.model.MatLib;
import codechicken.lib.render.model.ModelMaterial;
import codechicken.lib.util.ResourceUtils;
import codechicken.lib.vec.SwapYZ;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.jetbrains.annotations.Nullable;

public class OBJParser {
    private final ResourceLocation location;
    @Nullable
    private ResourceProvider provider;
    private VertexFormat.Mode vertexMode = VertexFormat.Mode.TRIANGLES;
    @Nullable
    private Transformation coordSystem;
    private boolean ignoreMtl;

    public OBJParser(ResourceLocation location) {
        this.location = location;
    }

    public OBJParser provider(ResourceProvider provider) {
        this.provider = provider;
        return this;
    }

    public OBJParser vertexMode(VertexFormat.Mode mode) {
        if (mode != VertexFormat.Mode.TRIANGLES && mode != VertexFormat.Mode.QUADS) {
            throw new IllegalStateException("Only Quads and Triangles are supported.");
        }
        this.vertexMode = mode;
        return this;
    }

    public OBJParser quads() {
        return this.vertexMode(VertexFormat.Mode.QUADS);
    }

    public OBJParser coordSystem(@Nullable Transformation coordSystem) {
        this.coordSystem = coordSystem;
        return this;
    }

    public OBJParser swapYZ() {
        return this.coordSystem(new SwapYZ());
    }

    public OBJParser ignoreMtl() {
        this.ignoreMtl = true;
        return this;
    }

    public Map<String, CCModel> parse() {
        if (this.provider == null) {
            this.provider = Minecraft.m_91087_().m_91098_();
        }
        return OBJParser.parse(this.provider, this.location, this.vertexMode, this.coordSystem, this.ignoreMtl);
    }

    public static Map<String, CCModel> parse(ResourceProvider provider, ResourceLocation loc, VertexFormat.Mode vertexMode, @Nullable Transformation coordSystem, boolean ignoreMtl) {
        if (vertexMode != VertexFormat.Mode.QUADS && vertexMode != VertexFormat.Mode.TRIANGLES) {
            throw new IllegalStateException("Only Quads and Triangles are supported.");
        }
        HashMap<String, CCModel> builtModels = new HashMap<String, CCModel>();
        ArrayList<Vector3> vs = new ArrayList<Vector3>();
        ArrayList<Vector3> vts = new ArrayList<Vector3>();
        ArrayList<Vector3> vns = new ArrayList<Vector3>();
        MatLib matlib = null;
        ModelMaterial material = null;
        ArrayList<int[]> polys = null;
        String group = null;
        Object name = null;
        String finishedName = null;
        boolean modelFinished = false;
        List<String> loadResource = ResourceUtils.loadResource(provider, loc);
        for (int ln = 0; ln < loadResource.size(); ++ln) {
            String line = loadResource.get(ln);
            if ((line = line.replaceAll("\\s+", " ").trim()).isEmpty() || line.startsWith("#")) continue;
            String[] splits = line.split(" ", 2);
            switch (splits[0]) {
                case "mtllib": {
                    if (ignoreMtl) break;
                    matlib = MatLib.parse(provider, OBJParser.maybeRelative(loc, splits[1]));
                    break;
                }
                case "usemtl": {
                    ModelMaterial newMaterial;
                    if (ignoreMtl || material == (newMaterial = ((MatLib)Objects.requireNonNull(matlib, "matlib definition not found")).getMaterial(splits[1])) || (material = newMaterial) == null && polys == null) break;
                    modelFinished = true;
                    break;
                }
                case "v": {
                    vs.add(OBJParser.apply(coordSystem, OBJParser.parseVec3(splits[1], ln)));
                    break;
                }
                case "vt": {
                    vts.add(OBJParser.parseUV(splits[1], ln));
                    break;
                }
                case "vn": {
                    vns.add(OBJParser.applyN(coordSystem, OBJParser.parseVec3(splits[1], ln)));
                    break;
                }
                case "f": {
                    if (polys == null) {
                        polys = new ArrayList<int[]>();
                        finishedName = name;
                    }
                    polys.addAll(OBJParser.parsePolys(splits[1], vertexMode));
                    break;
                }
                case "g": {
                    group = splits[1];
                    name = group;
                    modelFinished = true;
                    break;
                }
                case "o": {
                    name = (String)(group != null ? group + "/" : "") + splits[1];
                    modelFinished = true;
                }
            }
            if (!modelFinished) continue;
            modelFinished = false;
            if (polys == null) continue;
            CCModel builtModel = CCModel.createModel(vs, vts, vns, vertexMode, polys);
            builtModel.setAttribute(ModelMaterial.MATERIAL_KEY, material);
            polys = null;
            OBJParser.putBuiltModel(builtModels, finishedName, builtModel);
        }
        if (polys != null) {
            CCModel builtModel = CCModel.createModel(vs, vts, vns, vertexMode, polys);
            builtModel.setAttribute(ModelMaterial.MATERIAL_KEY, material);
            OBJParser.putBuiltModel(builtModels, finishedName, builtModel);
        }
        return builtModels;
    }

    private static void putBuiltModel(Map<String, CCModel> builtModels, String name, CCModel model) {
        int i = 0;
        String originalName = name;
        while (builtModels.containsKey(name)) {
            name = originalName + i;
            ++i;
        }
        builtModels.put((String)name, model);
    }

    private static Vector3 parseUV(String s, int line) {
        double[] doubles = OBJParser.parseDoubles(s, " ");
        if (doubles.length < 2) {
            throw new IllegalStateException("Expected u and v component. Line " + line + " " + s);
        }
        return new Vector3(doubles[0], 1.0 - doubles[1], 0.0);
    }

    private static Vector3 parseVec3(String s, int line) {
        double[] doubles = OBJParser.parseDoubles(s, " ");
        if (doubles.length < 3) {
            throw new IllegalStateException("Expected x, y and z component. Line " + line + " " + s);
        }
        return new Vector3(doubles);
    }

    private static List<int[]> parsePolys(String s, VertexFormat.Mode vm) {
        String[] av = s.split(" ");
        int[][] polyVerts = new int[av.length][3];
        for (int i = 0; i < av.length; ++i) {
            String[] as = av[i].split("/");
            for (int p = 0; p < as.length; ++p) {
                if (as[p].isEmpty()) continue;
                polyVerts[i][p] = Integer.parseInt(as[p]);
            }
        }
        ArrayList<int[]> polys = new ArrayList<int[]>();
        if (vm == VertexFormat.Mode.TRIANGLES) {
            OBJParser.triangulate(polys, polyVerts);
        } else {
            OBJParser.quadulate(polys, polyVerts);
        }
        return polys;
    }

    private static void triangulate(List<int[]> polys, int[][] polyVerts) {
        for (int i = 2; i < polyVerts.length; ++i) {
            polys.add(polyVerts[0]);
            polys.add(polyVerts[i]);
            polys.add(polyVerts[i - 1]);
        }
    }

    private static void quadulate(List<int[]> polys, int[][] polyVerts) {
        if (polyVerts.length == 4) {
            polys.add(polyVerts[0]);
            polys.add(polyVerts[3]);
            polys.add(polyVerts[2]);
            polys.add(polyVerts[1]);
        } else {
            for (int i = 2; i < polyVerts.length; ++i) {
                polys.add(polyVerts[0]);
                polys.add(polyVerts[i]);
                polys.add(polyVerts[i - 1]);
                polys.add(polyVerts[i - 1]);
            }
        }
    }

    private static Vector3 apply(@Nullable Transformation transformation, Vector3 vec3) {
        if (transformation != null) {
            transformation.apply(vec3);
        }
        return vec3;
    }

    private static Vector3 applyN(@Nullable Transformation transformation, Vector3 vec3) {
        if (transformation != null) {
            transformation.applyN(vec3);
        }
        return vec3;
    }

    private static double[] parseDoubles(String s, String token) {
        String[] as = s.split(token);
        double[] values = new double[as.length];
        for (int i = 0; i < as.length; ++i) {
            values[i] = Double.parseDouble(as[i]);
        }
        return values;
    }

    private static ResourceLocation maybeRelative(ResourceLocation other, String resource) {
        if (resource.contains(":")) {
            return new ResourceLocation(resource);
        }
        String path = other.m_135815_();
        int lastSlash = path.lastIndexOf("/");
        path = lastSlash != -1 ? path.substring(0, lastSlash) : "";
        return new ResourceLocation(other.m_135827_(), path + "/" + resource);
    }
}

