/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.inventory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class MappedInventoryAccess
implements Container {
    public static final InventoryAccessor fullAccess = slot -> true;
    private final ArrayList<Integer> slotMap = new ArrayList();
    private final Container inv;
    private final ArrayList<InventoryAccessor> accessors = new ArrayList();

    public MappedInventoryAccess(Container inv, InventoryAccessor ... accessors) {
        this.inv = inv;
        Collections.addAll(this.accessors, accessors);
        this.reset();
    }

    public void reset() {
        this.slotMap.clear();
        block0: for (int i = 0; i < this.inv.m_6643_(); ++i) {
            for (InventoryAccessor a : this.accessors) {
                if (a.canAccessSlot(i)) continue;
                continue block0;
            }
            this.slotMap.add(i);
        }
    }

    public int m_6643_() {
        return this.slotMap.size();
    }

    public boolean m_7983_() {
        return this.inv.m_7983_();
    }

    @Nonnull
    public ItemStack m_8020_(int slot) {
        return this.inv.m_8020_(this.slotMap.get(slot).intValue());
    }

    @Nonnull
    public ItemStack m_7407_(int slot, int amount) {
        return this.inv.m_7407_(this.slotMap.get(slot).intValue(), amount);
    }

    @Nonnull
    public ItemStack m_8016_(int slot) {
        return this.inv.m_8016_(this.slotMap.get(slot).intValue());
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.inv.m_6836_(this.slotMap.get(slot).intValue(), stack);
    }

    public int m_6893_() {
        return this.inv.m_6893_();
    }

    public void m_6596_() {
        this.inv.m_6596_();
    }

    public boolean m_6542_(Player player) {
        return this.inv.m_6542_(player);
    }

    public void addAccessor(InventoryAccessor accessor) {
        this.accessors.add(accessor);
        this.reset();
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        return this.inv.m_7013_(this.slotMap.get(slot).intValue(), stack);
    }

    public void m_5856_(Player player) {
        this.inv.m_5856_(player);
    }

    public void m_5785_(Player player) {
        this.inv.m_5785_(player);
    }

    public void m_6211_() {
        this.inv.m_6211_();
    }

    public List<InventoryAccessor> accessors() {
        return this.accessors;
    }

    public static interface InventoryAccessor {
        public boolean canAccessSlot(int var1);
    }
}

