/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.inventory;

import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.util.ArrayUtils;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class InventoryNBT
implements Container {
    protected ItemStack[] items;
    protected CompoundTag tag;

    public InventoryNBT(int size, CompoundTag tag) {
        this.tag = tag;
        this.items = new ItemStack[size];
        ArrayUtils.fillArray(this.items, ItemStack.f_41583_, Objects::isNull);
        this.readNBT();
    }

    private void writeNBT() {
        this.tag.m_128365_("items", (Tag)InventoryUtils.writeItemStacksToTag(this.items, this.m_6893_()));
    }

    private void readNBT() {
        if (this.tag.m_128441_("items")) {
            InventoryUtils.readItemStacksFromTag(this.items, this.tag.m_128437_("items", 10));
        }
    }

    public int m_6643_() {
        return this.items.length;
    }

    public boolean m_7983_() {
        return ArrayUtils.count(this.items, stack -> !stack.m_41619_()) <= 0;
    }

    @Nonnull
    public ItemStack m_8020_(int slot) {
        return this.items[slot];
    }

    @Nonnull
    public ItemStack m_7407_(int slot, int amount) {
        return InventoryUtils.decrStackSize(this, slot, amount);
    }

    @Nonnull
    public ItemStack m_8016_(int slot) {
        return InventoryUtils.removeStackFromSlot(this, slot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.items[slot] = stack;
        this.m_6596_();
    }

    public int m_6893_() {
        return 64;
    }

    public void m_6596_() {
        this.writeNBT();
    }

    public void m_6211_() {
        Arrays.fill(this.items, ItemStack.f_41583_);
        this.m_6596_();
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public void m_5856_(Player player) {
    }

    public void m_5785_(Player player) {
    }

    public boolean m_7013_(int i, ItemStack itemstack) {
        return true;
    }
}

