/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import dan200.computercraft.shared.util.CapabilityUtil;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import org.jspecify.annotations.Nullable;

public final class SidedCapabilityProvider<T>
implements ICapabilityProvider {
    private final Capability<T> cap;
    private final Provider<T> supplier;
    private final BooleanSupplier isRemoved;
    private @Nullable LazyOptional<T> @Nullable [] instances;

    private SidedCapabilityProvider(Capability<T> cap, Provider<T> supplier, BooleanSupplier isRemoved) {
        this.cap = Objects.requireNonNull(cap, "Capability cannot be null");
        this.supplier = supplier;
        this.isRemoved = isRemoved;
    }

    public static <T> SidedCapabilityProvider<T> attach(AttachCapabilitiesEvent<?> event, ResourceLocation id, Capability<T> cap, Provider<T> supplier) {
        BooleanSupplier booleanSupplier;
        Object object = event.getObject();
        if (object instanceof BlockEntity) {
            BlockEntity be = (BlockEntity)object;
            booleanSupplier = () -> ((BlockEntity)be).m_58901_();
        } else {
            object = event.getObject();
            if (object instanceof Entity) {
                Entity entity = (Entity)object;
                booleanSupplier = () -> ((Entity)entity).m_213877_();
            } else {
                booleanSupplier = () -> true;
            }
        }
        BooleanSupplier isRemoved = booleanSupplier;
        SidedCapabilityProvider<T> provider = new SidedCapabilityProvider<T>(cap, supplier, isRemoved);
        event.addCapability(id, provider);
        event.addListener(provider::invalidate);
        return provider;
    }

    public void invalidate() {
        CapabilityUtil.invalidate(this.instances);
    }

    public <U> LazyOptional<U> getCapability(Capability<U> cap, @Nullable Direction side) {
        int index;
        LazyOptional instance;
        if (cap != this.cap || this.isRemoved.getAsBoolean()) {
            return LazyOptional.empty();
        }
        LazyOptional<T>[] instances = this.instances;
        if (instances == null) {
            instances = this.instances = new LazyOptional[6];
        }
        if ((instance = instances[index = side == null ? 6 : side.ordinal()]) == null) {
            Object created = this.supplier.get(side);
            instances[index] = created == null ? LazyOptional.empty() : LazyOptional.of(() -> created);
            instance = instances[index];
        }
        return instance.cast();
    }

    public static interface Provider<T> {
        public @Nullable T get(@Nullable Direction var1);
    }
}

