/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.util;

import dev.murad.shipping.util.TugRouteNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class TugRoute
extends ArrayList<TugRouteNode> {
    private static final String NAME_TAG = "name";
    private static final String NODES_TAG = "nodes";
    private static final String HASH_TAG = "hash";
    private String name;

    public TugRoute(String name, List<TugRouteNode> nodes) {
        super(nodes);
        this.name = name;
    }

    public TugRoute(List<TugRouteNode> nodes) {
        this(null, nodes);
    }

    public TugRoute() {
        this(null, new ArrayList<TugRouteNode>());
    }

    public boolean hasCustomName() {
        return this.name != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TugRoute that = (TugRoute)o;
        return Objects.equals(this.name, that.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name);
    }

    public CompoundTag toNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        for (TugRouteNode node : this) {
            list.add((Object)node.toNBT());
        }
        tag.m_128365_(NODES_TAG, (Tag)list);
        if (this.hasCustomName()) {
            tag.m_128359_(NAME_TAG, this.name);
        }
        return tag;
    }

    public static TugRoute fromNBT(CompoundTag tag) {
        String name = null;
        if (tag.m_128441_(NAME_TAG)) {
            name = tag.m_128461_(NAME_TAG);
        }
        ListTag nodesNBT = tag.m_128437_(NODES_TAG, 10);
        ArrayList<TugRouteNode> nodes = new ArrayList<TugRouteNode>();
        for (int i = 0; i < nodesNBT.size(); ++i) {
            nodes.add(TugRouteNode.fromNBT(nodesNBT.m_128728_(i)));
        }
        return new TugRoute(name, nodes);
    }
}

