/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.util;

import dev.murad.shipping.util.Train;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public interface LinkableEntity<V extends LinkableEntity<V>> {
    public Optional<V> getFollower();

    public Optional<V> getLeader();

    public void setDominated(V var1);

    public void setDominant(V var1);

    public void removeDominated();

    public void removeDominant();

    public void handleShearsCut();

    public Train<V> getTrain();

    public boolean linkEntities(Player var1, Entity var2);

    public void setTrain(Train<V> var1);

    public boolean hasWaterOnSides();

    default public void handleLinkableKill() {
        this.getFollower().ifPresent(LinkableEntity::removeDominant);
        this.getLeader().ifPresent(LinkableEntity::removeDominated);
    }

    default public boolean checkNoLoopsDominated() {
        return this.checkNoLoopsHelper(this, LinkableEntity::getFollower, new HashSet<LinkableEntity<V>>());
    }

    default public boolean checkNoLoopsDominant() {
        return this.checkNoLoopsHelper(this, LinkableEntity::getLeader, new HashSet<LinkableEntity<V>>());
    }

    default public boolean checkNoLoopsHelper(LinkableEntity<V> entity, Function<LinkableEntity<V>, Optional<V>> next, Set<LinkableEntity<V>> set) {
        if (set.contains(entity)) {
            return true;
        }
        set.add(entity);
        Optional<V> nextEntity = next.apply(entity);
        return nextEntity.map(e -> this.checkNoLoopsHelper((LinkableEntity<V>)e, next, set)).orElse(false);
    }

    default public <U> Stream<U> applyWithAll(Function<LinkableEntity<V>, U> function) {
        return this.getTrain().getHead().applyWithDominated(function);
    }

    default public <U> Stream<U> applyWithDominant(Function<LinkableEntity<V>, U> function) {
        Stream ofThis = Stream.of(function.apply(this));
        return this.checkNoLoopsDominant() ? ofThis : this.getLeader().map(dom -> Stream.concat(ofThis, dom.applyWithDominant(function))).orElse(ofThis);
    }

    default public <U> Stream<U> applyWithDominated(Function<LinkableEntity<V>, U> function) {
        Stream ofThis = Stream.of(function.apply(this));
        return this.checkNoLoopsDominated() ? ofThis : this.getFollower().map(dom -> Stream.concat(ofThis, dom.applyWithDominated(function))).orElse(ofThis);
    }

    public boolean allowDockInterface();

    public BlockPos getBlockPos();

    public static enum LinkSide {
        DOMINANT,
        DOMINATED;

    }
}

