/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.setup;

import com.google.common.collect.ImmutableList;
import dev.murad.shipping.block.dock.BargeDockBlock;
import dev.murad.shipping.block.dock.TugDockBlock;
import dev.murad.shipping.block.energy.VesselChargerBlock;
import dev.murad.shipping.block.fluid.FluidHopperBlock;
import dev.murad.shipping.block.guiderail.CornerGuideRailBlock;
import dev.murad.shipping.block.guiderail.TugGuideRailBlock;
import dev.murad.shipping.block.rail.JunctionRail;
import dev.murad.shipping.block.rail.LocomotiveDockingRail;
import dev.murad.shipping.block.rail.SwitchRail;
import dev.murad.shipping.block.rail.TeeJunctionRail;
import dev.murad.shipping.block.rail.TrainCarDockingRail;
import dev.murad.shipping.block.rapidhopper.RapidHopperBlock;
import dev.murad.shipping.block.vesseldetector.VesselDetectorBlock;
import dev.murad.shipping.setup.Registration;
import dev.murad.shipping.util.MultiMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    private static final MultiMap<ResourceKey<CreativeModeTab>, RegistryObject<? extends ItemLike>> PRIVATE_TAB_REGISTRY = new MultiMap();
    private static BlockBehaviour.Properties METAL_BLOCK_BEHAVIOUR = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(0.5f, 6.0f).m_60918_(SoundType.f_56743_);
    private static BlockBehaviour.Properties RAIL_BLOCK_BEHAVIOUR = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50156_);
    public static final RegistryObject<Block> TUG_DOCK = ModBlocks.register("tug_dock", () -> new TugDockBlock(METAL_BLOCK_BEHAVIOUR), (List<ResourceKey<CreativeModeTab>>)ImmutableList.of((Object)CreativeModeTabs.f_256869_, (Object)CreativeModeTabs.f_257028_));
    public static final RegistryObject<Block> BARGE_DOCK = ModBlocks.register("barge_dock", () -> new BargeDockBlock(METAL_BLOCK_BEHAVIOUR), (List<ResourceKey<CreativeModeTab>>)ImmutableList.of((Object)CreativeModeTabs.f_256869_, (Object)CreativeModeTabs.f_257028_));
    public static final RegistryObject<Block> GUIDE_RAIL_CORNER = ModBlocks.register("guide_rail_corner", () -> new CornerGuideRailBlock(METAL_BLOCK_BEHAVIOUR), (List<ResourceKey<CreativeModeTab>>)ImmutableList.of((Object)CreativeModeTabs.f_256869_, (Object)CreativeModeTabs.f_257028_));
    public static final RegistryObject<Block> VESSEL_DETECTOR = ModBlocks.register("vessel_detector", () -> new VesselDetectorBlock(METAL_BLOCK_BEHAVIOUR), (List<ResourceKey<CreativeModeTab>>)ImmutableList.of((Object)CreativeModeTabs.f_256869_, (Object)CreativeModeTabs.f_257028_));
    public static final RegistryObject<Block> GUIDE_RAIL_TUG = ModBlocks.register("guide_rail_tug", () -> new TugGuideRailBlock(METAL_BLOCK_BEHAVIOUR), (List<ResourceKey<CreativeModeTab>>)ImmutableList.of((Object)CreativeModeTabs.f_256869_, (Object)CreativeModeTabs.f_257028_));
    public static final RegistryObject<Block> FLUID_HOPPER = ModBlocks.register("fluid_hopper", () -> new FluidHopperBlock(METAL_BLOCK_BEHAVIOUR), (List<ResourceKey<CreativeModeTab>>)ImmutableList.of((Object)CreativeModeTabs.f_256869_, (Object)CreativeModeTabs.f_257028_));
    public static final RegistryObject<Block> VESSEL_CHARGER = ModBlocks.register("vessel_charger", () -> new VesselChargerBlock(METAL_BLOCK_BEHAVIOUR), (List<ResourceKey<CreativeModeTab>>)ImmutableList.of((Object)CreativeModeTabs.f_256869_, (Object)CreativeModeTabs.f_257028_));
    public static final RegistryObject<Block> RAPID_HOPPER = ModBlocks.register("rapid_hopper", () -> new RapidHopperBlock(METAL_BLOCK_BEHAVIOUR), (List<ResourceKey<CreativeModeTab>>)ImmutableList.of((Object)CreativeModeTabs.f_256869_, (Object)CreativeModeTabs.f_257028_));
    public static final RegistryObject<Block> SWITCH_RAIL = ModBlocks.register("switch_rail", () -> new SwitchRail(RAIL_BLOCK_BEHAVIOUR, false), (List<ResourceKey<CreativeModeTab>>)ImmutableList.of((Object)CreativeModeTabs.f_256869_, (Object)CreativeModeTabs.f_257028_));
    public static final RegistryObject<Block> AUTOMATIC_SWITCH_RAIL = ModBlocks.register("automatic_switch_rail", () -> new SwitchRail(RAIL_BLOCK_BEHAVIOUR, true), (List<ResourceKey<CreativeModeTab>>)ImmutableList.of((Object)CreativeModeTabs.f_256869_, (Object)CreativeModeTabs.f_257028_));
    public static final RegistryObject<Block> TEE_JUNCTION_RAIL = ModBlocks.register("tee_junction_rail", () -> new TeeJunctionRail(RAIL_BLOCK_BEHAVIOUR, false), (List<ResourceKey<CreativeModeTab>>)ImmutableList.of((Object)CreativeModeTabs.f_256869_, (Object)CreativeModeTabs.f_257028_));
    public static final RegistryObject<Block> AUTOMATIC_TEE_JUNCTION_RAIL = ModBlocks.register("automatic_tee_junction_rail", () -> new TeeJunctionRail(RAIL_BLOCK_BEHAVIOUR, true), (List<ResourceKey<CreativeModeTab>>)ImmutableList.of((Object)CreativeModeTabs.f_256869_, (Object)CreativeModeTabs.f_257028_));
    public static final RegistryObject<Block> JUNCTION_RAIL = ModBlocks.register("junction_rail", () -> new JunctionRail(RAIL_BLOCK_BEHAVIOUR), (List<ResourceKey<CreativeModeTab>>)ImmutableList.of((Object)CreativeModeTabs.f_256869_, (Object)CreativeModeTabs.f_257028_));
    public static final RegistryObject<Block> CAR_DOCK_RAIL = ModBlocks.register("car_dock_rail", () -> new TrainCarDockingRail(RAIL_BLOCK_BEHAVIOUR), (List<ResourceKey<CreativeModeTab>>)ImmutableList.of((Object)CreativeModeTabs.f_256869_, (Object)CreativeModeTabs.f_257028_));
    public static final RegistryObject<Block> LOCOMOTIVE_DOCK_RAIL = ModBlocks.register("locomotive_dock_rail", () -> new LocomotiveDockingRail(RAIL_BLOCK_BEHAVIOUR), (List<ResourceKey<CreativeModeTab>>)ImmutableList.of((Object)CreativeModeTabs.f_256869_, (Object)CreativeModeTabs.f_257028_));

    public static void buildCreativeTab(BuildCreativeModeTabContentsEvent event) {
        ((List)PRIVATE_TAB_REGISTRY.getOrDefault(event.getTabKey(), (RegistryObject<? extends ItemLike>)new ArrayList())).forEach(arg_0 -> ((BuildCreativeModeTabContentsEvent)event).accept(arg_0));
    }

    private static <T extends Block> RegistryObject<T> registerNoItem(String name, Supplier<T> block) {
        return Registration.BLOCKS.register(name, block);
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<T> block, List<ResourceKey<CreativeModeTab>> tabs) {
        RegistryObject ret = ModBlocks.registerNoItem(name, block);
        RegistryObject item = Registration.ITEMS.register(name, () -> new BlockItem((Block)ret.get(), new Item.Properties()));
        for (ResourceKey<CreativeModeTab> tab : tabs) {
            PRIVATE_TAB_REGISTRY.putInsert(tab, (RegistryObject<? extends ItemLike>)item);
        }
        return ret;
    }

    public static void register() {
    }
}

