/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.custom.vessel;

import dev.murad.shipping.ShippingConfig;
import dev.murad.shipping.entity.Colorable;
import dev.murad.shipping.entity.custom.TrainInventoryProvider;
import dev.murad.shipping.setup.ModItems;
import dev.murad.shipping.util.LinkableEntity;
import dev.murad.shipping.util.LinkingHandler;
import dev.murad.shipping.util.SpringPhysicsUtil;
import dev.murad.shipping.util.Train;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public abstract class VesselEntity
extends WaterAnimal
implements LinkableEntity<VesselEntity>,
Colorable {
    public static final EntityDataAccessor<Integer> COLOR_DATA = SynchedEntityData.m_135353_(VesselEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final double NAMETAG_RENDERING_DISTANCE = 15.0;
    private boolean frozen = false;
    public static final EntityDataAccessor<Integer> DOMINANT_ID = SynchedEntityData.m_135353_(VesselEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DOMINATED_ID = SynchedEntityData.m_135353_(VesselEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected final LinkingHandler<VesselEntity> linkingHandler = new LinkingHandler<VesselEntity>(this, VesselEntity.class, DOMINANT_ID, DOMINATED_ID);
    private int stuckCounter = 0;
    private double waterLevel;
    private float landFriction;
    private Boat.Status status;
    private Boat.Status oldStatus;
    private double lastYd;

    protected VesselEntity(EntityType<? extends WaterAnimal> type, Level world) {
        super(type, world);
        this.resetAttributes((Double)ShippingConfig.Server.TUG_BASE_SPEED.get());
    }

    public boolean m_6087_() {
        return true;
    }

    @Override
    public boolean hasWaterOnSides() {
        return this.m_9236_().m_6425_(this.m_20097_().m_121945_(this.m_6350_().m_122427_())).m_192917_((Fluid)Fluids.f_76193_) && this.m_9236_().m_6425_(this.m_20097_().m_121945_(this.m_6350_().m_122428_())).m_192917_((Fluid)Fluids.f_76193_) && this.m_9236_().m_8055_(this.m_20097_().m_7494_().m_121945_(this.m_6350_().m_122427_())).m_60734_().equals(Blocks.f_50016_) && this.m_9236_().m_8055_(this.m_20097_().m_7494_().m_121945_(this.m_6350_().m_122428_())).m_60734_().equals(Blocks.f_50016_);
    }

    @Override
    public BlockPos getBlockPos() {
        return this.m_20097_();
    }

    public void m_8119_() {
        super.m_8119_();
        this.linkingHandler.tickLoad();
        if (!this.m_9236_().f_46443_) {
            this.doChainMath();
        }
        if (this.m_6084_() && this.f_19797_ % 10 == 0) {
            this.m_5634_(1.0f);
        }
        if (!this.m_9236_().f_46443_) {
            this.oldStatus = this.status;
            this.status = this.getStatus();
            this.floatBoat();
            this.unDrown();
        }
    }

    private void unDrown() {
        if (this.m_9236_().m_8055_(this.m_20097_().m_7494_()).m_60734_().equals(Blocks.f_49990_)) {
            this.m_20256_(this.m_20184_().m_82549_(new Vec3(0.0, 0.1, 0.0)));
        }
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_((Attribute)ForgeMod.NAMETAG_DISTANCE.get(), 15.0).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 0.0);
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        this.linkingHandler.readAdditionalSaveData(compound);
        if (compound.m_128425_("Color", 3)) {
            this.setColor(compound.m_128451_("Color"));
        }
        super.m_7378_(compound);
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        this.linkingHandler.addAdditionalSaveData(compound);
        Integer color = this.getColor();
        if (color != null) {
            compound.m_128405_("Color", color.intValue());
        }
        super.m_7380_(compound);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(COLOR_DATA, (Object)-1);
        LinkingHandler.defineSynchedData((Entity)this, DOMINANT_ID, DOMINATED_ID);
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (this.linkingHandler != null) {
            this.linkingHandler.onSyncedDataUpdated(key);
        }
    }

    @Override
    @Nullable
    public Integer getColor() {
        int color = (Integer)this.m_20088_().m_135370_(COLOR_DATA);
        return color == -1 ? null : Integer.valueOf(color);
    }

    @Override
    public void setColor(Integer color) {
        if (color == null) {
            color = -1;
        }
        this.m_20088_().m_135381_(COLOR_DATA, (Object)color);
    }

    private void resetAttributes(double newSpeed) {
        this.m_21051_(Attributes.f_22279_).m_22100_(0.0);
        this.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get()).m_22100_(0.0);
        this.m_21051_(Attributes.f_22279_).m_22118_(new AttributeModifier("movementspeed_mult", newSpeed, AttributeModifier.Operation.ADDITION));
        this.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get()).m_22118_(new AttributeModifier("swimspeed_mult", newSpeed, AttributeModifier.Operation.ADDITION));
        this.m_20340_(true);
        this.m_21051_((Attribute)ForgeMod.NAMETAG_DISTANCE.get()).m_22100_(15.0);
    }

    protected void m_6229_(int airSupply) {
        this.m_20301_(300);
    }

    public abstract Item getDropItem();

    @Override
    public Optional<VesselEntity> getFollower() {
        return this.linkingHandler.follower;
    }

    @Override
    public Optional<VesselEntity> getLeader() {
        return this.linkingHandler.leader;
    }

    @Override
    public Train<VesselEntity> getTrain() {
        return this.linkingHandler.train;
    }

    public void m_6043_() {
    }

    @Override
    public boolean linkEntities(Player player, Entity t) {
        if (!(t instanceof VesselEntity)) {
            player.m_5661_((Component)Component.m_237115_((String)"item.littlelogistics.spring.badTypes"), true);
            return false;
        }
        VesselEntity target = (VesselEntity)t;
        Train<VesselEntity> firstTrain = this.getTrain();
        Train<VesselEntity> secondTrain = target.getTrain();
        if (this.m_20270_((Entity)target) > 15.0f) {
            player.m_5661_((Component)Component.m_237115_((String)"item.littlelogistics.spring.tooFar"), true);
        } else if (firstTrain.getTug().isPresent() && secondTrain.getTug().isPresent()) {
            player.m_5661_((Component)Component.m_237115_((String)"item.littlelogistics.spring.noTwoTugs"), true);
        } else if (secondTrain.equals(firstTrain)) {
            player.m_5661_((Component)Component.m_237115_((String)"item.littlelogistics.spring.noLoops"), true);
        } else {
            if (firstTrain.getTug().isPresent()) {
                VesselEntity tail = firstTrain.getTail();
                VesselEntity head = secondTrain.getHead();
                tail.setDominated(head);
                head.setDominant(tail);
                return true;
            }
            VesselEntity tail = secondTrain.getTail();
            VesselEntity head = firstTrain.getHead();
            tail.setDominated(head);
            head.setDominant(tail);
            return true;
        }
        return false;
    }

    public void doChainMath() {
        this.linkingHandler.leader.ifPresent(dominant -> {
            SpringPhysicsUtil.adjustSpringedEntities(dominant, this);
            this.m_20101_();
        });
    }

    public void m_142687_(Entity.RemovalReason r) {
        this.handleLinkableKill();
        super.m_142687_(r);
    }

    @Override
    public void handleShearsCut() {
        if (!this.m_9236_().f_46443_ && this.linkingHandler.leader.isPresent()) {
            this.spawnChain();
        }
        this.linkingHandler.leader.ifPresent(LinkableEntity::removeDominated);
        this.removeDominant();
    }

    private void spawnChain() {
        ItemStack stack = new ItemStack((ItemLike)ModItems.SPRING.get());
        this.m_19983_(stack);
    }

    @Nullable
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)this.getDropItem());
    }

    private void floatBoat() {
        double d0 = -0.04f;
        double d1 = this.m_20068_() ? 0.0 : (double)-0.04f;
        double d2 = 0.0;
        float invFriction = 0.05f;
        if (this.oldStatus == Boat.Status.IN_AIR && this.status != Boat.Status.IN_AIR && this.status != Boat.Status.ON_LAND) {
            this.waterLevel = this.m_20227_(1.0);
            this.m_6034_(this.m_20185_(), (double)(this.getWaterLevelAbove() - this.m_20206_()) + 0.101, this.m_20189_());
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.0, 1.0));
            this.lastYd = 0.0;
            this.status = Boat.Status.IN_WATER;
        } else {
            if (this.status == Boat.Status.IN_WATER) {
                d2 = (this.waterLevel - this.m_20186_()) / (double)this.m_20206_();
                invFriction = 0.9f;
            } else if (this.status == Boat.Status.UNDER_FLOWING_WATER) {
                d1 = -7.0E-4;
                invFriction = 0.9f;
            } else if (this.status == Boat.Status.UNDER_WATER) {
                d2 = 0.01f;
                invFriction = 0.45f;
            } else if (this.status == Boat.Status.IN_AIR) {
                invFriction = 0.9f;
            } else if (this.status == Boat.Status.ON_LAND) {
                invFriction = this.landFriction;
                if (this.m_6688_() instanceof Player) {
                    this.landFriction /= 2.0f;
                }
            }
            Vec3 vector3d = this.m_20184_();
            this.m_20334_(vector3d.f_82479_ * (double)invFriction, vector3d.f_82480_ + d1, vector3d.f_82481_ * (double)invFriction);
            if (d2 > 0.0) {
                Vec3 vector3d1 = this.m_20184_();
                this.m_20334_(vector3d1.f_82479_, (vector3d1.f_82480_ + d2 * 0.10153846016296973) * 0.75, vector3d1.f_82481_);
            }
        }
    }

    private Boat.Status getStatus() {
        Boat.Status Boat$status = this.isUnderwater();
        if (Boat$status != null) {
            this.waterLevel = this.m_20191_().f_82292_;
            return Boat$status;
        }
        if (this.checkInWater()) {
            return Boat.Status.IN_WATER;
        }
        float f = this.getGroundFriction();
        if (f > 0.0f) {
            this.landFriction = f;
            return Boat.Status.ON_LAND;
        }
        return Boat.Status.IN_AIR;
    }

    public float getWaterLevelAbove() {
        AABB aabb = this.m_20191_();
        int i = Mth.m_14107_((double)aabb.f_82288_);
        int j = Mth.m_14165_((double)aabb.f_82291_);
        int k = Mth.m_14107_((double)aabb.f_82292_);
        int l = Mth.m_14165_((double)(aabb.f_82292_ - this.lastYd));
        int i1 = Mth.m_14107_((double)aabb.f_82290_);
        int j1 = Mth.m_14165_((double)aabb.f_82293_);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        block0: for (int k1 = k; k1 < l; ++k1) {
            float f = 0.0f;
            for (int l1 = i; l1 < j; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutableblockpos.m_122178_(l1, k1, i2);
                    FluidState fluidstate = this.m_9236_().m_6425_((BlockPos)blockpos$mutableblockpos);
                    if (fluidstate.m_205070_(FluidTags.f_13131_)) {
                        f = Math.max(f, fluidstate.m_76155_((BlockGetter)this.m_9236_(), (BlockPos)blockpos$mutableblockpos));
                    }
                    if (f >= 1.0f) continue block0;
                }
            }
            if (!(f < 1.0f)) continue;
            return (float)blockpos$mutableblockpos.m_123342_() + f;
        }
        return l + 1;
    }

    public float getGroundFriction() {
        AABB aabb = this.m_20191_();
        AABB aabb1 = new AABB(aabb.f_82288_, aabb.f_82289_ - 0.001, aabb.f_82290_, aabb.f_82291_, aabb.f_82289_, aabb.f_82293_);
        int i = Mth.m_14107_((double)aabb1.f_82288_) - 1;
        int j = Mth.m_14165_((double)aabb1.f_82291_) + 1;
        int k = Mth.m_14107_((double)aabb1.f_82289_) - 1;
        int l = Mth.m_14165_((double)aabb1.f_82292_) + 1;
        int i1 = Mth.m_14107_((double)aabb1.f_82290_) - 1;
        int j1 = Mth.m_14165_((double)aabb1.f_82293_) + 1;
        VoxelShape voxelshape = Shapes.m_83064_((AABB)aabb1);
        float f = 0.0f;
        int k1 = 0;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int l1 = i; l1 < j; ++l1) {
            for (int i2 = i1; i2 < j1; ++i2) {
                int j2 = (l1 != i && l1 != j - 1 ? 0 : 1) + (i2 != i1 && i2 != j1 - 1 ? 0 : 1);
                if (j2 == 2) continue;
                for (int k2 = k; k2 < l; ++k2) {
                    if (j2 > 0 && (k2 == k || k2 == l - 1)) continue;
                    blockpos$mutableblockpos.m_122178_(l1, k2, i2);
                    BlockState blockstate = this.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos);
                    if (blockstate.m_60734_() instanceof WaterlilyBlock || !Shapes.m_83157_((VoxelShape)blockstate.m_60812_((BlockGetter)this.m_9236_(), (BlockPos)blockpos$mutableblockpos).m_83216_((double)l1, (double)k2, (double)i2), (VoxelShape)voxelshape, (BooleanOp)BooleanOp.f_82689_)) continue;
                    f += blockstate.getFriction((LevelReader)this.m_9236_(), (BlockPos)blockpos$mutableblockpos, (Entity)this);
                    ++k1;
                }
            }
        }
        return f / (float)k1;
    }

    private boolean checkInWater() {
        AABB aabb = this.m_20191_();
        int i = Mth.m_14107_((double)aabb.f_82288_);
        int j = Mth.m_14165_((double)aabb.f_82291_);
        int k = Mth.m_14107_((double)aabb.f_82289_);
        int l = Mth.m_14165_((double)(aabb.f_82289_ + 0.001));
        int i1 = Mth.m_14107_((double)aabb.f_82290_);
        int j1 = Mth.m_14165_((double)aabb.f_82293_);
        boolean flag = false;
        this.waterLevel = -1.7976931348623157E308;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutableblockpos.m_122178_(k1, l1, i2);
                    FluidState fluidstate = this.m_9236_().m_6425_((BlockPos)blockpos$mutableblockpos);
                    if (!fluidstate.m_205070_(FluidTags.f_13131_)) continue;
                    float f = (float)l1 + fluidstate.m_76155_((BlockGetter)this.m_9236_(), (BlockPos)blockpos$mutableblockpos);
                    this.waterLevel = Math.max((double)f, this.waterLevel);
                    flag |= aabb.f_82289_ < (double)f;
                }
            }
        }
        return flag;
    }

    @Nullable
    private Boat.Status isUnderwater() {
        AABB aabb = this.m_20191_();
        double d0 = aabb.f_82292_ + 0.001;
        int i = Mth.m_14107_((double)aabb.f_82288_);
        int j = Mth.m_14165_((double)aabb.f_82291_);
        int k = Mth.m_14107_((double)aabb.f_82292_);
        int l = Mth.m_14165_((double)d0);
        int i1 = Mth.m_14107_((double)aabb.f_82290_);
        int j1 = Mth.m_14165_((double)aabb.f_82293_);
        boolean flag = false;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutableblockpos.m_122178_(k1, l1, i2);
                    FluidState fluidstate = this.m_9236_().m_6425_((BlockPos)blockpos$mutableblockpos);
                    if (!fluidstate.m_205070_(FluidTags.f_13131_) || !(d0 < (double)((float)blockpos$mutableblockpos.m_123342_() + fluidstate.m_76155_((BlockGetter)this.m_9236_(), (BlockPos)blockpos$mutableblockpos)))) continue;
                    if (!fluidstate.m_76170_()) {
                        return Boat.Status.UNDER_FLOWING_WATER;
                    }
                    flag = true;
                }
            }
        }
        return flag ? Boat.Status.UNDER_WATER : null;
    }

    protected void m_203347_(TagKey<Fluid> pFluidTag) {
        if (this.m_21573_().m_26576_()) {
            super.m_203347_(pFluidTag);
        } else {
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.3, 0.0));
        }
    }

    public boolean m_6673_(DamageSource pSource) {
        if (((List)ShippingConfig.Server.VESSEL_EXEMPT_DAMAGE_SOURCES.get()).contains(pSource.m_19385_())) {
            return true;
        }
        return pSource.equals(this.m_9236_().m_269111_().m_269318_()) || super.m_6673_(pSource);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.empty();
        }
        return super.getCapability(cap, side);
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        if (this.m_6673_(damageSource)) {
            return false;
        }
        if (!this.m_9236_().f_46443_ && !this.m_213877_() && damageSource.m_7639_() instanceof Player) {
            int i = (int)Stream.of(this.linkingHandler.leader, this.linkingHandler.follower).filter(Optional::isPresent).count();
            if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
                for (int j = 0; j < i; ++j) {
                    this.spawnChain();
                }
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
            return true;
        }
        return super.m_6469_(damageSource, amount);
    }

    public void m_7023_(Vec3 relative) {
        if (this.m_21515_() || this.m_6109_()) {
            AttributeInstance gravity = this.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
            boolean flag = this.m_20184_().f_82480_ <= 0.0;
            double d0 = gravity.m_22135_();
            FluidState fluidstate = this.m_9236_().m_6425_(this.m_20183_());
            if (this.m_20069_() && this.m_6129_() && !this.m_203441_(fluidstate)) {
                double d8 = this.m_20186_();
                float f5 = this.m_20142_() ? 0.9f : this.m_6108_();
                float f6 = 0.02f;
                float f7 = 0.0f;
                if (f7 > 3.0f) {
                    f7 = 3.0f;
                }
                if (!this.m_20096_()) {
                    f7 *= 0.5f;
                }
                if (f7 > 0.0f) {
                    f5 += (0.54600006f - f5) * f7 / 3.0f;
                    f6 += (this.m_6113_() - f6) * f7 / 3.0f;
                }
                if (this.m_21023_(MobEffects.f_19593_)) {
                    f5 = 0.96f;
                }
                this.m_19920_(f6 *= (float)this.swimSpeed(), relative);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                Vec3 vector3d6 = this.m_20184_();
                if (this.f_19862_ && this.m_6147_()) {
                    vector3d6 = new Vec3(vector3d6.f_82479_, 0.2, vector3d6.f_82481_);
                }
                this.m_20256_(vector3d6.m_82542_((double)f5, (double)0.8f, (double)f5));
                Vec3 vector3d2 = this.m_20994_(d0, flag, this.m_20184_());
                this.m_20256_(vector3d2);
                if (this.f_19862_) {
                    if (this.stuckCounter > 10) {
                        Direction direction = this.m_6350_();
                        BlockPos front = this.m_20097_().m_121945_(direction).m_7494_();
                        BlockPos left = front.m_121945_(direction.m_122427_());
                        BlockPos right = front.m_121945_(direction.m_122428_());
                        for (BlockPos pos : Arrays.asList(front, left, right)) {
                            BlockState state = this.m_9236_().m_8055_(pos);
                            if (!state.m_60713_(Blocks.f_50196_)) continue;
                            this.m_9236_().m_46961_(pos, true);
                        }
                        this.stuckCounter = 0;
                    } else {
                        ++this.stuckCounter;
                    }
                }
            } else if (this.m_20077_() && this.m_6129_() && !this.m_203441_(fluidstate)) {
                double d7 = this.m_20186_();
                this.m_19920_(0.02f, relative);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                if (this.m_204036_(FluidTags.f_13132_) <= this.m_20204_()) {
                    this.m_20256_(this.m_20184_().m_82542_(0.5, (double)0.8f, 0.5));
                    Vec3 vector3d3 = this.m_20994_(d0, flag, this.m_20184_());
                    this.m_20256_(vector3d3);
                } else {
                    this.m_20256_(this.m_20184_().m_82490_(0.5));
                }
                if (!this.m_20068_()) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, -d0 / 4.0, 0.0));
                }
                Vec3 vector3d4 = this.m_20184_();
                if (this.f_19862_ && this.m_20229_(vector3d4.f_82479_, vector3d4.f_82480_ + (double)0.6f - this.m_20186_() + d7, vector3d4.f_82481_)) {
                    this.m_20334_(vector3d4.f_82479_, 0.3f, vector3d4.f_82481_);
                }
            } else if (this.m_21255_()) {
                double d10;
                double d6;
                float f2;
                Vec3 vector3d = this.m_20184_();
                if (vector3d.f_82480_ > -0.5) {
                    this.f_19789_ = 1.0f;
                }
                Vec3 vector3d1 = this.m_20154_();
                float f = this.m_146909_() * ((float)Math.PI / 180);
                double d1 = Math.sqrt(vector3d1.f_82479_ * vector3d1.f_82479_ + vector3d1.f_82481_ * vector3d1.f_82481_);
                double d3 = this.m_20184_().m_165924_();
                double d4 = vector3d1.m_82553_();
                float f1 = Mth.m_14089_((float)f);
                f1 = (float)((double)f1 * (double)f1 * Math.min(1.0, d4 / 0.4));
                vector3d = this.m_20184_().m_82520_(0.0, d0 * (-1.0 + (double)f1 * 0.75), 0.0);
                if (vector3d.f_82480_ < 0.0 && d1 > 0.0) {
                    double d5 = vector3d.f_82480_ * -0.1 * (double)f1;
                    vector3d = vector3d.m_82520_(vector3d1.f_82479_ * d5 / d1, d5, vector3d1.f_82481_ * d5 / d1);
                }
                if (f < 0.0f && d1 > 0.0) {
                    double d9 = d3 * (double)(-Mth.m_14031_((float)f)) * 0.04;
                    vector3d = vector3d.m_82520_(-vector3d1.f_82479_ * d9 / d1, d9 * 3.2, -vector3d1.f_82481_ * d9 / d1);
                }
                if (d1 > 0.0) {
                    vector3d = vector3d.m_82520_((vector3d1.f_82479_ / d1 * d3 - vector3d.f_82479_) * 0.1, 0.0, (vector3d1.f_82481_ / d1 * d3 - vector3d.f_82481_) * 0.1);
                }
                this.m_20256_(vector3d.m_82542_((double)0.99f, (double)0.98f, (double)0.99f));
                this.m_6478_(MoverType.SELF, this.m_20184_());
                if (this.f_19862_ && !this.m_9236_().f_46443_ && (f2 = (float)((d6 = d3 - (d10 = this.m_20184_().m_165924_())) * 10.0 - 3.0)) > 0.0f) {
                    this.m_6469_(this.m_9236_().m_269111_().m_269515_(), f2);
                }
                if (this.m_20096_() && !this.m_9236_().f_46443_) {
                    this.m_20115_(7, false);
                }
            } else {
                BlockPos blockpos = this.m_20099_();
                float f3 = this.m_9236_().m_8055_(this.m_20099_()).getFriction((LevelReader)this.m_9236_(), this.m_20099_(), (Entity)this);
                float f4 = this.m_20096_() ? f3 * 0.91f : 0.91f;
                Vec3 vector3d5 = this.m_21074_(relative, f3);
                double d2 = vector3d5.f_82480_;
                if (this.m_21023_(MobEffects.f_19620_)) {
                    d2 += (0.05 * (double)(this.m_21124_(MobEffects.f_19620_).m_19564_() + 1) - vector3d5.f_82480_) * 0.2;
                    this.f_19789_ = 0.0f;
                } else if (this.m_9236_().f_46443_ && !this.m_9236_().m_46805_(blockpos)) {
                    d2 = this.m_20186_() > 0.0 ? -0.1 : 0.0;
                } else if (!this.m_20068_()) {
                    d2 -= d0;
                }
                this.m_20334_(vector3d5.f_82479_ * (double)f4, d2 * (double)0.98f, vector3d5.f_82481_ * (double)f4);
            }
        }
        this.m_267651_(false);
    }

    protected double swimSpeed() {
        return this.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get()).m_22135_();
    }

    public List<TrainInventoryProvider> getConnectedInventories() {
        VesselEntity vesselEntity;
        ArrayList<TrainInventoryProvider> result = new ArrayList<TrainInventoryProvider>();
        Optional<VesselEntity> vessel = this.getFollower();
        while (vessel.isPresent() && !(vessel.get() instanceof TrainInventoryProvider)) {
            vessel = vessel.get().getFollower();
        }
        while (vessel.isPresent() && (vesselEntity = vessel.get()) instanceof TrainInventoryProvider) {
            TrainInventoryProvider e = (TrainInventoryProvider)((Object)vesselEntity);
            result.add(e);
            vessel = vessel.get().getFollower();
        }
        return result;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }
}

