/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.misc;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.metadata.animation.AnimationFrame;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record McMetaFile(@NotNull AnimationMetadataSection animation, JsonObject moddedStuff) {
    private static List<Field> FIELDS = null;
    private static final int VANILLA_FIELDS = 5;

    public static McMetaFile of(@NotNull AnimationMetadataSection vanillaMcmeta) {
        return new McMetaFile(vanillaMcmeta, new JsonObject());
    }

    public static McMetaFile of(@NotNull AnimationMetadataSection vanillaMcmeta, JsonObject moddedStuff) {
        return new McMetaFile(vanillaMcmeta, moddedStuff);
    }

    public static McMetaFile read(Resource resource) throws IOException {
        try (InputStream metadataStream = resource.m_215507_();){
            byte[] bytes = metadataStream.readAllBytes();
            AnimationMetadataSection metadata = (AnimationMetadataSection)AbstractPackResources.m_10214_((MetadataSectionSerializer)AnimationMetadataSection.f_119011_, (InputStream)new ByteArrayInputStream(bytes));
            if (metadata == null) {
                metadata = AnimationMetadataSection.f_119012_;
            }
            JsonObject moddedObj = McMetaFile.readModdedObj(bytes);
            McMetaFile mcMetaFile = McMetaFile.of(metadata, moddedObj);
            return mcMetaFile;
        }
    }

    private static JsonObject readModdedObj(byte[] bytes) {
        JsonObject jo = GsonHelper.m_13864_((String)new String(bytes));
        for (String key : new String[]{"frametime", "width", "height", "interpolate", "frames"}) {
            jo.remove(key);
        }
        return jo;
    }

    @Nullable
    public static McMetaFile merge(@Nullable McMetaFile mostImportant, @Nullable McMetaFile leastImportant) {
        if (mostImportant == null && leastImportant == null) {
            return null;
        }
        if (leastImportant == null) {
            return mostImportant;
        }
        if (mostImportant == null) {
            return leastImportant;
        }
        if (mostImportant.animation == AnimationMetadataSection.f_119012_) {
            return McMetaFile.of(leastImportant.animation, mostImportant.moddedStuff);
        }
        return mostImportant;
    }

    public JsonObject toJson() {
        JsonObject obj = this.moddedStuff.deepCopy();
        JsonObject animObj = new JsonObject();
        animObj.addProperty("frametime", (Number)this.animation.m_119030_());
        animObj.addProperty("interpolate", Boolean.valueOf(this.animation.m_119036_()));
        animObj.addProperty("height", (Number)this.animation.f_119015_);
        animObj.addProperty("width", (Number)this.animation.f_119014_);
        JsonArray frames = new JsonArray();
        this.animation.m_174861_((i, t) -> {
            if (t != -1) {
                JsonObject o = new JsonObject();
                o.addProperty("time", (Number)t);
                o.addProperty("index", (Number)i);
                frames.add((JsonElement)o);
            } else {
                frames.add((Number)i);
            }
        });
        animObj.add("frames", (JsonElement)frames);
        obj.add("animation", (JsonElement)animObj);
        return obj;
    }

    public McMetaFile cloneWithSize(int frameWidth, int frameHeight) {
        ArrayList frameData = new ArrayList();
        this.animation.m_174861_((i, t) -> frameData.add(new AnimationFrame(i, t)));
        AnimationMetadataSection newMetadata = new AnimationMetadataSection(frameData, frameWidth, frameHeight, this.animation.m_119030_(), this.animation.m_119036_());
        JsonObject newModdedStuff = this.moddedStuff.deepCopy();
        return new McMetaFile(newMetadata, newModdedStuff);
    }

    public static void copyAllMixinAddedFields(AnimationMetadataSection from, AnimationMetadataSection to) {
        if (FIELDS == null) {
            FIELDS = new ArrayList<Field>();
            Field[] f = AnimationMetadataSection.class.getDeclaredFields();
            for (int i = 0; i < f.length; ++i) {
                if (i <= 4) continue;
                Field field = f[i];
                FIELDS.add(field);
                field.setAccessible(true);
            }
        }
        for (Field field : FIELDS) {
            try {
                field.set(to, field.get(from));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

