/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.worldgen;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.mehvahdjukaar.hauntedharvest.worldgen.FarmFieldFeature;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class SeedBasedFeaturePoolElement
extends StructurePoolElement {
    public static final Codec<SeedBasedFeaturePoolElement> CODEC = RecordCodecBuilder.create(i -> i.group((App)SimpleWeightedRandomList.m_146264_((Codec)PlacedFeature.f_191773_).fieldOf("features").forGetter(e -> e.features), (App)SeedBasedFeaturePoolElement.m_210538_()).apply((Applicative)i, SeedBasedFeaturePoolElement::new));
    private final SimpleWeightedRandomList<Holder<PlacedFeature>> features;
    private final CompoundTag defaultJigsawNBT = this.fillDefaultJigsawNBT();

    protected SeedBasedFeaturePoolElement(SimpleWeightedRandomList<Holder<PlacedFeature>> features, StructureTemplatePool.Projection projection) {
        super(projection);
        features = this.removeDisabledHack(features);
        this.features = features;
    }

    private SimpleWeightedRandomList<Holder<PlacedFeature>> removeDisabledHack(SimpleWeightedRandomList<Holder<PlacedFeature>> original) {
        SimpleWeightedRandomList.Builder newList = new SimpleWeightedRandomList.Builder();
        for (WeightedEntry.Wrapper v : original.m_146338_()) {
            FarmFieldFeature.Config c;
            FeatureConfiguration featureConfiguration = ((ConfiguredFeature)((PlacedFeature)((Holder)v.m_146310_()).m_203334_()).f_191775_().m_203334_()).f_65378_();
            if (featureConfiguration instanceof FarmFieldFeature.Config && !(c = (FarmFieldFeature.Config)featureConfiguration).crop().isEnabled()) continue;
            newList.m_146271_((Object)((Holder)v.m_146310_()), v.m_142631_().m_146281_());
        }
        return newList.m_146270_();
    }

    private CompoundTag fillDefaultJigsawNBT() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128359_("name", "minecraft:bottom");
        compoundTag.m_128359_("final_state", "minecraft:air");
        compoundTag.m_128359_("pool", "minecraft:empty");
        compoundTag.m_128359_("target", "minecraft:empty");
        compoundTag.m_128359_("joint", JigsawBlockEntity.JointType.ROLLABLE.m_7912_());
        return compoundTag;
    }

    public Vec3i m_213577_(StructureTemplateManager structureTemplateManager, Rotation rotation) {
        return Vec3i.f_123288_;
    }

    public List<StructureTemplate.StructureBlockInfo> m_213638_(StructureTemplateManager structureTemplateManager, BlockPos blockPos, Rotation rotation, RandomSource randomSource) {
        ArrayList list = Lists.newArrayList();
        list.add(new StructureTemplate.StructureBlockInfo(blockPos, (BlockState)Blocks.f_50678_.m_49966_().m_61124_((Property)JigsawBlock.f_54222_, (Comparable)FrontAndTop.m_122622_((Direction)Direction.DOWN, (Direction)Direction.SOUTH)), this.defaultJigsawNBT));
        return list;
    }

    public BoundingBox m_214015_(StructureTemplateManager structureTemplateManager, BlockPos blockPos, Rotation rotation) {
        Vec3i vec3i = this.m_213577_(structureTemplateManager, rotation);
        return new BoundingBox(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_(), blockPos.m_123341_() + vec3i.m_123341_(), blockPos.m_123342_() + vec3i.m_123342_(), blockPos.m_123343_() + vec3i.m_123343_());
    }

    public boolean m_213695_(StructureTemplateManager structureTemplateManager, WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, BlockPos blockPos, BlockPos centerPos, Rotation rotation, BoundingBox box, RandomSource random, boolean bl) {
        return ((PlacedFeature)((Holder)((WeightedEntry.Wrapper)this.features.m_216829_(RandomSource.m_216335_((long)centerPos.m_121878_())).get()).m_146310_()).m_203334_()).m_226357_(level, generator, random, blockPos);
    }

    public StructurePoolElementType<?> m_207234_() {
        return ModRegistry.RANDOM_FEATURE_POOL.get();
    }

    public String toString() {
        return "Features[" + String.valueOf(this.features) + "]";
    }
}

