/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.reg;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.mehvahdjukaar.hauntedharvest.HauntedHarvest;
import net.mehvahdjukaar.hauntedharvest.ai.PumpkinPoiSensor;
import net.mehvahdjukaar.hauntedharvest.blocks.CandyBagBlock;
import net.mehvahdjukaar.hauntedharvest.blocks.CandyBagTile;
import net.mehvahdjukaar.hauntedharvest.blocks.CandyCornItem;
import net.mehvahdjukaar.hauntedharvest.blocks.CornBaseBlock;
import net.mehvahdjukaar.hauntedharvest.blocks.CornMiddleBlock;
import net.mehvahdjukaar.hauntedharvest.blocks.CornTopBlock;
import net.mehvahdjukaar.hauntedharvest.blocks.ModCarvedPumpkinBlock;
import net.mehvahdjukaar.hauntedharvest.blocks.ModCarvedPumpkinBlockTile;
import net.mehvahdjukaar.hauntedharvest.blocks.PaperBagBlock;
import net.mehvahdjukaar.hauntedharvest.blocks.PumpkinType;
import net.mehvahdjukaar.hauntedharvest.configs.CommonConfigs;
import net.mehvahdjukaar.hauntedharvest.entity.SplatteredEggEntity;
import net.mehvahdjukaar.hauntedharvest.items.GrimAppleItem;
import net.mehvahdjukaar.hauntedharvest.items.ModCarvedPumpkinItem;
import net.mehvahdjukaar.hauntedharvest.items.PaperBagItem;
import net.mehvahdjukaar.hauntedharvest.items.crafting.ModCarvedPumpkinRecipe;
import net.mehvahdjukaar.hauntedharvest.reg.ModFoods;
import net.mehvahdjukaar.hauntedharvest.worldgen.AbandonedFarmStructure;
import net.mehvahdjukaar.hauntedharvest.worldgen.FarmFieldFeature;
import net.mehvahdjukaar.hauntedharvest.worldgen.ProcessFarmProcessor;
import net.mehvahdjukaar.hauntedharvest.worldgen.SeedBasedFeaturePoolElement;
import net.mehvahdjukaar.moonlight.api.misc.ModItemListing;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.material.PushReaction;

public class ModRegistry {
    public static final Supplier<Activity> EAT_CANDY = RegHelper.registerActivity((ResourceLocation)HauntedHarvest.res("eat_candy"));
    public static final Supplier<Activity> TRICK_OR_TREAT = RegHelper.registerActivity((ResourceLocation)HauntedHarvest.res("trick_or_treat"));
    public static final Supplier<StructureType<AbandonedFarmStructure>> FARM = RegHelper.registerStructure((ResourceLocation)HauntedHarvest.res("abandoned_farm"), AbandonedFarmStructure.Type::new);
    public static final Supplier<StructureProcessorType<ProcessFarmProcessor>> FARM_PROCESSOR = RegHelper.register((ResourceLocation)HauntedHarvest.res("process_farm"), () -> () -> ProcessFarmProcessor.CODEC, (ResourceKey)Registries.f_256983_);
    public static final Supplier<StructurePoolElementType<SeedBasedFeaturePoolElement>> RANDOM_FEATURE_POOL = RegHelper.register((ResourceLocation)HauntedHarvest.res("random_feature_pool_element"), () -> () -> SeedBasedFeaturePoolElement.CODEC, (ResourceKey)Registries.f_257024_);
    public static final Supplier<Feature<FarmFieldFeature.Config>> FARM_FIELD_FEATURE = RegHelper.registerFeature((ResourceLocation)HauntedHarvest.res("farm_field"), () -> new FarmFieldFeature(FarmFieldFeature.Config.CODEC));
    public static final Supplier<Schedule> HALLOWEEN_VILLAGER_BABY_SCHEDULE = RegHelper.registerSchedule((ResourceLocation)HauntedHarvest.res("villager_baby_halloween"), Schedule::new);
    public static final Supplier<MemoryModuleType<GlobalPos>> PUMPKIN_POS = RegHelper.registerMemoryModule((ResourceLocation)HauntedHarvest.res("pumpkin_pos"), () -> new MemoryModuleType(Optional.of(GlobalPos.f_122633_)));
    public static final Supplier<MemoryModuleType<GlobalPos>> NEAREST_PUMPKIN = RegHelper.registerMemoryModule((ResourceLocation)HauntedHarvest.res("nearest_pumpkin"), () -> new MemoryModuleType(Optional.empty()));
    public static final Supplier<SensorType<PumpkinPoiSensor>> PUMPKIN_POI_SENSOR = RegHelper.registerSensor((ResourceLocation)HauntedHarvest.res("pumpkin_poi"), () -> new SensorType(PumpkinPoiSensor::new));
    public static final Supplier<RecipeSerializer<ModCarvedPumpkinRecipe>> CARVED_PUMPKIN_RECIPE = RegHelper.registerSpecialRecipe((ResourceLocation)HauntedHarvest.res("carved_pumpkin"), ModCarvedPumpkinRecipe::new);
    public static final Supplier<SimpleParticleType> SPOOKED_PARTICLE = RegHelper.registerParticle((ResourceLocation)HauntedHarvest.res("spooked"));
    public static final String SPLATTERED_EGG_NAME = "splattered_egg";
    public static final Supplier<EntityType<SplatteredEggEntity>> SPLATTERED_EGG_ENTITY = RegHelper.registerEntityType((ResourceLocation)HauntedHarvest.res("splattered_egg"), SplatteredEggEntity::new, (MobCategory)MobCategory.MISC, (float)0.5f, (float)0.5f, (int)10, (int)Integer.MAX_VALUE);
    public static final String GRIM_APPLE_NAME = "grim_apple";
    public static final Supplier<Item> GRIM_APPLE = ModRegistry.regItem("grim_apple", () -> new GrimAppleItem(new Item.Properties().m_41497_(Rarity.RARE).m_41489_(ModFoods.DEATH_APPLE)));
    public static final String ROTTEN_APPLE_NAME = "rotten_apple";
    public static final Supplier<Item> ROTTEN_APPLE = ModRegistry.regItem("rotten_apple", () -> new Item(new Item.Properties().m_41489_(ModFoods.ROTTEN_APPLE)));
    public static final Supplier<Block> CORN_BASE = ModRegistry.regBlock("corn_base", () -> new CornBaseBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_).m_60977_().m_222979_(BlockBehaviour.OffsetType.NONE).m_60966_().m_60918_(SoundType.f_56758_)));
    public static final Supplier<Block> CORN_MIDDLE = ModRegistry.regBlock("corn_middle", () -> new CornMiddleBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)CORN_BASE.get()))));
    public static final Supplier<Block> CORN_TOP = ModRegistry.regBlock("corn_top", () -> new CornTopBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)CORN_BASE.get()))));
    public static final Supplier<Block> CORN_POT = ModRegistry.regBlock("potted_corn", () -> PlatHelper.newFlowerPot(() -> (FlowerPotBlock)Blocks.f_50276_, CORN_BASE, (BlockBehaviour.Properties)BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50276_)));
    public static final String CORN_NAME = "corn";
    public static final Supplier<Item> COB_ITEM = ModRegistry.regItem("corn", () -> new Item(new Item.Properties()));
    public static final Supplier<Item> COOKED_COB = ModRegistry.regItem("corn_on_the_cob", () -> new Item(new Item.Properties().m_41487_(16).m_41489_(ModFoods.CORN_ON_THE_COB)));
    public static final Supplier<Item> KERNELS = ModRegistry.regItem("kernels", () -> new ItemNameBlockItem(CORN_BASE.get(), new Item.Properties()));
    public static final String POPCORN_NAME = "popcorn";
    public static final Supplier<Item> POP_CORN = ModRegistry.regItem("popcorn", () -> new Item(new Item.Properties().m_41489_(ModFoods.POPCORN)));
    public static final String CANDY_CORN_NAME = "candy_corn";
    public static final Supplier<Item> CANDY_CORN = ModRegistry.regItem("candy_corn", () -> new CandyCornItem(new Item.Properties().m_41489_(ModFoods.CANDY_CORN)));
    public static final Supplier<Block> PAPER_BAG = ModRegistry.regBlock("paper_bag", () -> new PaperBagBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50041_).m_60913_(0.5f, 0.5f)));
    public static final String PAPER_BAG_NAME = "paper_bag";
    public static final Supplier<Item> PAPER_BAG_ITEM = ModRegistry.regItem("paper_bag", () -> new PaperBagItem(PAPER_BAG.get(), new Item.Properties()));
    public static final Supplier<Block> CANDY_BAG = ModRegistry.regBlock("candy_bag", () -> new CandyBagBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)PAPER_BAG.get())).m_278166_(PushReaction.DESTROY)));
    public static final Supplier<BlockEntityType<CandyBagTile>> CANDY_BAG_TILE = ModRegistry.regTile("candy_bag", () -> PlatHelper.newBlockEntityType(CandyBagTile::new, (Block[])new Block[]{CANDY_BAG.get()}));
    public static final String CARVED_PUMPKIN_NAME = "carved_pumpkin";
    public static final Supplier<ModCarvedPumpkinBlock> CARVED_PUMPKIN = ModRegistry.regPumpkin("carved_pumpkin", () -> new ModCarvedPumpkinBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50143_), PumpkinType.NORMAL));
    public static final Supplier<ModCarvedPumpkinBlock> JACK_O_LANTERN = ModRegistry.regPumpkin("jack_o_lantern", () -> new ModCarvedPumpkinBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50143_).m_60953_(s -> 15), PumpkinType.JACK));
    public static final Supplier<BlockEntityType<ModCarvedPumpkinBlockTile>> MOD_CARVED_PUMPKIN_TILE = ModRegistry.regTile("carved_pumpkin", () -> PlatHelper.newBlockEntityType(ModCarvedPumpkinBlockTile::new, (Block[])((Block[])PumpkinType.getTypes().stream().map(PumpkinType::getPumpkin).toArray(Block[]::new))));

    public static void init() {
        RegHelper.registerWanderingTraderTrades((int)0, ModRegistry::addTrades);
    }

    private static void addTrades(List<VillagerTrades.ItemListing> itemListings) {
        if (CommonConfigs.CORN_ENABLED.get().booleanValue()) {
            itemListings.add((VillagerTrades.ItemListing)new ModItemListing(2, KERNELS.get().m_7968_(), 12, 1));
        }
    }

    public static Supplier<ModCarvedPumpkinBlock> regPumpkin(String name, Supplier<ModCarvedPumpkinBlock> supplier) {
        Supplier<ModCarvedPumpkinBlock> block = ModRegistry.regBlock(name, supplier);
        Supplier<ModCarvedPumpkinItem> item = ModRegistry.regItem(name, () -> new ModCarvedPumpkinItem((ModCarvedPumpkinBlock)((Object)((Object)block.get())), new Item.Properties()));
        return block;
    }

    public static <T extends Item> Supplier<T> regItem(String name, Supplier<T> sup) {
        return RegHelper.registerItem((ResourceLocation)HauntedHarvest.res(name), sup);
    }

    public static <T extends BlockEntityType<E>, E extends BlockEntity> Supplier<T> regTile(String name, Supplier<T> sup) {
        return RegHelper.registerBlockEntityType((ResourceLocation)HauntedHarvest.res(name), sup);
    }

    public static <T extends Block> Supplier<T> regBlock(String name, Supplier<T> sup) {
        return RegHelper.registerBlock((ResourceLocation)HauntedHarvest.res(name), sup);
    }

    public static <T extends Block> Supplier<T> regWithItem(String name, Supplier<T> blockFactory, Item.Properties properties) {
        Supplier<T> block = ModRegistry.regBlock(name, blockFactory);
        ModRegistry.regBlockItem(name, block, properties);
        return block;
    }

    public static Supplier<BlockItem> regBlockItem(String name, Supplier<? extends Block> blockSup, Item.Properties properties) {
        return RegHelper.registerItem((ResourceLocation)HauntedHarvest.res(name), () -> new BlockItem((Block)blockSup.get(), properties));
    }
}

