/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.forge;

import java.util.Optional;
import net.mehvahdjukaar.hauntedharvest.HauntedHarvest;
import net.mehvahdjukaar.hauntedharvest.forge.HauntedHarvestForgeClient;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.MissingMappingsEvent;

@Mod(value="hauntedharvest")
public class HauntedHarvestForge {
    public HauntedHarvestForge() {
        HauntedHarvest.commonInit();
        MinecraftForge.EVENT_BUS.register((Object)this);
        PlatHelper.addCommonSetup(() -> ((FlowerPotBlock)Blocks.f_50276_).addPlant(Utils.getID((Block)ModRegistry.CORN_BASE.get()), ModRegistry.CORN_POT));
        if (PlatHelper.getPhysicalSide().isClient()) {
            HauntedHarvestForgeClient.init();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onUseBlock(PlayerInteractEvent.RightClickBlock event) {
        InteractionResult ret;
        if (!event.isCanceled() && (ret = HauntedHarvest.onRightClickBlock(event.getEntity(), event.getLevel(), event.getHand(), event.getHitVec())) != InteractionResult.PASS) {
            event.setCanceled(true);
            event.setCancellationResult(ret);
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        ServerLevel overworld;
        if (event.phase == TickEvent.Phase.END && (overworld = event.getServer().m_129783_()).m_46467_() % 10000L == 0L) {
            HauntedHarvest.getSeasonManager().refresh();
        }
    }

    @SubscribeEvent
    public void onTagLoad(TagsUpdatedEvent event) {
        HauntedHarvest.onTagLoad();
    }

    @SubscribeEvent
    public void onRemapBlocks(MissingMappingsEvent event) {
        Optional o;
        String name;
        for (MissingMappingsEvent.Mapping m : event.getMappings(ForgeRegistries.BLOCKS.getRegistryKey(), "harvestseason")) {
            name = m.getKey().m_135815_();
            o = BuiltInRegistries.f_256975_.m_6612_(HauntedHarvest.res(name));
            o.ifPresent(arg_0 -> ((MissingMappingsEvent.Mapping)m).remap(arg_0));
        }
        for (MissingMappingsEvent.Mapping m : event.getMappings(ForgeRegistries.ITEMS.getRegistryKey(), "harvestseason")) {
            name = m.getKey().m_135815_();
            o = BuiltInRegistries.f_257033_.m_6612_(HauntedHarvest.res(name));
            o.ifPresent(arg_0 -> ((MissingMappingsEvent.Mapping)m).remap(arg_0));
        }
        for (MissingMappingsEvent.Mapping m : event.getMappings(ForgeRegistries.BLOCK_ENTITY_TYPES.getRegistryKey(), "harvestseason")) {
            name = m.getKey().m_135815_();
            o = BuiltInRegistries.f_257049_.m_6612_(HauntedHarvest.res(name));
            o.ifPresent(arg_0 -> ((MissingMappingsEvent.Mapping)m).remap(arg_0));
        }
    }
}

