/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.client.model;

import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.hauntedharvest.blocks.ModCarvedPumpkinBlock;
import net.mehvahdjukaar.hauntedharvest.blocks.ModCarvedPumpkinBlockTile;
import net.mehvahdjukaar.hauntedharvest.blocks.PumpkinType;
import net.mehvahdjukaar.hauntedharvest.client.CarvingManager;
import net.mehvahdjukaar.hauntedharvest.client.PumpkinTextureGenerator;
import net.mehvahdjukaar.moonlight.api.client.model.BakedQuadBuilder;
import net.mehvahdjukaar.moonlight.api.client.model.CustomBakedModel;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3f;

public class CarvedPumpkinBakedModel
implements CustomBakedModel {
    private final ModelState modelTransform;
    private final BakedModel back;

    public CarvedPumpkinBakedModel(BakedModel back, ModelState modelTransform) {
        this.back = back;
        this.modelTransform = modelTransform;
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite getBlockParticle(ExtraModelData data) {
        return this.back.m_6160_();
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    public ItemTransforms m_7442_() {
        return ItemTransforms.f_111786_;
    }

    public List<BakedQuad> getBlockQuads(BlockState state, Direction side, RandomSource rand, RenderType renderType, ExtraModelData data) {
        CarvingManager.Key key;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(this.back.m_213637_(state, side, rand));
        if (data != ExtraModelData.EMPTY && state != null && side == state.m_61143_((Property)ModCarvedPumpkinBlock.f_51367_) && (key = (CarvingManager.Key)data.get(ModCarvedPumpkinBlockTile.CARVING)) != null) {
            CarvingManager.Carving carving = CarvingManager.getInstance(key);
            quads.addAll(carving.getOrCreateModel(side, this::generateQuads));
        }
        return quads;
    }

    private List<BakedQuad> generateQuads(CarvingManager.Carving carving, Direction direction) {
        boolean[][] px = carving.getPixels();
        PumpkinType type = carving.getType();
        Material[][] pixels = PumpkinTextureGenerator.computePixelMaterialMap(px, type);
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        Transformation rotation = this.modelTransform.m_6189_();
        for (int x = 0; x < pixels.length; ++x) {
            int length = 0;
            int startY = 0;
            Material prevColor = pixels[0][x];
            for (int y = 0; y <= pixels[x].length; ++y) {
                Material current = null;
                if (y < pixels[x].length) {
                    Material b = pixels[x][y];
                    if (prevColor == b) {
                        ++length;
                        continue;
                    }
                    current = b;
                }
                TextureAtlasSprite sprite = prevColor.m_119204_();
                quads.add(CarvedPumpkinBakedModel.createPixelQuad((float)(15 - x) / 16.0f, (float)(16 - length - startY) / 16.0f, 0.0f, 0.0625f, (float)length / 16.0f, sprite, rotation));
                startY = y;
                if (current != null) {
                    prevColor = current;
                }
                length = 1;
            }
        }
        return quads;
    }

    public static BakedQuad createPixelQuad(float x, float y, float z, float width, float height, TextureAtlasSprite sprite, Transformation transform) {
        float u0 = 1.0f - x;
        float v0 = 1.0f - y;
        float u1 = 1.0f - (x + width);
        float v1 = 1.0f - (y + height);
        BakedQuadBuilder builder = BakedQuadBuilder.create((TextureAtlasSprite)sprite, (Transformation)transform);
        builder.setAutoDirection();
        CarvedPumpkinBakedModel.putVertex(builder, x + width, y + height, z, u1, v1);
        CarvedPumpkinBakedModel.putVertex(builder, x + width, y, z, u1, v0);
        CarvedPumpkinBakedModel.putVertex(builder, x, y, z, u0, v0);
        CarvedPumpkinBakedModel.putVertex(builder, x, y + height, z, u0, v1);
        return builder.build();
    }

    private static void putVertex(BakedQuadBuilder builder, float x, float y, float z, float u, float v) {
        Vector3f posV = new Vector3f(x, y, z);
        posV.set((float)Math.round(posV.x() * 16.0f) / 16.0f, (float)Math.round(posV.y() * 16.0f) / 16.0f, (float)Math.round(posV.z() * 16.0f) / 16.0f);
        builder.m_5483_((double)posV.x, (double)posV.y, (double)posV.z);
        builder.m_193479_(-1);
        builder.m_7421_(u, v);
        builder.m_5601_(0.0f, 0.0f, -1.0f);
        builder.m_5752_();
    }
}

