/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.client.gui;

import com.mojang.blaze3d.platform.Lighting;
import net.mehvahdjukaar.hauntedharvest.blocks.ModCarvedPumpkinBlockTile;
import net.mehvahdjukaar.hauntedharvest.client.PumpkinTextureGenerator;
import net.mehvahdjukaar.hauntedharvest.client.gui.CarvingButton;
import net.mehvahdjukaar.hauntedharvest.network.NetworkHandler;
import net.mehvahdjukaar.hauntedharvest.network.ServerBoundCarvePumpkinPacket;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class CarvingGui
extends Screen {
    private static final MutableComponent CLEAR = Component.m_237115_((String)"gui.hauntedharvest.carving.clear");
    private static final MutableComponent EDIT = Component.m_237115_((String)"gui.hauntedharvest.carving.edit");
    private final ModCarvedPumpkinBlockTile tile;
    private final CarvingButton[][] buttons = new CarvingButton[16][16];
    private Direction clickedFace = null;

    private CarvingGui(ModCarvedPumpkinBlockTile teBoard, Direction dir) {
        super((Component)EDIT);
        this.tile = teBoard;
        this.clickedFace = dir;
    }

    public static void open(ModCarvedPumpkinBlockTile sign, Direction dir) {
        Minecraft.m_91087_().m_91152_((Screen)new CarvingGui(sign, dir));
    }

    public void m_86600_() {
        if (!this.tile.m_58903_().m_155262_(this.tile.m_58900_())) {
            this.close();
        }
    }

    public void m_7379_() {
        this.close();
    }

    public void m_7861_() {
        boolean[][] pixels = this.getPixelMatrix();
        this.getPixelMatrix();
        NetworkHandler.CHANNEL.sendToServer((Message)new ServerBoundCarvePumpkinPacket(this.tile.m_58899_(), pixels, this.clickedFace));
    }

    private boolean[][] getPixelMatrix() {
        boolean[][] pixels = new boolean[16][16];
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                pixels[xx][yy] = this.buttons[xx][yy].carved;
            }
        }
        return pixels;
    }

    private void close() {
        this.tile.m_6596_();
        this.f_96541_.m_91152_(null);
    }

    public void setPixel(int x, int y, boolean on) {
        this.tile.setPixel(x, y, on);
    }

    public void dragButtons(double mx, double my, boolean on) {
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                if (!this.buttons[xx][yy].m_5953_(mx, my)) continue;
                this.buttons[xx][yy].onDrag(mx, my, on);
            }
        }
    }

    private void clear() {
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                this.setPixel(xx, yy, false);
                this.buttons[xx][yy].carved = false;
            }
        }
    }

    protected void m_7856_() {
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                this.buttons[xx][yy] = new CarvingButton(this.f_96543_ / 2, 65, xx, yy, this::setPixel, this::dragButtons);
                this.m_7787_(this.buttons[xx][yy]);
                this.buttons[xx][yy].carved = this.tile.getPixel(xx, yy);
            }
        }
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CLEAR, b -> this.clear()).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ / 4 + 120, 96, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, b -> this.close()).m_252987_(this.f_96543_ / 2 + 4, this.f_96544_ / 4 + 120, 96, 20).m_253136_());
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        Lighting.m_84930_();
        this.m_280273_(graphics);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 40, 0xFFFFFF);
        Material[][] materials = PumpkinTextureGenerator.computePixelMaterialMap(this.getPixelMatrix(), this.tile.getPumpkinType());
        graphics.m_280168_().m_85836_();
        int ut = -1;
        int vt = -1;
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                if (this.buttons[xx][yy].isHovered()) {
                    ut = xx;
                    vt = yy;
                }
                this.buttons[xx][yy].setMaterial(materials[xx][yy]);
                this.buttons[xx][yy].m_88315_(graphics, mouseX, mouseY, partialTicks);
            }
        }
        if (ut != -1) {
            this.buttons[ut][vt].renderTooltip(graphics);
        }
        graphics.m_280168_().m_85849_();
        Lighting.m_84931_();
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }
}

