/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.client.gui;

import net.mehvahdjukaar.hauntedharvest.reg.ClientRegistry;
import net.mehvahdjukaar.moonlight.api.client.util.RenderUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;

public class CarvingButton
implements Renderable,
GuiEventListener,
NarratableEntry {
    public final int u;
    public final int v;
    public final int x;
    public final int y;
    public static final int SIZE = 6;
    protected boolean isHovered;
    protected boolean carved = false;
    protected boolean focused;
    private final IDraggable onDragged;
    private final IPressable onPress;
    private Material material;

    public CarvingButton(int centerX, int centerY, int u, int v, IPressable pressedAction, IDraggable dragAction) {
        this.x = centerX - (8 - u) * 6;
        this.y = centerY - -v * 6;
        this.u = u;
        this.v = v;
        this.onPress = pressedAction;
        this.onDragged = dragAction;
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    public void setCarved(boolean carved) {
        this.carved = carved;
    }

    public boolean getCarved() {
        return this.carved;
    }

    public void m_88315_(GuiGraphics matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.isHovered = this.m_5953_(mouseX, mouseY);
        this.renderButton(matrixStack);
    }

    private void renderButton(GuiGraphics graphics) {
        TextureAtlasSprite sprite = this.material.m_119204_();
        RenderUtil.blitSpriteSection((GuiGraphics)graphics, (int)this.x, (int)this.y, (int)6, (int)6, (float)this.u, (float)this.v, (int)1, (int)1, (TextureAtlasSprite)sprite);
    }

    public void renderTooltip(GuiGraphics graphics) {
        TextureAtlasSprite sprite = ClientRegistry.CARVING_OUTLINE.m_119204_();
        RenderUtil.blitSpriteSection((GuiGraphics)graphics, (int)(this.x - 1), (int)(this.y - 1), (int)8, (int)8, (float)0.0f, (float)0.0f, (int)1, (int)1, (TextureAtlasSprite)sprite);
        this.renderButton(graphics);
    }

    public void onClick(double mouseX, double mouseY) {
        this.carved = !this.carved;
        this.onPress.onPress(this.u, this.v, this.carved);
    }

    public void onRelease(double mouseX, double mouseY) {
    }

    public void onDrag(double mouseX, double mouseY, boolean on) {
        this.carved = on;
        this.onPress.onPress(this.u, this.v, this.carved);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean flag;
        if (this.isValidClickButton(button) && (flag = this.m_5953_(mouseX, mouseY))) {
            this.playDownSound(Minecraft.m_91087_().m_91106_());
            this.onClick(mouseX, mouseY);
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.isValidClickButton(button)) {
            this.onRelease(mouseX, mouseY);
            return true;
        }
        return false;
    }

    protected boolean isValidClickButton(int button) {
        return button == 0;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isValidClickButton(button)) {
            this.onDragged.onDragged(mouseX, mouseY, this.carved);
            return true;
        }
        return false;
    }

    public boolean isHovered() {
        return this.isHovered;
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseY >= (double)this.y && mouseX < (double)(this.x + 6) && mouseY < (double)(this.y + 6);
    }

    public void playDownSound(SoundManager handler) {
        handler.m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
    }

    public boolean m_93696_() {
        return this.focused;
    }

    public void m_93692_(boolean focused) {
        this.focused = focused;
    }

    public static interface IPressable {
        public void onPress(int var1, int var2, boolean var3);
    }

    public static interface IDraggable {
        public void onDragged(double var1, double var3, boolean var5);
    }
}

