/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.mehvahdjukaar.hauntedharvest.HauntedHarvest;
import net.mehvahdjukaar.hauntedharvest.entity.SplatteredEggEntity;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class SplatteredEggRenderer
extends EntityRenderer<SplatteredEggEntity> {
    public static final ResourceLocation TEXTURE = HauntedHarvest.res("textures/entity/egg/splattered_egg.png");
    public static final ResourceLocation TEXTURE_2 = HauntedHarvest.res("textures/entity/egg/splattered_egg_2.png");

    public SplatteredEggRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(SplatteredEggEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        pMatrixStack.m_85836_();
        pMatrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - pEntityYaw));
        pMatrixStack.m_85841_(0.0625f, 0.0625f, 0.0625f);
        VertexConsumer vertexconsumer = pBuffer.m_6299_(RenderType.m_110458_((ResourceLocation)this.getTextureLocation(pEntity)));
        this.renderPainting(pMatrixStack, vertexconsumer, pEntity);
        pMatrixStack.m_85849_();
        super.m_7392_((Entity)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }

    public ResourceLocation getTextureLocation(SplatteredEggEntity pEntity) {
        return pEntity.altTexture ? TEXTURE_2 : TEXTURE;
    }

    private void renderPainting(PoseStack poseStack, VertexConsumer consumer, SplatteredEggEntity entity) {
        PoseStack.Pose last = poseStack.m_85850_();
        Matrix4f matrix4f = last.m_252922_();
        Matrix3f matrix3f = last.m_252943_();
        float p = 8.0f;
        float n = -8.0f;
        int blockX = entity.m_146903_();
        int blockY = entity.m_146904_();
        int blockZ = entity.m_146907_();
        Direction dir = entity.m_6350_();
        switch (dir.m_122434_()) {
            case X: {
                blockZ = Mth.m_14107_((double)entity.m_20189_());
                break;
            }
            case Z: {
                blockX = Mth.m_14107_((double)entity.m_20185_());
                break;
            }
            case Y: {
                blockY = Mth.m_14107_((double)entity.m_20186_());
            }
        }
        int l1 = LevelRenderer.m_109541_((BlockAndTintGetter)entity.m_9236_(), (BlockPos)new BlockPos(blockX, blockY, blockZ));
        if (dir == Direction.DOWN) {
            this.vertex(matrix4f, matrix3f, consumer, p, -0.5f, 0.0f, 1.0f, n, 0, -1, 0, l1);
            this.vertex(matrix4f, matrix3f, consumer, n, -0.5f, 1.0f, 1.0f, n, 0, -1, 0, l1);
            this.vertex(matrix4f, matrix3f, consumer, n, -0.5f, 1.0f, 0.0f, p, 0, -1, 0, l1);
            this.vertex(matrix4f, matrix3f, consumer, p, -0.5f, 0.0f, 0.0f, p, 0, -1, 0, l1);
        } else if (dir == Direction.UP) {
            this.vertex(matrix4f, matrix3f, consumer, n, 0.5f, 0.0f, 1.0f, p, 0, 1, 0, l1);
            this.vertex(matrix4f, matrix3f, consumer, n, 0.5f, 1.0f, 1.0f, n, 0, 1, 0, l1);
            this.vertex(matrix4f, matrix3f, consumer, p, 0.5f, 1.0f, 0.0f, n, 0, 1, 0, l1);
            this.vertex(matrix4f, matrix3f, consumer, p, 0.5f, 0.0f, 0.0f, p, 0, 1, 0, l1);
        } else {
            this.vertex(matrix4f, matrix3f, consumer, p, n, 0.0f, 1.0f, -0.5f, 0, 0, 1, l1);
            this.vertex(matrix4f, matrix3f, consumer, n, n, 1.0f, 1.0f, -0.5f, 0, 0, 1, l1);
            this.vertex(matrix4f, matrix3f, consumer, n, p, 1.0f, 0.0f, -0.5f, 0, 0, 1, l1);
            this.vertex(matrix4f, matrix3f, consumer, p, p, 0.0f, 0.0f, -0.5f, 0, 0, 1, l1);
        }
    }

    private void vertex(Matrix4f matrix4f, Matrix3f matrix3f, VertexConsumer vertexConsumer, float x, float y, float u, float v, float z, int nx, int ny, int nz, int light) {
        vertexConsumer.m_252986_(matrix4f, x, y, z).m_6122_(255, 255, 255, 255).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, (float)nx, (float)ny, (float)nz).m_5752_();
    }
}

