/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.client;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import net.mehvahdjukaar.hauntedharvest.blocks.PumpkinType;
import net.mehvahdjukaar.hauntedharvest.client.CarvingManager;
import net.mehvahdjukaar.hauntedharvest.reg.ClientRegistry;
import net.mehvahdjukaar.moonlight.api.client.texture_renderer.FrameBufferBackedDynamicTexture;
import net.mehvahdjukaar.moonlight.api.client.texture_renderer.RenderedTexturesManager;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.resources.textures.SpriteUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import org.joml.Matrix4f;

public class PumpkinTextureGenerator {
    private static DynamicTexture dummy = null;
    private static ResourceLocation dummyLocation = null;

    public static void drawCarving(DynamicTexture texture, CarvingManager.Carving carving) {
        boolean[][] pixels = carving.getPixels();
        Material[][] materials = PumpkinTextureGenerator.computePixelMaterialMap(pixels, carving.getType());
        for (int y = 0; y < pixels.length && y < 16; ++y) {
            for (int x = 0; x < pixels[y].length && x < 16; ++x) {
                int c = ClientHelper.getPixelRGBA((TextureAtlasSprite)materials[x][y].m_119204_(), (int)0, (int)x, (int)y);
                texture.m_117991_().m_84988_(x, y, c);
            }
        }
        texture.m_117985_();
    }

    public static Material[][] computePixelMaterialMap(boolean[][] pixels, PumpkinType pumpkinType) {
        Type[][] colors = new Type[16][16];
        PumpkinTextureGenerator.forEachPixel((Object[][])colors, (j, i) -> {
            colors[j.intValue()][i.intValue()] = !pixels[j][i] ? Type.UNCARVED : (PumpkinTextureGenerator.shouldShade(colors, j, i) ? Type.SHADE : Type.BACKGROUND);
        });
        PumpkinTextureGenerator.addExtraShade(colors);
        PumpkinTextureGenerator.forEachPixel((Object[][])colors, (j, i) -> PumpkinTextureGenerator.addHighlight(colors, j, i));
        Object[][] materials = new Material[16][16];
        PumpkinTextureGenerator.forEachPixel(materials, (arg_0, arg_1) -> PumpkinTextureGenerator.lambda$computePixelMaterialMap$2((Material[][])materials, pumpkinType, colors, arg_0, arg_1));
        return materials;
    }

    private static void addExtraShade(Type[][] px) {
        ArrayList shades = new ArrayList();
        PumpkinTextureGenerator.forEachPixel((Object[][])px, (j, i) -> {
            if (!PumpkinTextureGenerator.isUnCarved(px, j, i) && PumpkinTextureGenerator.isShaded(px, j, i - 1)) {
                if (PumpkinTextureGenerator.isShaded(px, j - 1, i) && PumpkinTextureGenerator.isShaded(px, j + 1, i) && (PumpkinTextureGenerator.isShaded(px, j - 1, i + 1) || PumpkinTextureGenerator.isShaded(px, j + 1, i + 1))) {
                    shades.add(Pair.of((Object)j, (Object)i));
                }
                if (PumpkinTextureGenerator.isShaded(px, j, i + 1) && (PumpkinTextureGenerator.isShaded(px, j + 1, i - 1) && PumpkinTextureGenerator.isShaded(px, j - 1, i) || PumpkinTextureGenerator.isShaded(px, j - 1, i - 1) && PumpkinTextureGenerator.isShaded(px, j + 1, i))) {
                    shades.add(Pair.of((Object)j, (Object)i));
                }
            }
        });
        shades.forEach(p -> {
            px[((Integer)p.getFirst()).intValue()][((Integer)p.getSecond()).intValue()] = Type.SHADE;
        });
    }

    private static void addHighlight(Type[][] px, int j, int i) {
        if (!(!PumpkinTextureGenerator.isUnCarved(px, j, i) || PumpkinTextureGenerator.isUnCarved(px, j - 1, i) && PumpkinTextureGenerator.isUnCarved(px, j, i - 1))) {
            px[j][i] = Type.HIGHLIGHT;
        }
    }

    private static boolean shouldShade(Type[][] px, int j, int i) {
        return PumpkinTextureGenerator.isUnCarved(px, j - 1, i) || PumpkinTextureGenerator.isUnCarved(px, j, i - 1);
    }

    private static boolean isUnCarved(Type[][] px, int j, int i) {
        if (j < 0 || i < 0 || j > 15 || i > 15) {
            return true;
        }
        Type t = px[j][i];
        return t == Type.UNCARVED || t == Type.HIGHLIGHT;
    }

    private static boolean isShaded(Type[][] px, int j, int i) {
        if (j < 0 || i < 0 || j > 15 || i > 15) {
            return true;
        }
        return px[j][i] == Type.SHADE;
    }

    public static void forEachPixel(Object[][] px, BiConsumer<Integer, Integer> function) {
        for (int j = 0; j < px.length; ++j) {
            for (int i = 0; i < px[j].length; ++i) {
                function.accept(j, i);
            }
        }
    }

    public static void drawBlur(FrameBufferBackedDynamicTexture t, CarvingManager.Carving carving) {
        boolean[][] pixels = carving.getPixels();
        if (dummyLocation == null) {
            dummy = new DynamicTexture(18, 18, false);
            dummyLocation = Minecraft.m_91087_().m_91097_().m_118490_("carving/", dummy);
        }
        NativeImage p = dummy.m_117991_();
        SpriteUtils.forEachPixel((NativeImage)p, (T x, U y) -> {
            int alpha = 0;
            if (x == 0 || x == 17 || y == 0 || y == 17 || !pixels[x - 1][y - 1]) {
                alpha = 255;
            }
            p.m_84988_(x.intValue(), y.intValue(), FastColor.ABGR32.m_266248_((int)alpha, (int)0, (int)0, (int)0));
        });
        dummy.m_117985_();
        dummy.m_117960_(true, false);
        RenderedTexturesManager.drawAsInGUI((FrameBufferBackedDynamicTexture)t, s -> {
            float u0 = 0.055555556f;
            float u1 = 0.9444444f;
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)dummyLocation);
            Matrix4f matrix = s.m_85850_().m_252922_();
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.disableBlend();
            RenderSystem.setShader(ClientRegistry::getBlur);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferBuilder.m_252986_(matrix, 0.0f, 16.0f, 0.0f).m_7421_(u0, u0).m_5752_();
            bufferBuilder.m_252986_(matrix, 16.0f, 16.0f, 0.0f).m_7421_(u1, u0).m_5752_();
            bufferBuilder.m_252986_(matrix, 16.0f, 0.0f, 0.0f).m_7421_(u1, u1).m_5752_();
            bufferBuilder.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_7421_(u0, u1).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        });
        t.m_117960_(true, false);
    }

    private static /* synthetic */ void lambda$computePixelMaterialMap$2(Material[][] materials, PumpkinType pumpkinType, Type[][] colors, Integer j, Integer i) {
        materials[j.intValue()][i.intValue()] = ClientRegistry.getMaterial(pumpkinType, colors[j][i].ordinal());
    }

    public static enum Type {
        UNCARVED,
        SHADE,
        BACKGROUND,
        HIGHLIGHT;

    }
}

