/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.blocks;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.mehvahdjukaar.hauntedharvest.blocks.ModCarvedPumpkinBlock;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

public class PumpkinType {
    private static final Map<String, PumpkinType> TYPES = new HashMap<String, PumpkinType>();
    private static final Map<Item, PumpkinType> TORCH_MAP = new Object2ObjectOpenHashMap();
    public static final PumpkinType NORMAL = PumpkinType.register(new PumpkinType("carved_pumpkin", () -> null, ModRegistry.CARVED_PUMPKIN, () -> Blocks.f_50143_));
    public static final PumpkinType JACK = PumpkinType.register(new PumpkinType("jack_o_lantern", () -> Items.f_42000_, ModRegistry.JACK_O_LANTERN, () -> Blocks.f_50144_));
    private final String name;
    private final Supplier<? extends Item> torch;
    private final Supplier<? extends ModCarvedPumpkinBlock> pumpkin;
    private final Supplier<? extends Block> vanillaPumpkin;

    public PumpkinType(String name, Supplier<? extends Item> torch, Supplier<? extends ModCarvedPumpkinBlock> pumpkin, Supplier<? extends Block> vanillaPumpkin) {
        this.name = name;
        this.torch = torch;
        this.pumpkin = pumpkin;
        this.vanillaPumpkin = vanillaPumpkin;
    }

    public Item getTorch() {
        return this.torch.get();
    }

    public Block getPumpkin() {
        return (Block)this.pumpkin.get();
    }

    public Block getVanillaPumpkin() {
        return this.vanillaPumpkin.get();
    }

    public String getName() {
        return this.name;
    }

    public boolean isJackOLantern() {
        return this != NORMAL;
    }

    public static PumpkinType byName(String type) {
        return TYPES.getOrDefault(type, NORMAL);
    }

    @Nullable
    public static PumpkinType getFromTorch(Item torch) {
        return TORCH_MAP.get(torch);
    }

    public static PumpkinType register(PumpkinType pumpkinType) {
        Preconditions.checkArgument((boolean)TORCH_MAP.isEmpty(), (Object)"Pumpkin type must be registered in mod init as it will affect registered blocks");
        TYPES.put(pumpkinType.name, pumpkinType);
        return pumpkinType;
    }

    public static Collection<PumpkinType> getTypes() {
        return TYPES.values();
    }

    public static void setup() {
        for (PumpkinType pumpkinType : TYPES.values()) {
            TORCH_MAP.put(pumpkinType.getTorch(), pumpkinType);
        }
    }
}

