/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.blocks;

import net.mehvahdjukaar.hauntedharvest.blocks.CornBaseBlock;
import net.mehvahdjukaar.hauntedharvest.blocks.CornMiddleBlock;
import net.mehvahdjukaar.hauntedharvest.blocks.CornTopBlock;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.block.IBeeGrowable;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCornBlock
extends CropBlock
implements IBeeGrowable {
    protected AbstractCornBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{this.m_7959_()});
    }

    public boolean m_6724_(BlockState state) {
        return !this.m_52307_(state);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        float f;
        if (!PlatHelper.isAreaLoaded((LevelReader)level, (BlockPos)pos, (int)1)) {
            return;
        }
        if (level.m_45524_(pos, 0) >= 9 && (double)level.f_46441_.m_188501_() < 0.6 && this.m_7370_((LevelReader)level, pos, state, level.f_46443_) && ForgeHelper.onCropsGrowPre((ServerLevel)level, (BlockPos)pos, (BlockState)state, (random.m_188503_((int)(30.0f / (f = AbstractCornBlock.m_52272_((Block)this, (BlockGetter)level, (BlockPos)pos))) + 1) == 0 ? 1 : 0) != 0)) {
            this.growCropBy((Level)level, pos, state, 1);
            ForgeHelper.onCropsGrowPost((ServerLevel)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public void growCropBy(Level level, BlockPos pos, BlockState state, int increment) {
        int maxAge;
        if (increment <= 0) {
            return;
        }
        int newAge = this.m_52305_(state) + increment;
        if (newAge > (maxAge = this.m_7419_())) {
            BlockPos above = pos.m_7494_();
            BlockState aboveState = level.m_8055_(above);
            Block block = aboveState.m_60734_();
            if (block instanceof AbstractCornBlock) {
                AbstractCornBlock cm = (AbstractCornBlock)block;
                cm.growCropBy(level, above, aboveState, increment);
            }
        } else {
            Block top = this.getTopBlock();
            if (newAge == maxAge && top != null) {
                level.m_7731_(pos.m_7494_(), top.m_49966_(), 2);
            }
            level.m_7731_(pos, this.m_52289_(newAge), 2);
        }
    }

    public void m_52263_(Level level, BlockPos pos, BlockState state) {
        this.growCropBy(level, pos, state, this.m_7125_(level));
    }

    public boolean getPollinated(Level level, BlockPos pos, BlockState state) {
        this.growCropBy(level, pos, state, 1);
        return true;
    }

    protected ItemLike m_6404_() {
        return (ItemLike)ModRegistry.KERNELS.get();
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        int maxAge;
        int age = this.m_52305_(state);
        if (age + 1 < (maxAge = this.m_7419_())) {
            return true;
        }
        BlockPos above = pos.m_7494_();
        BlockState aboveState = level.m_8055_(above);
        if (age == maxAge) {
            AbstractCornBlock cb;
            Block block = aboveState.m_60734_();
            return block instanceof AbstractCornBlock && (cb = (AbstractCornBlock)block).m_7370_(level, above, aboveState, false);
        }
        return this.getTopBlock() == null || aboveState.m_247087_();
    }

    protected int m_7125_(Level level) {
        return super.m_7125_(level) / 3;
    }

    @Nullable
    protected abstract Block getTopBlock();

    public abstract int getHeight();

    public boolean isPlantFullyGrown(BlockState state, BlockPos pos, Level level) {
        Block block;
        while ((block = state.m_60734_()) instanceof AbstractCornBlock) {
            AbstractCornBlock cb = (AbstractCornBlock)block;
            if (!cb.m_52307_(state)) {
                return false;
            }
            if (cb.getTopBlock() == null) {
                return true;
            }
            pos = pos.m_7494_();
            state = level.m_8055_(pos);
        }
        return false;
    }

    public static boolean spawn(BlockPos pos, LevelAccessor level, int age) {
        if (level.m_8055_(pos).m_60795_()) {
            boolean top = false;
            if (age > 2) {
                if (!level.m_8055_(pos.m_7494_()).m_60795_()) {
                    return false;
                }
                BlockPos above1 = pos.m_7494_();
                if (age > 4) {
                    BlockPos above = pos.m_6630_(2);
                    if (!level.m_8055_(above).m_60795_()) {
                        return false;
                    }
                    top = true;
                    level.m_7731_(above, (BlockState)ModRegistry.CORN_TOP.get().m_49966_().m_61124_((Property)CornTopBlock.AGE, (Comparable)Integer.valueOf(Math.min(age - 5, 1))), 2);
                }
                level.m_7731_(above1, (BlockState)ModRegistry.CORN_MIDDLE.get().m_49966_().m_61124_((Property)CornMiddleBlock.AGE, (Comparable)Integer.valueOf(Math.min(age - 3, 2))), 2);
            }
            level.m_7731_(pos, (BlockState)ModRegistry.CORN_BASE.get().m_49966_().m_61124_((Property)CornBaseBlock.AGE, (Comparable)Integer.valueOf(Math.min(age, 3))), 2);
            if (top && level.m_8055_(pos).m_60795_()) {
                boolean bl = true;
            }
            return true;
        }
        return false;
    }
}

