/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.ai;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.mehvahdjukaar.hauntedharvest.HauntedHarvest;
import net.mehvahdjukaar.hauntedharvest.ai.AskCandy;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.mehvahdjukaar.hauntedharvest.reg.ModTags;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;

public class RemovePumpkin
extends Behavior<Villager> {
    private final float speedModifier;
    private int ticksSinceReached = 0;
    private int cooldown = 600;
    protected int lastBreakProgress = -1;

    public RemovePumpkin(float speed) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26374_, (Object)MemoryStatus.VALUE_ABSENT, ModRegistry.PUMPKIN_POS.get(), (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT), 270, 350);
        this.speedModifier = speed * 1.1f;
    }

    protected boolean checkExtraStartConditions(ServerLevel pLevel, Villager pOwner) {
        if (HauntedHarvest.isHalloweenSeason((Level)pLevel)) {
            return false;
        }
        if (this.cooldown-- > 0) {
            return false;
        }
        if (!PlatHelper.isMobGriefingOn((Level)pLevel, (Entity)pOwner)) {
            this.cooldown = 1200;
            return false;
        }
        GlobalPos globalpos = (GlobalPos)pOwner.m_6274_().m_21952_(ModRegistry.PUMPKIN_POS.get()).get();
        return globalpos.m_122640_() == pLevel.m_46472_() && !pOwner.m_6162_();
    }

    protected void start(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        this.cooldown = 20 * (5 + pLevel.f_46441_.m_188503_(20)) + pLevel.f_46441_.m_188503_(20);
        this.ticksSinceReached = 0;
        this.lastBreakProgress = -1;
        GlobalPos globalpos = (GlobalPos)pEntity.m_6274_().m_21952_(ModRegistry.PUMPKIN_POS.get()).get();
        pEntity.m_6274_().m_21936_(MemoryModuleType.f_26374_);
        pEntity.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(globalpos.m_122646_(), this.speedModifier, 1));
        AskCandy.displayAsHeldItem(pEntity, new ItemStack((ItemLike)Items.f_42386_));
    }

    protected void stop(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        super.m_6732_(pLevel, (LivingEntity)pEntity, pGameTime);
        AskCandy.clearHeldItem(pEntity);
    }

    protected boolean canStillUse(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        return pEntity.m_6274_().m_21874_(ModRegistry.PUMPKIN_POS.get());
    }

    protected void tick(ServerLevel pLevel, Villager pOwner, long pGameTime) {
        BlockPos pos = ((GlobalPos)pOwner.m_6274_().m_21952_(ModRegistry.PUMPKIN_POS.get()).get()).m_122646_();
        pOwner.m_6274_().m_21936_(MemoryModuleType.f_26374_);
        pOwner.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(pos, this.speedModifier, 2));
        pOwner.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new BlockPosTracker(pos));
        if (pos.m_203195_((Position)pOwner.m_20182_(), 2.3)) {
            ++this.ticksSinceReached;
            BlockState state = pLevel.m_8055_(pos);
            if (!state.m_204336_(ModTags.PUMPKINS)) {
                pOwner.m_6274_().m_21936_(ModRegistry.PUMPKIN_POS.get());
            } else {
                int k = (int)((float)this.ticksSinceReached / 20.0f * 10.0f);
                if (k != this.lastBreakProgress) {
                    pLevel.m_6801_(pOwner.m_19879_(), pos, k);
                    this.lastBreakProgress = k;
                }
                if (this.ticksSinceReached > 20) {
                    SoundType soundtype = state.m_60827_();
                    pLevel.m_5594_(null, pos, soundtype.m_56775_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
                    pOwner.m_6274_().m_21936_(ModRegistry.PUMPKIN_POS.get());
                    pLevel.m_46961_(pos, true);
                }
            }
        }
    }
}

