/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.ai;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.mehvahdjukaar.hauntedharvest.HauntedHarvest;
import net.mehvahdjukaar.hauntedharvest.ai.AskCandy;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.mehvahdjukaar.hauntedharvest.reg.ModTags;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.Nullable;

public class PlacePumpkin
extends Behavior<Villager> {
    private final float speedModifier;
    private BlockPos targetPos;
    private int ticksSinceReached = 0;
    private int cooldown = 600;

    public PlacePumpkin(float speed) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26374_, (Object)MemoryStatus.VALUE_ABSENT, ModRegistry.PUMPKIN_POS.get(), (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT), 190, 270);
        this.speedModifier = speed;
    }

    protected boolean checkExtraStartConditions(ServerLevel pLevel, Villager pOwner) {
        if (!HauntedHarvest.isHalloweenSeason((Level)pLevel)) {
            return false;
        }
        if (this.cooldown-- > 0) {
            return false;
        }
        if (pOwner.m_6162_()) {
            return false;
        }
        if (pLevel.f_46441_.m_188503_(2) == 0) {
            this.cooldown = 400;
            return false;
        }
        if (!PlatHelper.isMobGriefingOn((Level)pLevel, (Entity)pOwner)) {
            this.cooldown = 1200;
            return false;
        }
        return true;
    }

    protected void start(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        this.cooldown = 20 * (15 + pLevel.f_46441_.m_188503_(10)) + pLevel.f_46441_.m_188503_(20);
        this.ticksSinceReached = 0;
        this.targetPos = PlacePumpkin.getValidPumpkinPos(pLevel, (LivingEntity)pEntity);
        if (this.targetPos != null) {
            pEntity.m_6274_().m_21936_(MemoryModuleType.f_26374_);
            pEntity.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(this.targetPos, this.speedModifier, 1));
            AskCandy.displayAsHeldItem(pEntity, new ItemStack((ItemLike)Items.f_42046_));
        }
    }

    protected void stop(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        super.m_6732_(pLevel, (LivingEntity)pEntity, pGameTime);
        AskCandy.clearHeldItem(pEntity);
        this.targetPos = null;
    }

    protected boolean canStillUse(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        return this.targetPos != null && PlacePumpkin.isValidPlacementSpot(pLevel, this.targetPos);
    }

    protected void tick(ServerLevel pLevel, Villager pOwner, long pGameTime) {
        if (this.targetPos != null) {
            pOwner.m_6274_().m_21936_(MemoryModuleType.f_26374_);
            pOwner.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(this.targetPos, this.speedModifier, 2));
            pOwner.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new BlockPosTracker(this.targetPos));
            if (this.targetPos.m_203195_((Position)pOwner.m_20182_(), 2.3)) {
                ++this.ticksSinceReached;
                if (this.ticksSinceReached > 20) {
                    BlockState state = Blocks.f_50133_.m_49966_();
                    pLevel.m_46597_(this.targetPos, state);
                    SoundType soundtype = state.m_60827_();
                    pLevel.m_5594_(null, this.targetPos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
                    pOwner.m_6274_().m_21879_(ModRegistry.PUMPKIN_POS.get(), (Object)GlobalPos.m_122643_((ResourceKey)pLevel.m_46472_(), (BlockPos)this.targetPos));
                    this.targetPos = null;
                }
            }
        }
    }

    @Nullable
    private static BlockPos getValidPumpkinPos(ServerLevel pLevel, LivingEntity pWalker) {
        RandomSource random = pWalker.m_217043_();
        BlockPos blockpos = pWalker.m_20183_();
        for (int i = 0; i < 6; ++i) {
            BlockPos pos = blockpos.m_7918_(random.m_188503_(20) - 10, random.m_188503_(6) - 3, random.m_188503_(20) - 10);
            if (!PlacePumpkin.isValidPlacementSpot(pLevel, pos)) continue;
            return pos;
        }
        return null;
    }

    public static boolean isValidPlacementSpot(ServerLevel serverLevel, BlockPos pos) {
        BlockState state;
        if (serverLevel.m_45527_(pos) && (double)serverLevel.m_5452_(Heightmap.Types.MOTION_BLOCKING, pos).m_123342_() >= 64.0 && (state = serverLevel.m_8055_(pos)).m_247087_() && state.m_60819_().m_76178_()) {
            BlockState below = serverLevel.m_8055_(pos.m_7495_());
            return below.m_204336_(ModTags.PUMPKIN_SUPPORT);
        }
        return false;
    }
}

