/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.mehvahdjukaar.hauntedharvest.HauntedHarvest;
import net.mehvahdjukaar.hauntedharvest.ai.AskCandy;
import net.mehvahdjukaar.hauntedharvest.ai.CarvePumpkin;
import net.mehvahdjukaar.hauntedharvest.ai.EatCandy;
import net.mehvahdjukaar.hauntedharvest.ai.FindAdultThatHasCandy;
import net.mehvahdjukaar.hauntedharvest.ai.GiveCandyToBabies;
import net.mehvahdjukaar.hauntedharvest.ai.GoToAttackTargetIfFurtherThan;
import net.mehvahdjukaar.hauntedharvest.ai.LightUpPumpkin;
import net.mehvahdjukaar.hauntedharvest.ai.PlacePumpkin;
import net.mehvahdjukaar.hauntedharvest.ai.RemovePumpkin;
import net.mehvahdjukaar.hauntedharvest.ai.ThrowEggs;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.mehvahdjukaar.hauntedharvest.reg.ModTags;
import net.mehvahdjukaar.moonlight.api.entity.VillagerAIHooks;
import net.mehvahdjukaar.moonlight.api.events.IVillagerBrainEvent;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.GoToClosestVillage;
import net.minecraft.world.entity.ai.behavior.InsideBrownianWalk;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.StrollAroundPoi;
import net.minecraft.world.entity.ai.behavior.UpdateActivityFromSchedule;
import net.minecraft.world.entity.ai.behavior.VillageBoundRandomStroll;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class HalloweenVillagerAI {
    private static final Set<Item> BABY_VILLAGER_EATABLE = new HashSet<Item>();

    public static void init() {
        VillagerAIHooks.addBrainModification(HalloweenVillagerAI::onVillagerBrainInitialize);
    }

    public static void setup() {
        VillagerAIHooks.registerMemory((MemoryModuleType)MemoryModuleType.f_26372_);
        VillagerAIHooks.registerMemory(ModRegistry.PUMPKIN_POS.get());
        VillagerAIHooks.registerMemory(ModRegistry.NEAREST_PUMPKIN.get());
    }

    public static void onVillagerBrainInitialize(IVillagerBrainEvent event) {
        Villager villager = event.getVillager();
        if (HauntedHarvest.isHalloweenSeason(villager.m_9236_())) {
            event.addSensor(ModRegistry.PUMPKIN_POI_SENSOR.get());
            if (villager.m_6162_()) {
                event.addOrReplaceActivity(ModRegistry.TRICK_OR_TREAT.get(), HalloweenVillagerAI.getTrickOrTreatPackage(0.5f));
                event.addTaskToActivity(Activity.f_37981_, Pair.of((Object)9, (Object)((Object)new EatCandy(100, 130))));
                event.addTaskToActivity(Activity.f_37981_, Pair.of((Object)10, (Object)((Object)new CarvePumpkin(0.5f))));
                event.scheduleActivity(ModRegistry.TRICK_OR_TREAT.get(), HauntedHarvest.getSeasonManager().getTrickOrTreatStart(), HauntedHarvest.getSeasonManager().getTrickOrTreatEnd());
            } else {
                event.addTaskToActivity(Activity.f_37982_, Pair.of((Object)1, (Object)((Object)new GiveCandyToBabies())));
                event.addTaskToActivity(Activity.f_37979_, Pair.of((Object)3, (Object)((Object)new PlacePumpkin(0.5f))));
            }
        } else if (!villager.m_6162_()) {
            event.addTaskToActivity(Activity.f_37979_, Pair.of((Object)3, (Object)((Object)new RemovePumpkin(0.5f))));
        }
    }

    private static ImmutableList<Pair<Integer, ? extends BehaviorControl<? super Villager>>> getTrickOrTreatPackage(float speed) {
        return ImmutableList.of((Object)Pair.of((Object)1, (Object)((Object)new FindAdultThatHasCandy(26, speed * 1.15f))), (Object)Pair.of((Object)1, (Object)new MoveToTargetSink(210, 320)), (Object)Pair.of((Object)0, (Object)((Object)new AskCandy(2900, 3800))), (Object)Pair.of((Object)3, (Object)((Object)new GoToAttackTargetIfFurtherThan(speed * 1.25f, 10.0f))), (Object)Pair.of((Object)2, (Object)((Object)new ThrowEggs(12))), (Object)Pair.of((Object)7, (Object)((Object)new LightUpPumpkin(speed))), (Object)Pair.of((Object)10, (Object)new RunOne((Map)ImmutableMap.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26374_, (Object)MemoryStatus.VALUE_ABSENT), (List)ImmutableList.of((Object)Pair.of((Object)InsideBrownianWalk.m_258053_((float)speed), (Object)7), (Object)Pair.of((Object)GoToClosestVillage.m_257375_((float)speed, (int)4), (Object)10), (Object)Pair.of((Object)StrollAroundPoi.m_257894_((MemoryModuleType)MemoryModuleType.f_26362_, (float)1.0f, (int)50), (Object)2), (Object)Pair.of((Object)VillageBoundRandomStroll.m_258010_((float)speed, (int)25, (int)7), (Object)1)))), (Object)Pair.of((Object)99, (Object)UpdateActivityFromSchedule.m_257835_()));
    }

    public static boolean isTrickOrTreater(LivingEntity entity) {
        return entity.m_6162_() && entity.m_21205_().m_150930_(Items.f_151058_);
    }

    public static boolean isCandyOrApple(ItemStack stack) {
        return BABY_VILLAGER_EATABLE.contains(stack.m_41720_());
    }

    public static boolean hasCandyOrApple(SimpleContainer inventory) {
        return inventory.m_18949_(BABY_VILLAGER_EATABLE);
    }

    public static void refreshCandies() {
        BABY_VILLAGER_EATABLE.clear();
        HashSet<Item> temp = new HashSet<Item>();
        for (Holder p : BuiltInRegistries.f_257033_.m_206058_(ModTags.SWEETS)) {
            temp.add((Item)p.m_203334_());
        }
        temp.add(ModRegistry.GRIM_APPLE.get());
        temp.add(ModRegistry.ROTTEN_APPLE.get());
        for (Item i : temp) {
            if (i == Items.f_41852_) continue;
            BABY_VILLAGER_EATABLE.add(i);
        }
    }
}

