/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.ai;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.mehvahdjukaar.hauntedharvest.ai.ThrowEggs;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.npc.Villager;

public class GoToAttackTargetIfFurtherThan
extends Behavior<Villager> {
    private final float speedModifier;
    private final float range;

    public GoToAttackTargetIfFurtherThan(float speedModifier, float range) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_148205_, (Object)MemoryStatus.REGISTERED));
        this.speedModifier = speedModifier;
        this.range = range;
    }

    protected boolean checkExtraStartConditions(ServerLevel pLevel, Villager pOwner) {
        LivingEntity livingentity = pOwner.m_6274_().m_21952_(MemoryModuleType.f_26372_).orElse(null);
        if (livingentity == null || !livingentity.m_6084_()) {
            ThrowEggs.clearAnger(pOwner);
            return false;
        }
        return true;
    }

    protected void start(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        LivingEntity livingentity = (LivingEntity)pEntity.m_6274_().m_21952_(MemoryModuleType.f_26372_).get();
        if (BehaviorUtils.m_22667_((LivingEntity)pEntity, (LivingEntity)livingentity) && !this.isOutOfRange((LivingEntity)pEntity, livingentity, this.range - 2.0f)) {
            this.clearWalkTarget((LivingEntity)pEntity);
        } else {
            this.setWalkAndLookTarget((LivingEntity)pEntity, livingentity);
        }
    }

    private boolean isOutOfRange(LivingEntity entity, LivingEntity other, float range) {
        return entity.m_20275_(other.m_20185_(), other.m_20186_(), other.m_20189_()) > (double)(range * range);
    }

    private void setWalkAndLookTarget(LivingEntity p_24038_, LivingEntity p_24039_) {
        Brain brain = p_24038_.m_6274_();
        brain.m_21879_(MemoryModuleType.f_26371_, (Object)new EntityTracker((Entity)p_24039_, true));
        WalkTarget walktarget = new WalkTarget((PositionTracker)new EntityTracker((Entity)p_24039_, false), this.speedModifier, 5);
        brain.m_21879_(MemoryModuleType.f_26370_, (Object)walktarget);
    }

    private void clearWalkTarget(LivingEntity p_24036_) {
        p_24036_.m_6274_().m_21936_(MemoryModuleType.f_26370_);
    }
}

