/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.ai;

import java.util.EnumSet;
import net.mehvahdjukaar.hauntedharvest.HauntedHarvest;
import net.mehvahdjukaar.hauntedharvest.ai.GiveCandyToBabies;
import net.mehvahdjukaar.hauntedharvest.ai.IHalloweenVillager;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class GiveCandyWitchGoal
extends Goal {
    protected final int randomInterval;
    protected final Mob witch;
    protected Villager target;
    private boolean hasGivenCandy = false;
    private int tickSinceStarted = 0;
    private int timeToGiveCandy = 0;

    public GiveCandyWitchGoal(Mob pMob) {
        this.randomInterval = 5;
        this.witch = pMob;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (!HauntedHarvest.isTrickOrTreatTime(this.witch.m_9236_())) {
            return false;
        }
        if (this.randomInterval > 0 && this.witch.m_217043_().m_188503_(this.randomInterval) != 0) {
            return false;
        }
        this.findTarget();
        return this.target != null;
    }

    protected AABB getTargetSearchArea(double pTargetDistance) {
        return this.witch.m_20191_().m_82377_(pTargetDistance, 4.0, pTargetDistance);
    }

    protected void findTarget() {
        this.target = this.witch.m_9236_().m_6443_(Villager.class, this.getTargetSearchArea(4.0), this::isValidTarget).stream().findAny().orElse(null);
    }

    private boolean isValidTarget(Villager target) {
        return GiveCandyToBabies.isValidTrickOrTreater((LivingEntity)this.witch, (LivingEntity)target);
    }

    public void m_8056_() {
        this.witch.m_21391_((Entity)this.target, 45.0f, 80.0f);
        super.m_8056_();
        this.timeToGiveCandy = 20 + this.witch.m_9236_().f_46441_.m_188503_(30);
        this.tickSinceStarted = 0;
        this.hasGivenCandy = false;
    }

    public void m_8041_() {
        super.m_8041_();
        this.hasGivenCandy = false;
        this.tickSinceStarted = 0;
    }

    public boolean m_8045_() {
        if (this.tickSinceStarted < 300 && !this.hasGivenCandy) {
            return this.target != null && this.target.m_6084_() && this.isValidTarget(this.target) && this.witch.m_21574_().m_148306_((Entity)this.target);
        }
        return false;
    }

    public void m_8037_() {
        this.witch.m_21563_().m_24946_(this.target.m_20185_(), this.target.m_20188_(), this.target.m_20189_());
        if (this.target != null && this.tickSinceStarted > this.timeToGiveCandy) {
            Level level = this.witch.m_9236_();
            int r = level.m_213780_().m_188503_(12);
            if (r == 0) {
                stack = new ItemStack((ItemLike)ModRegistry.GRIM_APPLE.get());
                GiveCandyToBabies.throwCandy((LivingEntity)this.witch, (LivingEntity)this.target, stack);
                level.m_7605_((Entity)this.witch, (byte)15);
            } else if (r < 5) {
                GiveCandyToBabies.spookVillager(this.target, (LivingEntity)this.witch);
                level.m_7605_((Entity)this.witch, (byte)15);
            } else {
                stack = new ItemStack((ItemLike)ModRegistry.ROTTEN_APPLE.get());
                GiveCandyToBabies.throwCandy((LivingEntity)this.witch, (LivingEntity)this.target, stack);
            }
            this.hasGivenCandy = true;
            Villager villager = this.target;
            if (villager instanceof IHalloweenVillager) {
                IHalloweenVillager e = (IHalloweenVillager)villager;
                e.hauntedharvest$setEntityOnCooldown((Entity)this.witch, 140);
            }
        }
        ++this.tickSinceStarted;
    }
}

